/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta.helper;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class StreamZip {
    private StreamZip() {
    }

    public static <A, B, C> Stream<C> zip(Stream<A> streamA, Stream<B> streamB, final BiFunction<A, B, C> zipper) {
        final Iterator iteratorA = streamA.iterator();
        final Iterator iteratorB = streamB.iterator();
        Iterator iteratorC = new Iterator<C>(){

            @Override
            public boolean hasNext() {
                return iteratorA.hasNext() && iteratorB.hasNext();
            }

            @Override
            public C next() {
                return zipper.apply(iteratorA.next(), iteratorB.next());
            }
        };
        boolean parallel = streamA.isParallel() || streamB.isParallel();
        return StreamZip.iteratorToFiniteStream(iteratorC, parallel);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }
}

