/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta.config;

import com.google.gson.JsonObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.villainy.lottaterracotta.config.LottaTerracottaConfig;

public class FlagRecipeCondition
implements ICondition {
    private final String flag;
    private final ResourceLocation loc;

    public FlagRecipeCondition(String flag, ResourceLocation loc) {
        this.flag = flag;
        this.loc = loc;
    }

    public ResourceLocation getID() {
        return this.loc;
    }

    public boolean test() {
        if (this.flag.equals("slabs")) {
            return LottaTerracottaConfig.enableSlabs;
        }
        if (this.flag.equals("stairs")) {
            return LottaTerracottaConfig.enableStairs;
        }
        if (this.flag.equals("walls")) {
            return LottaTerracottaConfig.enableWalls;
        }
        if (this.flag.equals("buttons")) {
            return LottaTerracottaConfig.enableButtons;
        }
        if (this.flag.equals("pressure_plates")) {
            return LottaTerracottaConfig.enablePressurePlates;
        }
        if (this.flag.equals("fences")) {
            return LottaTerracottaConfig.enableFences;
        }
        if (this.flag.equals("ladders")) {
            return LottaTerracottaConfig.enableLadders;
        }
        if (this.flag.equals("signs")) {
            return LottaTerracottaConfig.enableSigns;
        }
        if (this.flag.equals("levers")) {
            return LottaTerracottaConfig.enableLevers;
        }
        if (this.flag.equals("vertical_slabs")) {
            return LottaTerracottaConfig.enableVerticalSlabs;
        }
        if (this.flag.equals("tiles")) {
            return LottaTerracottaConfig.enableTiles;
        }
        return true;
    }

    public static class Serializer
    implements IConditionSerializer<FlagRecipeCondition> {
        private final ResourceLocation location;

        public Serializer(ResourceLocation location) {
            this.location = location;
        }

        public void write(JsonObject json, FlagRecipeCondition value) {
            json.addProperty("flag", value.flag);
        }

        public FlagRecipeCondition read(JsonObject json) {
            return new FlagRecipeCondition(json.getAsJsonPrimitive("flag").getAsString(), this.location);
        }

        public ResourceLocation getID() {
            return this.location;
        }
    }
}

