/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta.client;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class Atlases {
    private static final Map<DyeColor, RenderMaterial> TERRACOTTA_MATERIALS = Atlases.makeTerracottaMaterials();
    private static final RenderMaterial PLAIN_TERRACOTTA_MATERIAL = new RenderMaterial(net.minecraft.client.renderer.Atlases.field_228746_e_, new ResourceLocation("block/terracotta"));

    private Atlases() {
    }

    private static Map<DyeColor, RenderMaterial> makeTerracottaMaterials() {
        EnumMap<DyeColor, RenderMaterial> materials = new EnumMap<DyeColor, RenderMaterial>(DyeColor.class);
        for (DyeColor dyeColor : DyeColor.values()) {
            materials.put(dyeColor, new RenderMaterial(net.minecraft.client.renderer.Atlases.field_228746_e_, new ResourceLocation("block/" + dyeColor.func_176762_d() + "_terracotta")));
        }
        return materials;
    }

    public static RenderMaterial getTerracottaMaterial(DyeColor dyeColor) {
        if (dyeColor == null) {
            return PLAIN_TERRACOTTA_MATERIAL;
        }
        return TERRACOTTA_MATERIALS.get(dyeColor);
    }

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        ResourceLocation atlas = event.getMap().func_229223_g_();
        TERRACOTTA_MATERIALS.values().stream().filter(material -> material.func_229310_a_().equals((Object)atlas)).forEach(material -> event.addSprite(material.func_229313_b_()));
        event.addSprite(PLAIN_TERRACOTTA_MATERIAL.func_229313_b_());
    }
}

