/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.villainy.lottaterracotta.config.LottaTerracottaConfig;
import org.villainy.lottaterracotta.objectholders.TerracottaSignBlocks;
import org.villainy.lottaterracotta.tileEntities.TerracottaSignTileEntity;

public class TerracottaSignBlock
extends AbstractSignBlock {
    public DyeColor dyeColor;
    private final Map<BlockState, VoxelShape> cache = Maps.newConcurrentMap();

    private boolean isEnabled() {
        return LottaTerracottaConfig.enableSigns;
    }

    public TerracottaSignBlock(DyeColor dyeColor) {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151576_e, (DyeColor)dyeColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185851_d), WoodType.field_227038_a_);
        this.dyeColor = dyeColor;
        this.setRegistryName(dyeColor.func_176762_d() + "_terracotta_sign");
    }

    public TerracottaSignBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151676_q).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185851_d), WoodType.field_227038_a_);
        this.dyeColor = null;
        this.setRegistryName("terracotta_sign");
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208158_K, BlockStateProperties.field_208157_J, field_204613_a});
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TerracottaSignTileEntity();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        VoxelShape cached = this.cache.get(state);
        if (cached == null) {
            cached = VoxelShapes.func_197880_a();
            AttachFace face = (AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K);
            Direction facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            float u0 = 0.0f;
            float u1 = 1.0f;
            float offset = 0.02f;
            float v0 = 0.25f;
            float v1 = 0.75f;
            float thick = 0.085f;
            float w0 = 0.02f;
            float w1 = w0 + thick;
            float t1 = 1.0f - w0;
            float t0 = 1.0f - w1;
            if (face == AttachFace.FLOOR) {
                switch (facing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 + offset), (double)u1, (double)w1, (double)(v1 + offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)w0, (double)(v0 - offset), (double)u1, (double)w1, (double)(v1 - offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)w0, (double)u0, (double)(v1 - offset), (double)w1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)w0, (double)u0, (double)(v1 + offset), (double)w1, (double)u1);
                    }
                }
            } else if (face == AttachFace.CEILING) {
                switch (facing) {
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 - offset), (double)u1, (double)t1, (double)(v1 - offset));
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)t0, (double)(v0 + offset), (double)u1, (double)t1, (double)(v1 + offset));
                        break;
                    }
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 + offset), (double)t0, (double)u0, (double)(v1 + offset), (double)t1, (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)(v0 - offset), (double)t0, (double)u0, (double)(v1 - offset), (double)t1, (double)u1);
                    }
                }
            } else {
                switch (facing) {
                    case EAST: {
                        cached = VoxelShapes.func_197873_a((double)w0, (double)(v0 + offset), (double)u0, (double)w1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case WEST: {
                        cached = VoxelShapes.func_197873_a((double)t0, (double)(v0 + offset), (double)u0, (double)t1, (double)(v1 + offset), (double)u1);
                        break;
                    }
                    case SOUTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)w0, (double)u1, (double)(v1 + offset), (double)w1);
                        break;
                    }
                    case NORTH: {
                        cached = VoxelShapes.func_197873_a((double)u0, (double)(v0 + offset), (double)t0, (double)u1, (double)(v1 + offset), (double)t1);
                    }
                }
            }
            this.cache.put(state, cached);
        }
        return cached;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState state = this.func_176223_P();
        FluidState fluid = context.func_195991_k().func_204610_c(context.func_195995_a());
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction clickedFace = context.func_196000_l().func_176734_d();
        ArrayList directions = Lists.newArrayList((Object[])new Direction[]{clickedFace});
        Arrays.stream(context.func_196009_e()).filter(f -> f != clickedFace).forEach(directions::add);
        for (int i = 0; i < directions.size(); ++i) {
            Direction facing;
            AttachFace face;
            Direction lookDirection2;
            Direction lookDirection = (Direction)directions.get(i);
            Direction direction = lookDirection2 = i + 1 >= directions.size() ? Direction.NORTH : (Direction)directions.get(i + 1);
            if (lookDirection == Direction.DOWN) {
                face = AttachFace.FLOOR;
                facing = (lookDirection2.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).func_176734_d();
            } else if (lookDirection == Direction.UP) {
                face = AttachFace.CEILING;
                facing = (lookDirection2.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : lookDirection2).func_176734_d();
            } else {
                face = AttachFace.WALL;
                facing = lookDirection.func_176734_d();
            }
            state = (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208158_K, (Comparable)face)).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing);
            if (!state.func_196955_c((IWorldReader)world, pos)) continue;
            return (BlockState)state.func_206870_a((Property)field_204613_a, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    @Deprecated
    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177972_a(this.getEffectiveFacing(state).func_176734_d())).func_185904_a().func_76220_a();
    }

    private Direction getEffectiveFacing(BlockState state) {
        switch ((AttachFace)state.func_177229_b((Property)BlockStateProperties.field_208158_K)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == this.getEffectiveFacing(stateIn) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public static Stream<Block> allBlocks() {
        return Stream.of(new Block[]{TerracottaSignBlocks.UNCOLORED, TerracottaSignBlocks.WHITE, TerracottaSignBlocks.ORANGE, TerracottaSignBlocks.MAGENTA, TerracottaSignBlocks.LIGHT_BLUE, TerracottaSignBlocks.YELLOW, TerracottaSignBlocks.LIME, TerracottaSignBlocks.PINK, TerracottaSignBlocks.GRAY, TerracottaSignBlocks.LIGHT_GRAY, TerracottaSignBlocks.CYAN, TerracottaSignBlocks.PURPLE, TerracottaSignBlocks.BLUE, TerracottaSignBlocks.BROWN, TerracottaSignBlocks.GREEN, TerracottaSignBlocks.RED, TerracottaSignBlocks.BLACK});
    }
}

