/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta.blocks;

import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import org.villainy.lottaterracotta.config.LottaTerracottaConfig;
import org.villainy.lottaterracotta.helper.Shape;
import org.villainy.lottaterracotta.objectholders.TerracottaLadderBlocks;

public class TerracottaLadderBlock
extends LadderBlock {
    protected static final AxisAlignedBB LADDER_UNROTATED_AABB = Shape.getPixeledAABB(1.75, 0.0, 0.0, 14.25, 16.0, 1.5);
    protected static final VoxelShape LADDER_SOUTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Shape.getRotatedAABB(LADDER_UNROTATED_AABB, Direction.SOUTH, false));
    protected static final VoxelShape LADDER_EAST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Shape.getRotatedAABB(LADDER_UNROTATED_AABB, Direction.EAST, false));
    protected static final VoxelShape LADDER_WEST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Shape.getRotatedAABB(LADDER_UNROTATED_AABB, Direction.WEST, false));
    protected static final VoxelShape LADDER_NORTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)Shape.getRotatedAABB(LADDER_UNROTATED_AABB, Direction.NORTH, false));

    private boolean isEnabled() {
        return LottaTerracottaConfig.enableLadders;
    }

    public TerracottaLadderBlock(DyeColor dyeColor) {
        super(AbstractBlock.Properties.func_200952_a((Material)Material.field_151576_e, (DyeColor)dyeColor).func_226896_b_().func_200943_b(0.4f).func_200947_a(SoundType.field_185857_j));
        this.setRegistryName(dyeColor.func_176762_d() + "_terracotta_ladder");
    }

    public TerracottaLadderBlock() {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151676_q).func_200943_b(0.4f).func_200947_a(SoundType.field_185857_j));
        this.setRegistryName("terracotta_ladder");
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (group == ItemGroup.field_78027_g || this.isEnabled()) {
            super.func_149666_a(group, items);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)field_176382_a)) {
            case NORTH: {
                return LADDER_NORTH_AABB;
            }
            case SOUTH: {
                return LADDER_SOUTH_AABB;
            }
            case WEST: {
                return LADDER_WEST_AABB;
            }
        }
        return LADDER_EAST_AABB;
    }

    public static Stream<Block> allBlocks() {
        return Stream.of(new Block[]{TerracottaLadderBlocks.UNCOLORED, TerracottaLadderBlocks.WHITE, TerracottaLadderBlocks.ORANGE, TerracottaLadderBlocks.MAGENTA, TerracottaLadderBlocks.LIGHT_BLUE, TerracottaLadderBlocks.YELLOW, TerracottaLadderBlocks.LIME, TerracottaLadderBlocks.PINK, TerracottaLadderBlocks.GRAY, TerracottaLadderBlocks.LIGHT_GRAY, TerracottaLadderBlocks.CYAN, TerracottaLadderBlocks.PURPLE, TerracottaLadderBlocks.BLUE, TerracottaLadderBlocks.BROWN, TerracottaLadderBlocks.GREEN, TerracottaLadderBlocks.RED, TerracottaLadderBlocks.BLACK});
    }
}

