/*
 * Decompiled with CFR 0.152.
 */
package org.villainy.lottaterracotta;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.villainy.lottaterracotta.blocks.GlazedTerracottaSlabBlock;
import org.villainy.lottaterracotta.blocks.GlazedTerracottaTileBlock;
import org.villainy.lottaterracotta.blocks.TerracottaButtonBlock;
import org.villainy.lottaterracotta.blocks.TerracottaFenceBlock;
import org.villainy.lottaterracotta.blocks.TerracottaFenceGateBlock;
import org.villainy.lottaterracotta.blocks.TerracottaLadderBlock;
import org.villainy.lottaterracotta.blocks.TerracottaLeverBlock;
import org.villainy.lottaterracotta.blocks.TerracottaPressurePlateBlock;
import org.villainy.lottaterracotta.blocks.TerracottaSignBlock;
import org.villainy.lottaterracotta.blocks.TerracottaSlabBlock;
import org.villainy.lottaterracotta.blocks.TerracottaStairsBlock;
import org.villainy.lottaterracotta.blocks.TerracottaVerticalSlabBlock;
import org.villainy.lottaterracotta.blocks.TerracottaWallBlock;
import org.villainy.lottaterracotta.config.ConfigHelper;
import org.villainy.lottaterracotta.config.ConfigHolder;
import org.villainy.lottaterracotta.config.FlagRecipeCondition;
import org.villainy.lottaterracotta.items.TerracottaSignItem;
import org.villainy.lottaterracotta.items.helper.BlockItemHelper;
import org.villainy.lottaterracotta.network.OpenTerracottaSignEditor;
import org.villainy.lottaterracotta.objectholders.TerracottaSignBlocks;
import org.villainy.lottaterracotta.proxy.ClientProxy;
import org.villainy.lottaterracotta.proxy.CommonProxy;
import org.villainy.lottaterracotta.proxy.IProxy;
import org.villainy.lottaterracotta.tileEntities.TerracottaSignTileEntity;

@Mod(value="lottaterracotta")
public class LottaTerracotta {
    public static final String MODID = "lottaterracotta";
    public static final String CHANNEL = "lottaterracotta";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("lottaterracotta", "lottaterracotta")).clientAcceptedVersions("1.0"::equals).serverAcceptedVersions("1.0"::equals).networkProtocolVersion(() -> "1.0").simpleChannel();
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOG = LogManager.getLogger();

    public LottaTerracotta() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ConfigHolder.COMMON_SPEC);
        CraftingHelper.register((IConditionSerializer)new FlagRecipeCondition.Serializer(new ResourceLocation("lottaterracotta", "flag")));
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(proxy::onFMLCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.registerMessage(messageNumber++, OpenTerracottaSignEditor.class, OpenTerracottaSignEditor::encode, OpenTerracottaSignEditor::new, OpenTerracottaSignEditor::handle);
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            IForgeRegistry blockRegistry = event.getRegistry();
            Stream.of(DyeColor.values()).forEach(dyeColor -> {
                TerracottaSlabBlock slab = new TerracottaSlabBlock((DyeColor)dyeColor);
                blockRegistry.register((IForgeRegistryEntry)new TerracottaSlabBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaStairsBlock((DyeColor)dyeColor, slab.func_176223_P()));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaWallBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaButtonBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaPressurePlateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaFenceBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaFenceGateBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaLadderBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaSignBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaLeverBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new TerracottaVerticalSlabBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new GlazedTerracottaTileBlock((DyeColor)dyeColor));
                blockRegistry.register((IForgeRegistryEntry)new GlazedTerracottaSlabBlock((DyeColor)dyeColor));
            });
            TerracottaSlabBlock slab = new TerracottaSlabBlock();
            blockRegistry.register((IForgeRegistryEntry)new TerracottaSlabBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaStairsBlock(slab.func_176223_P()));
            blockRegistry.register((IForgeRegistryEntry)new TerracottaWallBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaButtonBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaPressurePlateBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaFenceBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaFenceGateBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaLadderBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaSignBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaLeverBlock());
            blockRegistry.register((IForgeRegistryEntry)new TerracottaVerticalSlabBlock());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            IForgeRegistry itemRegistry = event.getRegistry();
            TerracottaSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            TerracottaStairsBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            TerracottaWallBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            TerracottaButtonBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            TerracottaPressurePlateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            TerracottaFenceBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            TerracottaFenceGateBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            TerracottaLadderBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            TerracottaSignBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)new TerracottaSignItem((Block)block)));
            TerracottaLeverBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78028_d)));
            TerracottaVerticalSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78030_b)));
            GlazedTerracottaTileBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
            GlazedTerracottaSlabBlock.allBlocks().forEach(block -> itemRegistry.register((IForgeRegistryEntry)BlockItemHelper.createBasicBlockItem(block, ItemGroup.field_78031_c)));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            TileEntityType terracottaSignType = TileEntityType.Builder.func_223042_a(TerracottaSignTileEntity::new, (Block[])new Block[]{TerracottaSignBlocks.UNCOLORED, TerracottaSignBlocks.WHITE, TerracottaSignBlocks.ORANGE, TerracottaSignBlocks.MAGENTA, TerracottaSignBlocks.LIGHT_BLUE, TerracottaSignBlocks.YELLOW, TerracottaSignBlocks.LIME, TerracottaSignBlocks.PINK, TerracottaSignBlocks.GRAY, TerracottaSignBlocks.LIGHT_GRAY, TerracottaSignBlocks.CYAN, TerracottaSignBlocks.PURPLE, TerracottaSignBlocks.BLUE, TerracottaSignBlocks.BROWN, TerracottaSignBlocks.GREEN, TerracottaSignBlocks.RED, TerracottaSignBlocks.BLACK}).func_206865_a(null);
            terracottaSignType.setRegistryName("lottaterracotta", "terracotta_sign_tile_entity");
            event.getRegistry().register((IForgeRegistryEntry)terracottaSignType);
        }

        @SubscribeEvent
        public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
            ModConfig config = event.getConfig();
            if (config.getSpec() == ConfigHolder.COMMON_SPEC) {
                ConfigHelper.bakeCommon(config);
            }
        }
    }
}

