/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.home_makers_essentials.block;

import dev.sam.home_makers_essentials.HomeMakersEssentials;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PathLightBlock
extends Block {
    public PathLightBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{BlockStateProperties.field_208190_q});
    }

    public BlockState func_196258_a(BlockItemUseContext use) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)PathLightBlock.shouldBeLit(use.func_195991_k(), use.func_195995_a()));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean broken) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            PathLightBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, broken);
        }
    }

    public static Boolean shouldBeLit(World world, BlockPos pos) {
        long dayCycle = world.func_72820_D() % 24000L;
        boolean nightTime = 12500L <= dayCycle && dayCycle <= 23500L;
        return nightTime || world.func_72896_J() || world.func_226658_a_(LightType.SKY, pos) <= 7;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldReader, BlockPos pos) {
        return Block.func_220055_a((IWorldReader)worldReader, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType path) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)HomeMakersEssentials.BLOCK_ENTITIES.get("path_light")).func_200968_a();
    }
}

