/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.home_makers_essentials.block;

import dev.sam.home_makers_essentials.HomeMakersEssentials;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class NightDetectorBlock
extends Block {
    public NightDetectorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN)).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case EAST: {
                return Block.func_208617_a((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0, (double)11.0);
            }
            case NORTH: {
                return Block.func_208617_a((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)11.0, (double)16.0);
            }
            case SOUTH: {
                return Block.func_208617_a((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0);
            }
            case WEST: {
                return Block.func_208617_a((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0);
            }
            case UP: {
                return Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
            }
        }
        return Block.func_208617_a((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, BlockStateProperties.field_208194_u});
    }

    public BlockState func_196258_a(BlockItemUseContext use) {
        Direction direction = use.func_196000_l();
        BlockState blockstate = use.func_195991_k().func_180495_p(use.func_195995_a().func_177972_a(direction.func_176734_d()));
        if (blockstate.func_196955_c((IWorldReader)use.func_195991_k(), use.func_195995_a())) {
            return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b((Property)BlockStateProperties.field_208155_H) == direction ? (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction.func_176734_d())).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)NightDetectorBlock.shouldBePowered(use.func_195991_k(), use.func_195995_a())) : (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)direction)).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)NightDetectorBlock.shouldBePowered(use.func_195991_k(), use.func_195995_a()));
        }
        return null;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos neighborPos, boolean broken) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            NightDetectorBlock.func_220075_c((BlockState)state, (World)world, (BlockPos)pos);
            world.func_217377_a(pos, broken);
        }
    }

    public static Boolean shouldBePowered(World world, BlockPos pos) {
        long dayCycle = world.func_72820_D() % 24000L;
        boolean nightTime = 12500L <= dayCycle && dayCycle <= 23500L;
        return nightTime || world.func_72896_J() || world.func_226658_a_(LightType.SKY, pos) <= 7;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState neighborState, boolean bool) {
        if (!bool && !state.func_203425_a(neighborState.func_177230_c())) {
            if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u)).booleanValue()) {
                NightDetectorBlock.updateNeighbours(state, world, pos);
            }
            super.func_196243_a(state, world, pos, neighborState, false);
        }
    }

    public int func_180656_a(BlockState state, IBlockReader worldIn, BlockPos pos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? 15 : 0;
    }

    public int func_176211_b(BlockState state, IBlockReader worldIn, BlockPos pos, Direction direction) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false && state.func_177229_b((Property)BlockStateProperties.field_208155_H) == direction ? 15 : 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public static void updateNeighbours(BlockState state, World world, BlockPos pos) {
        world.func_195593_d(pos, state.func_177230_c());
        world.func_195593_d(pos.func_177972_a(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176734_d()), state.func_177230_c());
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        return Block.func_220055_a((IWorldReader)world, (BlockPos)pos.func_177972_a(direction.func_176734_d()), (Direction)direction);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType path) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)HomeMakersEssentials.BLOCK_ENTITIES.get("night_detector")).func_200968_a();
    }
}

