/*
 * Decompiled with CFR 0.152.
 */
package dev.sam.home_makers_essentials.block;

import dev.sam.home_makers_essentials.HomeMakersEssentials;
import dev.sam.home_makers_essentials.block_entities.MailboxBlockEntity;
import dev.sam.home_makers_essentials.stats.ModStats;
import dev.sam.keys_and_leds_core.state.properties.ModBlockStateProperties;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MailboxBlock
extends HorizontalBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final BooleanProperty FLAG = ModBlockStateProperties.INDICATOR;

    protected MailboxBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FLAG, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)5.0, (double)0.0, (double)2.0, (double)11.0, (double)7.0, (double)14.0), (VoxelShape[])new VoxelShape[0]);
            }
            case EAST: 
            case WEST: 
        }
        return VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)2.0, (double)0.0, (double)5.0, (double)14.0, (double)7.0, (double)11.0), (VoxelShape[])new VoxelShape[0]);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> state) {
        state.func_206894_a(new Property[]{FACING, OPEN, FLAG});
    }

    public BlockState func_196258_a(BlockItemUseContext use) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)use.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_213453_ef()) {
            return this.flag(state, world, pos);
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MailboxBlockEntity) {
            player.func_213829_a((INamedContainerProvider)((MailboxBlockEntity)tileentity));
            player.func_195066_a(ModStats.INTERACT_WITH_MAILBOX);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
        }
        return ActionResultType.CONSUME;
    }

    public ActionResultType flag(BlockState state, World world, BlockPos pos) {
        state = (BlockState)state.func_235896_a_((Property)FLAG);
        world.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((Property)FLAG) != false ? 0.6f : 0.5f;
        world.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState neighborState, boolean bool) {
        if (!state.func_203425_a(neighborState.func_177230_c())) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, neighborState, false);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rando) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)tileentity).recheckOpen();
        }
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = world.func_175625_s(pos)) instanceof MailboxBlockEntity) {
            ((MailboxBlockEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldReader, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return Block.func_220055_a((IWorldReader)worldReader, (BlockPos)blockpos, (Direction)Direction.UP);
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader WorldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)HomeMakersEssentials.BLOCK_ENTITIES.get("mailbox")).func_200968_a();
    }
}

