/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.track.BuilderBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.track.TrackGag;
import cam72cam.immersiverailroading.track.TrackRail;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class BuilderTurnTable
extends BuilderBase {
    protected HashSet<Pair<Integer, Integer>> positions = new HashSet();
    private Vec3i offset;

    public BuilderTurnTable(RailInfo infoIn, World world, Vec3i pos) {
        super(infoIn.withSettings(b -> {
            b.length = Math.min(infoIn.settings.length, BuilderTurnTable.maxLength(infoIn.settings.gauge));
        }), world, pos);
        this.offset = new Vec3i(0, 1, this.info.settings.length);
        this.offset = this.offset.rotate(Rotation.from((Facing)this.info.placementInfo.facing()));
        double radius = this.info.settings.length;
        for (double irad = 1.0; irad <= radius + 1.0; irad += 1.0) {
            for (double angle = 0.0; angle < 360.0; angle += 0.5) {
                Vec3d gagPos = VecUtil.fromYaw(irad, (float)angle);
                this.positions.add((Pair<Integer, Integer>)Pair.of((Object)((int)gagPos.x), (Object)((int)gagPos.z)));
            }
        }
        this.setParentPos(this.offset.down());
        TrackRail main = new TrackRail(this, this.offset.down());
        this.tracks.add(main);
        for (Pair<Integer, Integer> pair : this.positions) {
            double toCenter = new Vec3d((double)((Integer)pair.getLeft()).intValue(), 0.0, (double)((Integer)pair.getRight()).intValue()).length();
            if (toCenter > (double)this.info.settings.length + 0.5) continue;
            if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                TrackGag tgu = new TrackGag(this, new Vec3i((Integer)pair.getLeft() + this.offset.x, this.offset.y - 1, (Integer)pair.getRight() + this.offset.z));
                if (toCenter > (double)this.info.settings.length - 0.5) {
                    tgu.setHeight(1.0f);
                    tgu.setFlexible();
                }
                this.tracks.add(tgu);
            }
            TrackGag tg = new TrackGag(this, new Vec3i((Integer)pair.getLeft() + this.offset.x, this.offset.y, (Integer)pair.getRight() + this.offset.z));
            tg.setHeight(1.0E-6f);
            tg.solidNotRequired = true;
            if (toCenter > (double)this.info.settings.length - 0.5) {
                tg.setHeight(0.0f);
            }
            if (toCenter > (double)this.info.settings.length - 1.5) {
                tg.setFlexible();
            }
            this.tracks.add(tg);
        }
    }

    @Override
    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    @Override
    public List<BuilderBase.VecYawPitch> getRenderData() {
        float angle;
        ArrayList<BuilderBase.VecYawPitch> data = new ArrayList<BuilderBase.VecYawPitch>();
        if (this.info.itemHeld) {
            for (angle = 0.0f; angle < 360.0f; angle += 90.0f / (float)PlacementInfo.segmentation()) {
                Vec3d gagPos = VecUtil.rotateWrongYaw(new Vec3d(0.0, 0.0, (double)this.info.settings.length), angle - 90.0f);
                data.add((BuilderBase)this.new BuilderBase.VecYawPitch(gagPos.x + (double)this.offset.x, gagPos.y + (double)this.offset.y, gagPos.z + (double)this.offset.z, -angle, new String[0]));
            }
        }
        angle = (float)this.info.tablePos - this.info.placementInfo.facing().getAngle();
        data.add((BuilderBase)this.new BuilderBase.VecYawPitch((double)this.offset.x, (double)this.offset.y, (double)this.offset.z, -angle, 0.0f, this.info.settings.length * 2, "RAIL_RIGHT", "RAIL_LEFT"));
        return data;
    }

    @Override
    public int costTies() {
        return (int)Math.ceil((double)(this.info.settings.length + 8) * Config.ConfigBalance.TieCostMultiplier);
    }

    @Override
    public int costRails() {
        return (int)Math.ceil((double)((this.info.settings.length + 8) * 2 / 3) * Config.ConfigBalance.RailCostMultiplier);
    }

    @Override
    public int costBed() {
        return (int)Math.ceil((double)this.tracks.size() / 2.0 * 0.1 * Config.ConfigBalance.BedCostMultiplier);
    }

    @Override
    public int costFill() {
        int fillCount = 0;
        for (TrackBase track : this.tracks) {
            if (track.rel.y == 1 || !BlockUtil.canBeReplaced(this.world, track.getPos().down(), false)) continue;
            ++fillCount;
        }
        return (int)Math.ceil(!this.info.settings.railBedFill.isEmpty() ? (double)fillCount : 0.0);
    }

    public static int maxLength(Gauge gauge) {
        return (int)(30.0 * gauge.scale());
    }
}

