/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.track;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class BuilderBase {
    protected final World world;
    protected ArrayList<TrackBase> tracks = new ArrayList();
    public RailInfo info;
    public final Vec3i pos;
    private Vec3i parent_pos;
    public boolean overrideFlexible = true;
    public List<ItemStack> drops;

    public BuilderBase(RailInfo info, World world, Vec3i pos) {
        this.info = info;
        this.world = world;
        this.pos = pos;
        this.parent_pos = pos;
    }

    public abstract List<VecYawPitch> getRenderData();

    public boolean canBuild() {
        for (TrackBase track : this.tracks) {
            if (track.canPlaceTrack()) continue;
            return false;
        }
        return true;
    }

    public void build() {
        for (TrackBase track : this.tracks) {
            if (!track.isOverTileRail()) {
                track.placeTrack(true).markDirty();
                continue;
            }
            TileRail rail = (TileRail)this.world.getBlockEntity(track.getPos(), TileRail.class);
            TileRailBase placed = track.placeTrack(false);
            placed.setReplaced(rail.getReplaced());
            rail.setReplaced(placed.getData());
            rail.markDirty();
        }
    }

    public List<TrackBase> getTracksForRender() {
        return this.tracks;
    }

    public List<TrackBase> getTracksForFloating() {
        return this.tracks;
    }

    public void setParentPos(Vec3i pos) {
        this.parent_pos = this.pos.add(pos);
    }

    public Vec3i getParentPos() {
        return this.parent_pos;
    }

    public int costTies() {
        return (int)Math.ceil((double)(this.tracks.size() / 3) * Config.ConfigBalance.TieCostMultiplier);
    }

    public int costRails() {
        return (int)Math.ceil((double)(this.tracks.size() * 2 / 3) * Config.ConfigBalance.RailCostMultiplier / 2.0);
    }

    public int costBed() {
        return (int)Math.ceil((double)this.tracks.size() * 0.1 * Config.ConfigBalance.BedCostMultiplier);
    }

    public int costFill() {
        int fillCount = 0;
        for (TrackBase track : this.tracks) {
            if (!BlockUtil.canBeReplaced(this.world, track.getPos().down(), false)) continue;
            ++fillCount;
        }
        return (int)Math.ceil(!this.info.settings.railBedFill.isEmpty() ? (double)fillCount : 0.0);
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public void clearArea() {
        for (TrackBase track : this.tracks) {
            int i = 0;
            while ((double)i < 6.0 * this.info.settings.gauge.scale()) {
                Vec3i main = track.getPos().up(i);
                if (!ITrack.isRail(this.world, main) && !this.world.isSnow(main)) {
                    this.world.setToAir(main);
                }
                if (this.info.settings.gauge.isModel() && Config.ConfigDamage.enableSideBlockClearing && this.info.settings.type != TrackItems.SLOPE && this.info.settings.type != TrackItems.TURNTABLE) {
                    for (Facing facing : Facing.HORIZONTALS) {
                        Vec3i pos = main.offset(facing);
                        if (ITrack.isRail(this.world, pos)) continue;
                        this.world.setToAir(pos);
                    }
                }
                ++i;
            }
            if (!BlockUtil.canBeReplaced(this.world, track.getPos().down(), false)) continue;
            this.world.setToAir(track.getPos().down());
        }
    }

    public class VecYawPitch
    extends Vec3d {
        public final float yaw;
        public final float pitch;
        public final float length;
        public final List<String> groups;

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, String ... groups) {
            this(xIn, yIn, zIn, yaw, 0.0f, groups);
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, String ... groups) {
            this(xIn, yIn, zIn, yaw, pitch, -1.0f, groups);
        }

        public VecYawPitch(double xIn, double yIn, double zIn, float yaw, float pitch, float length, String ... groups) {
            super(xIn, yIn, zIn);
            this.yaw = yaw;
            this.groups = Arrays.asList(groups);
            this.pitch = pitch;
            this.length = length;
        }

        public float getYaw() {
            return this.yaw;
        }

        public float getPitch() {
            return this.pitch;
        }

        public float getLength() {
            return this.length;
        }

        public List<String> getGroups() {
            return this.groups;
        }
    }
}

