/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.thirdparty;

import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRidableRollingStock;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.entity.Freight;
import cam72cam.immersiverailroading.entity.FreightTank;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveDiesel;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.registry.LocomotiveDefinition;
import cam72cam.immersiverailroading.thirdparty.event.TagEvent;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.mod.math.Vec3i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;

public class CommonAPI {
    private final Supplier<EntityRollingStock> stockSupplier;

    public static CommonAPI create(World world, BlockPos pos) {
        return CommonAPI.create(world, pos, EntityRollingStock.class);
    }

    public static CommonAPI create(World world, BlockPos pos, Class<? extends EntityRollingStock> stockClass) {
        TileRailBase te = (TileRailBase)cam72cam.mod.world.World.get((World)world).getBlockEntity(new Vec3i(pos), TileRailBase.class);
        if (te != null) {
            return new CommonAPI(te, stockClass);
        }
        return null;
    }

    public CommonAPI(TileRailBase te, Class<? extends EntityRollingStock> stockClass) {
        this.stockSupplier = () -> te.getStockNearBy(stockClass);
    }

    public CommonAPI(EntityRollingStock stock) {
        this.stockSupplier = () -> stock;
    }

    public EntityRollingStock stock() {
        return this.stockSupplier.get();
    }

    public FluidStack getFluid() {
        EntityRollingStock stock = this.stock();
        if (stock instanceof FreightTank) {
            FreightTank tank = (FreightTank)stock;
            return tank.getLiquid() != null ? new FluidStack((Fluid)tank.getLiquid().internal.get(0), tank.getLiquidAmount()) : null;
        }
        return null;
    }

    public Map<String, Object> info() {
        EntityRollingStock stock = this.stock();
        if (stock != null) {
            FluidStack fluid;
            HashMap<String, Object> info = new HashMap<String, Object>();
            EntityRollingStockDefinition def = stock.getDefinition();
            info.put("id", def.defID);
            info.put("name", def.name());
            info.put("tag", stock.tag);
            info.put("weight", stock.getWeight());
            Direction dir = Direction.func_176733_a((double)stock.getRotationYaw());
            if (stock instanceof EntityMoveableRollingStock) {
                EntityMoveableRollingStock movable = (EntityMoveableRollingStock)stock;
                info.put("speed", movable.getCurrentSpeed().metric());
                if (movable.getCurrentSpeed().metric() < 0.0) {
                    dir = dir.func_176734_d();
                }
            }
            info.put("direction", dir.toString());
            if (stock instanceof EntityRidableRollingStock) {
                info.put("passengers", stock.getPassengerCount());
            }
            if (stock instanceof EntityMoveableRollingStock) {
                info.put("independent_brake", Float.valueOf(((EntityMoveableRollingStock)stock).getIndependentBrake()));
            }
            if (stock instanceof Locomotive) {
                Locomotive loco = (Locomotive)stock;
                LocomotiveDefinition locoDef = loco.getDefinition();
                info.put("horsepower", locoDef.getHorsePower(loco.gauge));
                info.put("traction", locoDef.getStartingTractionNewtons(loco.gauge));
                info.put("max_speed", locoDef.getMaxSpeed(loco.gauge).metric());
                info.put("brake", Float.valueOf(loco.getTrainBrake()));
                info.put("train_brake", Float.valueOf(loco.getTrainBrake()));
                info.put("throttle", Float.valueOf(loco.getThrottle()));
                info.put("reverser", Float.valueOf(loco.getReverser()));
                if (loco instanceof LocomotiveSteam) {
                    LocomotiveSteam steam = (LocomotiveSteam)loco;
                    info.put("pressure", Float.valueOf(steam.getBoilerPressure()));
                    info.put("temperature", Float.valueOf(steam.getBoilerTemperature()));
                }
                if (loco instanceof LocomotiveDiesel) {
                    info.put("ignition", ((LocomotiveDiesel)loco).isTurnedOn());
                    info.put("temperature", Float.valueOf(((LocomotiveDiesel)loco).getEngineTemperature()));
                }
            }
            if ((fluid = this.getFluid()) != null) {
                info.put("fluid_type", fluid.getFluid().getAttributes().getDisplayName(null));
                info.put("fluid_amount", fluid.getAmount());
            } else {
                info.put("fluid_type", null);
                info.put("fluid_amount", 0);
            }
            if (stock instanceof FreightTank) {
                info.put("fluid_max", ((FreightTank)stock).getTankCapacity().MilliBuckets());
            }
            if (stock instanceof Freight) {
                Freight freight = (Freight)stock;
                info.put("cargo_percent", freight.getPercentCargoFull());
                info.put("cargo_size", freight.getInventorySize());
            }
            return info;
        }
        return null;
    }

    public Map<String, Object> consist(boolean supportsList) {
        if (!(this.stock() instanceof EntityCoupleableRollingStock)) {
            return null;
        }
        EntityCoupleableRollingStock stock = (EntityCoupleableRollingStock)this.stock();
        int traction = 0;
        TrainIterator acc = new TrainIterator();
        stock.mapTrain(stock, true, true, acc::accept);
        HashMap<String, Object> info = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> locos = new ArrayList<Map<String, Object>>();
        info.put("cars", acc.count);
        info.put("tractive_effort_N", acc.tractiveEffortNewtons);
        info.put("weight_kg", acc.massToMoveKg);
        info.put("speed_km", stock.getCurrentSpeed().metric());
        Direction dir = Direction.func_176733_a((double)stock.getRotationYaw());
        if (stock.getCurrentSpeed().metric() < 0.0) {
            dir = dir.func_176734_d();
        }
        info.put("direction", dir.toString());
        for (EntityCoupleableRollingStock car : stock.getTrain()) {
            if (!(car instanceof Locomotive)) continue;
            LocomotiveDefinition locoDef = ((Locomotive)car).getDefinition();
            traction += locoDef.getStartingTractionNewtons(car.gauge);
            locos.add(new CommonAPI(car).info());
        }
        if (supportsList) {
            info.put("locomotives", locos);
        } else {
            HashMap locomotives = new HashMap();
            for (int i = 0; i < locos.size(); ++i) {
                locomotives.put("" + i, locos.get(i));
            }
            info.put("locomotives", locomotives);
        }
        info.put("total_traction_N", traction);
        return info;
    }

    public String getTag() {
        EntityRollingStock stock = this.stock();
        TagEvent.GetTagEvent tagEvent = new TagEvent.GetTagEvent(stock.getUUID());
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        if (tagEvent.tag != null) {
            return tagEvent.tag;
        }
        return stock.tag;
    }

    public void setTag(String tag) {
        EntityRollingStock stock = this.stock();
        TagEvent.SetTagEvent tagEvent = new TagEvent.SetTagEvent(stock.getUUID(), tag);
        MinecraftForge.EVENT_BUS.post((Event)tagEvent);
        stock.tag = tag;
    }

    private float normalize(double val) {
        if (Double.isNaN(val)) {
            return 0.0f;
        }
        if (val > 1.0) {
            return 1.0f;
        }
        if (val < -1.0) {
            return -1.0f;
        }
        return (float)val;
    }

    public void setThrottle(double throttle) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof Locomotive) {
            ((Locomotive)stock).setThrottle(this.normalize(throttle));
        }
    }

    public void setReverser(double reverser) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof Locomotive) {
            ((Locomotive)stock).setReverser(this.normalize(reverser));
        }
    }

    public void setTrainBrake(double brake) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof Locomotive) {
            ((Locomotive)stock).setTrainBrake(this.normalize(brake));
        }
    }

    public void setIndependentBrake(double brake) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof EntityMoveableRollingStock) {
            ((Locomotive)stock).setIndependentBrake(this.normalize(brake));
        }
    }

    public void setHorn(int horn) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof Locomotive) {
            ((Locomotive)stock).setHorn(horn, null);
        }
    }

    public void setBell(int bell) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof Locomotive) {
            ((Locomotive)stock).setBell(bell);
        }
    }

    public Vector3d getPosition() {
        EntityRollingStock stock = this.stock();
        return stock.getPosition().internal();
    }

    public UUID getUniqueID() {
        EntityRollingStock stock = this.stock();
        return stock.getUUID();
    }

    public Boolean getIgnition() {
        EntityRollingStock stock = this.stock();
        if (stock instanceof LocomotiveDiesel) {
            return ((LocomotiveDiesel)stock).isTurnedOn();
        }
        return null;
    }

    public void setIgnition(boolean on) {
        EntityRollingStock stock = this.stock();
        if (stock instanceof LocomotiveDiesel) {
            ((LocomotiveDiesel)stock).setTurnedOn(on);
        }
    }

    private static class TrainIterator {
        private int count;
        private double tractiveEffortNewtons;
        private double massToMoveKg;

        private TrainIterator() {
        }

        public void accept(EntityCoupleableRollingStock stock, boolean direction) {
            ++this.count;
            this.tractiveEffortNewtons += stock instanceof Locomotive ? ((Locomotive)stock).getTractiveEffortNewtons(stock.getCurrentSpeed()) * (double)(direction ? 1 : -1) : 0.0;
            this.massToMoveKg += stock.getWeight();
        }
    }
}

