/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigGraphics;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.entity.EntityMoveableRollingStock;
import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.entity.LocomotiveSteam;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Particles;
import cam72cam.immersiverailroading.library.ValveGearConfig;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.ConnectingRodValveGear;
import cam72cam.immersiverailroading.model.part.CustomValveGear;
import cam72cam.immersiverailroading.model.part.StephensonValveGear;
import cam72cam.immersiverailroading.model.part.WalschaertsValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.render.ExpireableMap;
import cam72cam.immersiverailroading.render.SmokeParticle;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.sound.ISound;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import util.Matrix4;

public abstract class ValveGear {
    protected final WheelSet wheels;
    private final ModelState state;
    protected float angleOffset;
    protected Exhaust frontExhaust;
    protected Exhaust rearExhaust;
    private static ExpireableMap<String, ChuffSound> chuffSounds = new ExpireableMap<String, ChuffSound>(){

        @Override
        public void onRemove(String key, ChuffSound value) {
            value.free();
        }
    };

    protected ValveGear(WheelSet wheels, ModelState state, float angleOffset) {
        this.wheels = wheels;
        this.state = state;
        this.angleOffset = angleOffset;
        this.frontExhaust = null;
        this.rearExhaust = null;
    }

    static ValveGear get(WheelSet wheels, ValveGearConfig config, ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos, float angleOffset) {
        if (config == null) {
            return null;
        }
        switch (config.type) {
            case WALSCHAERTS: {
                return WalschaertsValveGear.get(wheels, provider, state, pos, angleOffset);
            }
            case STEPHENSON: {
                return StephensonValveGear.get(wheels, provider, state, pos, angleOffset);
            }
            case CONNECTING: {
                return ConnectingRodValveGear.get(wheels, provider, state, pos, angleOffset);
            }
            case CUSTOM: {
                return CustomValveGear.get(config, wheels, provider, state, pos);
            }
        }
        return null;
    }

    void effects(EntityMoveableRollingStock stock) {
        if (this.frontExhaust != null) {
            this.frontExhaust.effects(stock);
        }
        if (this.rearExhaust != null) {
            this.rearExhaust.effects(stock);
        }
    }

    public boolean isEndStroke(EntityMoveableRollingStock stock) {
        return this.frontExhaust != null && this.frontExhaust.isEndStroke(stock) || this.rearExhaust != null && this.rearExhaust.isEndStroke(stock);
    }

    float angle(double distance) {
        return this.wheels.angle(distance) + this.angleOffset;
    }

    public void removed(EntityMoveableRollingStock stock) {
        if (this.frontExhaust != null) {
            this.frontExhaust.removed(stock);
        }
        if (this.rearExhaust != null) {
            this.rearExhaust.removed(stock);
        }
    }

    private static Vec3d findDirection(String name) {
        Vec3d result = Vec3d.ZERO;
        for (Direction value : Direction.values()) {
            if (!name.contains("__" + value.name())) continue;
            result = result.add(value.vec);
        }
        return result;
    }

    private static class ChuffSound {
        private final LocomotiveSteam stock;
        private final float pitchOffset;
        private boolean pitchStroke;
        private boolean chuffOn = false;
        private final List<ISound> chuffs = new ArrayList<ISound>();
        private final ISound cylinder_drain;
        private int chuffId = 0;
        private float drain_volume = 0.0f;

        public ChuffSound(LocomotiveSteam stock) {
            for (int i = 0; i < 6; ++i) {
                this.chuffs.add(stock.createSound(stock.getDefinition().chuff, false, 40.0, ConfigSound.SoundCategories.Locomotive.Steam::chuff));
            }
            this.cylinder_drain = stock.createSound(stock.getDefinition().cylinder_drain, true, 40.0, ConfigSound.SoundCategories.Locomotive.Steam::cylinder_drain);
            this.stock = stock;
            this.pitchOffset = (float)(Math.random() / 50.0);
            this.pitchStroke = false;
        }

        public void update(Vec3d particlePos, boolean enteredStroke, boolean drain_enabled) {
            if (!this.chuffOn) {
                if (enteredStroke && Math.abs(this.stock.getThrottle() * this.stock.getReverser()) > 0.0f) {
                    this.chuffOn = true;
                    this.pitchStroke = !this.pitchStroke;
                    double speed = Math.abs(this.stock.getCurrentSpeed().minecraft());
                    double maxSpeed = Math.abs(this.stock.getDefinition().getMaxSpeed(this.stock.gauge).minecraft());
                    if (maxSpeed == 0.0) {
                        maxSpeed = 200.0;
                    }
                    float volume = (float)Math.max(1.0 - speed / maxSpeed, 0.3) * Math.abs(this.stock.getThrottle() * this.stock.getReverser());
                    volume = (float)Math.sqrt(volume);
                    double fraction = 3.0;
                    float pitch = 0.8f + (float)(speed / maxSpeed / fraction * 0.2);
                    float delta = this.pitchOffset - (this.pitchStroke ? -0.02f : 0.0f);
                    ISound chuff = this.chuffs.get(this.chuffId);
                    chuff.setPitch(pitch + delta);
                    chuff.setVolume(volume + delta);
                    chuff.play(particlePos);
                    this.chuffId = (this.chuffId + 1) % this.chuffs.size();
                }
            } else if (!enteredStroke) {
                this.chuffOn = false;
            }
            for (ISound chuff : this.chuffs) {
                if (!chuff.isPlaying()) continue;
                chuff.setPosition(particlePos);
                chuff.setVelocity(this.stock.getVelocity());
            }
            if (drain_enabled) {
                this.drain_volume += 0.5f;
                this.drain_volume = Math.min(1.0f, this.drain_volume);
            }
            if (!drain_enabled && this.drain_volume > 0.0f) {
                this.drain_volume -= 0.2f;
            }
            if (this.drain_volume > 0.0f && !this.cylinder_drain.isPlaying()) {
                this.cylinder_drain.setPitch(1.0f - this.pitchOffset * 5.0f);
                this.cylinder_drain.setVolume(this.drain_volume * this.stock.getThrottle());
                this.cylinder_drain.play(particlePos);
            }
            if (this.drain_volume <= 0.0f && this.cylinder_drain.isPlaying()) {
                this.cylinder_drain.stop();
            }
            if (this.cylinder_drain.isPlaying()) {
                this.cylinder_drain.setVolume(this.drain_volume * this.stock.getThrottle());
                this.cylinder_drain.setPosition(particlePos);
                this.cylinder_drain.setVelocity(this.stock.getVelocity());
            }
        }

        void free() {
            for (ISound chuff : this.chuffs) {
                chuff.stop();
            }
            this.cylinder_drain.stop();
        }
    }

    public class Exhaust {
        public final Vec3d position;
        public final Vec3d direction;
        public final float angle;

        public Exhaust(Vec3d position, ModelComponentType.ModelPosition direction, float angle) {
            this(position, new Vec3d(0.0, 0.0, direction.contains(ModelComponentType.ModelPosition.RIGHT) ? -1.0 : (direction.contains(ModelComponentType.ModelPosition.CENTER) ? 0.0 : 1.0)), angle);
        }

        public Exhaust(Vec3d position, Vec3d direction, float angle) {
            this.position = position;
            this.direction = direction;
            this.angle = angle;
        }

        public Exhaust(ModelComponent component, float angle) {
            this(component.center, ValveGear.findDirection(component.key), angle);
        }

        private Pair<Matrix4, Vec3d> particlePos(EntityMoveableRollingStock stock) {
            Matrix4 m = ValveGear.this.state.getMatrix(stock, 0.0f);
            if (m == null) {
                m = new Matrix4();
            }
            return Pair.of((Object)m, (Object)stock.getPosition().add(VecUtil.rotateWrongYaw(m.apply(this.position).scale(stock.gauge.scale()), stock.getRotationYaw() + 180.0f)));
        }

        public void effects(EntityMoveableRollingStock stock) {
            boolean drains_enabled;
            boolean bl = drains_enabled = this.isEndStroke(stock) && stock instanceof LocomotiveSteam && ((LocomotiveSteam)stock).cylinderDrainsEnabled();
            if (stock instanceof Locomotive && ((LocomotiveSteam)stock).getBoilerPressure() <= 0.0f && Config.ConfigBalance.FuelRequired) {
                return;
            }
            Pair<Matrix4, Vec3d> particlePos = null;
            if (ConfigGraphics.particlesEnabled && drains_enabled) {
                particlePos = this.particlePos(stock);
                double accell = 0.3 * stock.gauge.scale();
                Vec3d sideMotion = stock.getVelocity().add(VecUtil.rotateWrongYaw(((Matrix4)particlePos.getLeft()).apply(this.direction).scale(accell), stock.getRotationYaw() + 180.0f));
                Particles.SMOKE.accept(new SmokeParticle.SmokeParticleData(stock.getWorld(), (Vec3d)particlePos.getRight(), new Vec3d(sideMotion.x, sideMotion.y + 0.01 * stock.gauge.scale(), sideMotion.z), 80, 0.0f, 0.6f, 0.2 * stock.gauge.scale(), stock.getDefinition().steamParticleTexture));
            }
            if (stock instanceof LocomotiveSteam) {
                if (particlePos == null) {
                    particlePos = this.particlePos(stock);
                }
                String key = String.format("%s-%s", stock.getUUID(), this.hashCode());
                ChuffSound sound = (ChuffSound)chuffSounds.get(key);
                if (sound == null) {
                    sound = new ChuffSound((LocomotiveSteam)stock);
                    chuffSounds.put(key, sound);
                }
                sound.update((Vec3d)particlePos.getRight(), this.isEndStroke(stock, 0.125f), drains_enabled);
            }
        }

        public void removed(EntityMoveableRollingStock stock) {
            String key = String.format("%s-%s", stock.getUUID(), this.hashCode());
            chuffSounds.remove(key);
        }

        public boolean isEndStroke(EntityMoveableRollingStock stock) {
            float delta = 0.03f;
            if (stock instanceof LocomotiveSteam) {
                LocomotiveSteam loco = (LocomotiveSteam)stock;
                if ((double)Math.abs(loco.getThrottle() * loco.getReverser()) <= 0.01) {
                    return false;
                }
                delta = Math.abs(loco.getReverser()) / 4.0f;
            }
            return this.isEndStroke(stock, delta);
        }

        public boolean isEndStroke(EntityMoveableRollingStock stock, float delta) {
            double pistonPos;
            double percent = ValveGear.this.angle(stock.distanceTraveled / stock.gauge.scale()) / 360.0f;
            return Math.abs(percent - (pistonPos = (double)(this.angle / 360.0f))) < (double)delta || Math.abs(percent - pistonPos - 1.0) < (double)delta || Math.abs(percent - pistonPos + 1.0) < (double)delta;
        }
    }

    private static enum Direction {
        FRONT(new Vec3d(-1.0, 0.0, 0.0)),
        BACK(new Vec3d(1.0, 0.0, 0.0)),
        UP(new Vec3d(0.0, 1.0, 0.0)),
        DOWN(new Vec3d(0.0, -1.0, 0.0)),
        LEFT(new Vec3d(0.0, 0.0, 1.0)),
        RIGHT(new Vec3d(0.0, 0.0, -1.0));

        private final Vec3d vec;

        private Direction(Vec3d vec) {
            this.vec = vec;
        }
    }
}

