/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.IRBlocks;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.util.BlockUtil;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.mod.block.BlockType;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.Recipes;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.Collections;
import java.util.List;

public class ItemGoldenSpike
extends CustomItem {
    public ItemGoldenSpike() {
        super("immersiverailroading", "item_golden_spike");
        Fuzzy gold = Fuzzy.GOLD_INGOT;
        Recipes.shapedRecipe((CustomItem)this, (int)2, (Fuzzy[])new Fuzzy[]{gold, gold, gold, null, gold, null});
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public ClickResult onClickBlock(Player player, World world, Vec3i pos, Player.Hand hand, Facing facing, Vec3d hit) {
        ItemStack held = player.getHeldItem(hand);
        if (world.isBlock(pos, (BlockType)IRBlocks.BLOCK_RAIL_PREVIEW)) {
            Data d = new Data(held);
            d.pos = pos;
            d.write();
            Audio.playSound((World)world, (Vec3i)pos, (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.BLOCKS, (float)0.5f, (float)0.2f);
        } else {
            pos = pos.up();
            Vec3i tepos = new Data((ItemStack)held).pos;
            if (tepos != null) {
                TileRailPreview tr;
                if (BlockUtil.canBeReplaced(world, pos.down(), true) && (!BlockUtil.isIRRail(world, pos.down()) || (double)((TileRailBase)world.getBlockEntity(pos.down(), TileRailBase.class)).getRailHeight() < 0.5)) {
                    pos = pos.down();
                }
                if ((tr = (TileRailPreview)world.getBlockEntity(tepos, TileRailPreview.class)) != null) {
                    if (tr.isAboveRails()) {
                        tepos = tepos.down();
                    }
                    tr.setCustomInfo(new PlacementInfo(tr.getItem(), player.getYawHead(), hit.subtract(0.0, hit.y, 0.0).add(pos).subtract(tepos)));
                }
            }
        }
        return ClickResult.ACCEPTED;
    }

    public void onClickAir(Player player, World world, Player.Hand hand) {
        if (world.isClient) {
            TileRailPreview te;
            Data d = new Data(player.getHeldItem(hand));
            if (d.pos != null && (te = (TileRailPreview)world.getBlockEntity(d.pos, TileRailPreview.class)) != null) {
                GuiTypes.RAIL_PREVIEW.open(player, d.pos);
            }
        }
    }

    public static class Data
    extends CustomItem.ItemDataSerializer {
        @TagField(value="pos")
        public Vec3i pos;

        protected Data(ItemStack stack) {
            super(stack);
        }
    }
}

