/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui.components;

import cam72cam.immersiverailroading.gui.components.GuiUtils;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.gui.screen.TextField;
import cam72cam.mod.text.TextColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ListSelector<T> {
    int width;
    T currentValue;
    Map<String, T> rawOptions;
    int page;
    int pageSize;
    boolean visible;
    TextField search;
    Button pagination;
    List<Button> options;
    Map<Button, T> usableButtons;
    Map<Button, Integer> buttonsX;
    Map<Button, Integer> buttonsY;

    public ListSelector(IScreenBuilder screen, int xOff, int width, int height, T currentValue, Map<String, T> rawOptions) {
        this.width = width;
        this.rawOptions = rawOptions;
        this.currentValue = currentValue;
        this.visible = false;
        int xtop = -GUIHelpers.getScreenWidth() / 2 + xOff;
        int ytop = -GUIHelpers.getScreenHeight() / 4;
        this.search = new TextField(screen, xtop, ytop, width - 1, height);
        this.pagination = new Button(screen, xtop, ytop + height, width + 1, height, "Page"){

            public void onClick(Player.Hand hand) {
                ListSelector.this.page = ListSelector.this.page + (hand == Player.Hand.PRIMARY ? 1 : -1);
                ListSelector.this.updateSearch(ListSelector.this.search.getText());
            }
        };
        this.page = 0;
        this.pageSize = Math.max(1, GUIHelpers.getScreenHeight() / height - 2);
        if (rawOptions.size() < this.pageSize) {
            ytop -= height;
        }
        this.options = new ArrayList<Button>();
        this.buttonsX = new HashMap<Button, Integer>();
        this.buttonsY = new HashMap<Button, Integer>();
        for (int i = 0; i < this.pageSize; ++i) {
            Button btn = new Button(screen, xtop, ytop + height * 2 + i * height, width + 1, height, ""){

                public void onClick(Player.Hand hand) {
                    ListSelector.this.currentValue = ListSelector.this.usableButtons.get((Object)this);
                    ListSelector.this.onClick(ListSelector.this.currentValue);
                    ListSelector.this.updateSearch(ListSelector.this.search.getText());
                }
            };
            this.buttonsX.put(btn, xtop);
            this.buttonsY.put(btn, ytop + height * 2 + i * height);
            this.options.add(btn);
        }
        this.search.setValidator(s -> {
            this.page = 0;
            this.updateSearch((String)s);
            return true;
        });
        this.updateSearch("");
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.search.setVisible(visible && this.rawOptions.size() > this.pageSize);
        this.pagination.setVisible(visible && this.rawOptions.size() > this.pageSize);
        this.options.forEach(b -> b.setVisible(visible && !b.getText().isEmpty()));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public abstract void onClick(T var1);

    void updateSearch(String search) {
        int nPages;
        Set<String> names = search.isEmpty() ? this.rawOptions.keySet() : (Collection)this.rawOptions.keySet().stream().filter(v -> v.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
        int n = nPages = this.pageSize > 0 ? (int)Math.ceil((float)names.size() / (float)this.pageSize) : 0;
        if (this.page >= nPages) {
            this.page = 0;
        }
        if (this.page < 0) {
            this.page = nPages - 1;
        }
        this.pagination.setText(String.format("Page %s of %s", this.page + 1, Math.max(1, nPages)));
        this.options.forEach(b -> {
            b.setText("");
            b.setVisible(false);
            b.setEnabled(false);
        });
        this.usableButtons = new HashMap<Button, T>();
        int bid = 0;
        for (Map.Entry entry : this.rawOptions.entrySet().stream().filter(e -> names.contains(e.getKey())).skip((long)this.page * (long)this.pageSize).limit(this.pageSize).collect(Collectors.toList())) {
            Button button = this.options.get(bid);
            button.setEnabled(true);
            button.setVisible(true);
            String text = GuiUtils.fitString((String)entry.getKey(), (int)Math.floor((double)this.width / 6.0));
            if (entry.getValue() == this.currentValue) {
                text = TextColor.YELLOW.wrap(text);
            }
            button.setText(text);
            this.usableButtons.put(button, entry.getValue());
            ++bid;
        }
    }

    public void render(ButtonRenderer<T> renderer) {
        if (!this.isVisible()) {
            return;
        }
        for (Map.Entry<Button, T> entry : this.usableButtons.entrySet()) {
            renderer.render(entry.getKey(), GUIHelpers.getScreenWidth() / 2 + this.buttonsX.get(entry.getKey()), GUIHelpers.getScreenHeight() / 4 + this.buttonsY.get(entry.getKey()), entry.getValue());
        }
    }

    @FunctionalInterface
    public static interface ButtonRenderer<T> {
        public void render(Button var1, int var2, int var3, T var4);
    }
}

