/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.gui.CraftPicker;
import cam72cam.immersiverailroading.items.ItemPlate;
import cam72cam.immersiverailroading.items.ItemRollingStock;
import cam72cam.immersiverailroading.library.CraftingType;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.PlateType;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.ItemStack;
import java.util.Collections;
import java.util.List;

public class PlateRollerGUI
implements IScreen {
    private Button gaugeButton;
    private Gauge gauge;
    private Button pickerButton;
    private TileMultiblock tile;
    private ItemStack currentItem;

    public PlateRollerGUI(TileMultiblock te) {
        this.tile = te;
        this.currentItem = te.getCraftItem();
        if (this.currentItem == null || this.currentItem.isEmpty()) {
            this.currentItem = new ItemStack((CustomItem)IRItems.ITEM_PLATE, 1);
        }
        ItemPlate.Data data = new ItemPlate.Data(this.currentItem);
        this.gauge = data.gauge;
    }

    private void updatePickerButton() {
        this.pickerButton.setText(GuiText.SELECTOR_PLATE_TYPE.toString(this.currentItem != null ? this.currentItem.getDisplayName() : ""));
    }

    public void init(final IScreenBuilder screen) {
        this.gaugeButton = new Button(screen, -100, -24, GuiText.SELECTOR_GAUGE.toString(this.gauge)){

            public void onClick(Player.Hand hand) {
                if (!PlateRollerGUI.this.currentItem.isEmpty()) {
                    EntityRollingStockDefinition def = new ItemPlate.Data((ItemStack)((PlateRollerGUI)PlateRollerGUI.this).currentItem).def;
                    if (def != null && Config.ConfigBalance.DesignGaugeLock) {
                        List<Gauge> validGauges = Collections.singletonList(Gauge.from(def.recommended_gauge.value()));
                        PlateRollerGUI.this.gauge = ClickListHelper.next(validGauges, PlateRollerGUI.this.gauge, hand);
                    } else {
                        PlateRollerGUI.this.gauge = ClickListHelper.next(Gauge.values(), PlateRollerGUI.this.gauge, hand);
                    }
                }
                PlateRollerGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(PlateRollerGUI.this.gauge));
                PlateRollerGUI.this.sendPacket();
            }
        };
        this.pickerButton = new Button(screen, -100, 36, ""){

            public void onClick(Player.Hand hand) {
                CraftPicker.showCraftPicker(screen, null, CraftingType.PLATE_BOILER, item -> {
                    if (item != null) {
                        if (item.is((CustomItem)IRItems.ITEM_ROLLING_STOCK)) {
                            ItemRollingStock.Data stock = new ItemRollingStock.Data((ItemStack)item);
                            item = new ItemStack((CustomItem)IRItems.ITEM_PLATE, 1);
                            ItemPlate.Data data = new ItemPlate.Data((ItemStack)item);
                            data.def = stock.def;
                            data.gauge = PlateRollerGUI.this.gauge;
                            data.type = PlateType.BOILER;
                            data.write();
                        }
                        ItemPlate.Data data = new ItemPlate.Data((ItemStack)item);
                        EntityRollingStockDefinition def = data.def;
                        if (def != null && !PlateRollerGUI.this.gauge.isModel() && PlateRollerGUI.this.gauge.value() != def.recommended_gauge.value()) {
                            PlateRollerGUI.this.gauge = def.recommended_gauge;
                            PlateRollerGUI.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(PlateRollerGUI.this.gauge));
                        }
                        PlateRollerGUI.this.currentItem = item;
                        PlateRollerGUI.this.updatePickerButton();
                        PlateRollerGUI.this.sendPacket();
                    }
                });
            }
        };
        this.updatePickerButton();
    }

    public void onEnterKey(IScreenBuilder builder) {
        this.sendPacket();
        builder.close();
    }

    public void onClose() {
        this.sendPacket();
    }

    public void draw(IScreenBuilder builder) {
    }

    private void sendPacket() {
        ItemPlate.Data data = new ItemPlate.Data(this.currentItem);
        data.gauge = this.gauge;
        data.write();
        this.currentItem.setCount(Math.min(64, Math.max(1, (int)Math.floor((double)data.type.platesPerBlock() / this.gauge.scale()))));
        this.tile.setCraftItem(this.currentItem);
    }
}

