/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity.physics.chrono;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.physics.chrono.ChronoState;
import cam72cam.immersiverailroading.entity.physics.chrono.ServerChronoState;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.event.ClientEvents;
import cam72cam.mod.world.World;
import java.util.HashMap;
import java.util.Map;

public class ClientChronoState
implements ChronoState {
    private static final Map<World, ClientChronoState> states = new HashMap<World, ClientChronoState>();
    protected World world;
    private double tickID;
    private double tickSkew;
    private static long lastWorldTickId = -1L;

    private ClientChronoState(ServerChronoState server) {
        this.world = server.world;
        this.tickID = server.tickID;
        this.tickSkew = server.ticksPerSecond / 20.0;
    }

    private void tick() {
        this.tickID += this.tickSkew;
    }

    @Override
    public double getTickID() {
        return this.tickID;
    }

    @Override
    public double getTickSkew() {
        return this.tickSkew;
    }

    public static ClientChronoState getState(World world) {
        return states.get(world);
    }

    public static void updated(ServerChronoState server) {
        if (server.world == null) {
            return;
        }
        if (!states.containsKey(server.world)) {
            states.put(server.world, new ClientChronoState(server));
            return;
        }
        ClientChronoState client = ClientChronoState.getState(server.world);
        client.tickSkew = server.ticksPerSecond / 20.0;
        double delta = (double)server.tickID - client.tickID;
        if (Math.abs(delta) > 25.0) {
            ImmersiveRailroading.warn((String)"Server/Client desync, skipping from %s to %s", (Object[])new Object[]{client.tickID, server.tickID});
            client.tickID = server.tickID;
        } else {
            client.tickSkew += Math.max(-5.0, Math.min(5.0, delta)) / 100.0;
        }
    }

    static {
        ClientEvents.TICK.subscribe(() -> {
            long currWorldTickId;
            if (MinecraftClient.isReady() && (currWorldTickId = MinecraftClient.getPlayer().getWorld().getTicks()) != lastWorldTickId) {
                lastWorldTickId = currWorldTickId;
                ClientChronoState state = ClientChronoState.getState(MinecraftClient.getPlayer().getWorld());
                if (state != null) {
                    state.tick();
                }
            }
        });
    }
}

