/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.server;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.WhitelistCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class WhitelistSPacket {
    private String value;

    public WhitelistSPacket(PacketBuffer buf) {
        this.value = buf.func_218666_n();
    }

    public WhitelistSPacket(String slotnum) {
        this.value = slotnum;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.value);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            PlayerData data;
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (!sender.func_71121_q().func_201670_d() && (data = ((IPlayerData)sender).getPlayerData()) != null) {
                data.whitelist = ModUtils.stringExist(this.value) ? this.value : "empty";
                if (!((Boolean)ConfigHolder.COMMON.CAN_CHANGE_WHITELIST.get()).booleanValue() && ModUtils.stringExist((String)ConfigHolder.COMMON.whitelist.get())) {
                    data.whitelist = (String)ConfigHolder.COMMON.whitelist.get();
                }
                for (PlayerEntity sp : ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_217369_A()) {
                    Networking.sendToClient(new WhitelistCPacket(data.whitelist, false, sender.func_110124_au()), (ServerPlayerEntity)sp);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

