/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.server.BlacklistSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.HideTickSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.ItemStackSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.PositionsSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.RotationsSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.ScaleSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.SelectedSlotSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.SlotAttachmentSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.SlotMoverSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.ToggleSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.UniqueItemSettingsSPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.server.WhitelistSPacket;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendHandshakeCPacket {
    private UUID uuid;

    public SendHandshakeCPacket(PacketBuffer buf) {
        this.uuid = buf.func_179253_g();
    }

    public SendHandshakeCPacket(UUID uuid) {
        this.uuid = uuid;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (PlayerEntity sp : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            if (!sp.func_110124_au().equals(this.uuid)) continue;
            WeaponMasterMod.isMultiplayer = true;
            int[] positionsTemp = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
            int[] rotationsTemp = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
            int[] scaleTemp = new int[WeaponMasterMod.maxDisplaySlotNum];
            int[] toggleSlotsTemp = new int[WeaponMasterMod.maxDisplaySlotNum + 1];
            ItemStack[] inventory = new ItemStack[WeaponMasterMod.maxDisplaySlotNum];
            block1: for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                toggleSlotsTemp[i] = (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[i].get() != false ? 1 : 0;
                positionsTemp[i * 3] = (Integer)ConfigHolder.COMMON.positions[i * 3].get();
                positionsTemp[i * 3 + 1] = (Integer)ConfigHolder.COMMON.positions[i * 3 + 1].get();
                positionsTemp[i * 3 + 2] = (Integer)ConfigHolder.COMMON.positions[i * 3 + 2].get();
                rotationsTemp[i * 3] = (Integer)ConfigHolder.COMMON.rotations[i * 3].get();
                rotationsTemp[i * 3 + 1] = (Integer)ConfigHolder.COMMON.rotations[i * 3 + 1].get();
                rotationsTemp[i * 3 + 2] = (Integer)ConfigHolder.COMMON.rotations[i * 3 + 2].get();
                scaleTemp[i] = (Integer)ConfigHolder.COMMON.scale[i].get();
                if (i == 9) {
                    inventory[i] = sp.func_184592_cb() == null ? new ItemStack((IItemProvider)Items.field_190931_a) : sp.func_184592_cb();
                    continue;
                }
                if (i == 10) {
                    inventory[i] = new ItemStack((IItemProvider)Items.field_190931_a);
                    for (int j = 0; j < 9; ++j) {
                        if (inventory[j] == null || !(inventory[j].func_77973_b() instanceof ShootableItem)) continue;
                        inventory[i] = ServerHelper.getProjectile(sp, inventory[j]);
                        continue block1;
                    }
                    continue;
                }
                inventory[i] = sp.field_71071_by.func_70301_a(i) == null ? new ItemStack((IItemProvider)Items.field_190931_a) : sp.field_71071_by.func_70301_a(i);
            }
            toggleSlotsTemp[WeaponMasterMod.maxDisplaySlotNum] = (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[WeaponMasterMod.maxDisplaySlotNum].get() != false ? 1 : 0;
            int hideTick = (Integer)ConfigHolder.COMMON.hideTick.get();
            int selectedSlot = sp.field_71071_by.field_70461_c;
            String slotAttachment = (String)ConfigHolder.COMMON.slot_attachment.get();
            String slotMover = (String)ConfigHolder.COMMON.slotMover.get();
            String blacklist = (String)ConfigHolder.COMMON.blacklist.get();
            String whitelist = (String)ConfigHolder.COMMON.whitelist.get();
            String uniqueItemSettings = (String)ConfigHolder.COMMON.uniqueItemDisplay.get();
            if (!WeaponMasterMod.isMultiplayer) continue;
            Networking.sendToServer(new PositionsSPacket(positionsTemp));
            Networking.sendToServer(new RotationsSPacket(rotationsTemp));
            Networking.sendToServer(new ScaleSPacket(scaleTemp));
            Networking.sendToServer(new ToggleSPacket(toggleSlotsTemp));
            for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
                Networking.sendToServer(new ItemStackSPacket(inventory[i], i));
            }
            Networking.sendToServer(new HideTickSPacket(hideTick));
            Networking.sendToServer(new SelectedSlotSPacket(selectedSlot));
            Networking.sendToServer(new SlotAttachmentSPacket(slotAttachment));
            Networking.sendToServer(new SlotMoverSPacket(slotMover));
            Networking.sendToServer(new BlacklistSPacket(blacklist));
            Networking.sendToServer(new WhitelistSPacket(whitelist));
            Networking.sendToServer(new UniqueItemSettingsSPacket(uniqueItemSettings));
        }
    }
}

