/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class SelectedSlotCPacket {
    private int value;
    private UUID uuid;

    public SelectedSlotCPacket(PacketBuffer buf) {
        this.value = buf.readInt();
        this.uuid = buf.func_179253_g();
    }

    public SelectedSlotCPacket(int slotnum, UUID uuid) {
        this.value = slotnum;
        this.uuid = uuid;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.value);
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (PlayerEntity target : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            PlayerData data;
            if (!target.func_110124_au().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null) continue;
            data.selectedSlot = this.value;
        }
    }
}

