/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PositionsCPacket {
    private int[] value;
    private boolean setconfig;
    private UUID uuid;

    public PositionsCPacket(PacketBuffer buf) {
        this.value = buf.func_186863_b();
        this.setconfig = buf.readBoolean();
        this.uuid = buf.func_179253_g();
    }

    public PositionsCPacket(int[] slotnum, boolean setConfigForClient, UUID uuid) {
        this.value = slotnum;
        this.setconfig = setConfigForClient;
        this.uuid = uuid;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_186875_a(this.value);
        buf.writeBoolean(this.setconfig);
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (PlayerEntity target : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            PlayerData data;
            if (!target.func_110124_au().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null || this.value == null) continue;
            data.positions = this.value;
            if (target != Minecraft.func_71410_x().field_71439_g || !this.setconfig) continue;
            for (int i = 0; i < data.positions.length; ++i) {
                try {
                    ConfigHolder.COMMON.positions[i].set((Object)data.positions[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ClientOnlyForgeSetup.slotPositions = data.positions;
        }
    }
}

