/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class ItemStackCPacket {
    private ItemStack value;
    private int slot;
    private UUID uuid;

    public ItemStackCPacket(PacketBuffer buf) {
        this.value = buf.func_150791_c();
        this.slot = buf.readInt();
        this.uuid = buf.func_179253_g();
    }

    public ItemStackCPacket(ItemStack stack, int slotnum, UUID uuid) {
        this.value = stack;
        this.slot = slotnum;
        this.uuid = uuid;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150788_a(this.value);
        buf.writeInt(this.slot);
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (PlayerEntity target : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            PlayerData data;
            if (!target.func_110124_au().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null || this.value == null) continue;
            data.inventory[this.slot] = this.value;
        }
    }
}

