/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class HandActionCPacket {
    private boolean value;
    private UUID uuid;

    public HandActionCPacket(PacketBuffer buf) {
        this.value = buf.readBoolean();
        this.uuid = buf.func_179253_g();
    }

    public HandActionCPacket(boolean slotnum, UUID uuid) {
        this.value = slotnum;
        this.uuid = uuid;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.value);
        buf.func_179252_a(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (PlayerEntity target : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
            PlayerData data;
            if (!target.func_110124_au().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null) continue;
            if (this.value) {
                data.lastMainhandHit = 1;
                continue;
            }
            data.lastOffhandHit = 1;
        }
    }
}

