/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.events_on_server;

import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.minecraftserverzone.weaponmaster.setup.networking.Networking;
import com.minecraftserverzone.weaponmaster.setup.networking.client.ItemStackCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SelectedSlotCPacket;
import com.minecraftserverzone.weaponmaster.setup.networking.client.SendHandshakeCPacket;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="weaponmaster_ydm", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        event.getOriginal().revive();
        ((IPlayerData)event.getEntity()).setPlayerData(((IPlayerData)event.getOriginal()).getPlayerData());
        event.getOriginal().remove(true);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            PlayerEntity target = event.getPlayer();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            PlayerEntity target = event.getPlayer();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void onPlayerEntityStartTracking(PlayerEvent.StartTracking event) {
        if (!(event.getTarget() instanceof PlayerEntity)) {
            return;
        }
        if (!event.getEntity().field_70170_p.func_201670_d()) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            PlayerEntity target = (PlayerEntity)event.getTarget();
            ServerHelper.sendAllDataToClient(target, player);
        }
    }

    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null) {
            Networking.sendToClient(new SendHandshakeCPacket(player.func_110124_au()), (ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerData data;
        PlayerEntity player;
        if (event.phase == TickEvent.Phase.END && !event.player.field_70170_p.func_201670_d() && (player = event.player) != null && (data = ((IPlayerData)player).getPlayerData()) != null && player.field_71071_by != null) {
            if (player.field_71071_by.field_70461_c != data.selectedSlot) {
                data.selectedSlot = player.field_71071_by.field_70461_c;
                for (Object sp : player.field_70170_p.func_217369_A()) {
                    if (!(sp.func_70068_e((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new SelectedSlotCPacket(player.field_71071_by.field_70461_c, player.func_110124_au()), (ServerPlayerEntity)sp);
                }
            }
            for (int i = 0; i < 9; ++i) {
                if (player.field_71071_by.func_70301_a(i) == null || player.field_71071_by.func_70301_a(i).equals(data.inventory[i], false)) continue;
                data.inventory[i] = player.field_71071_by.func_70301_a(i).func_77946_l();
                for (PlayerEntity sp : player.field_70170_p.func_217369_A()) {
                    if (!(sp.func_70068_e((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(data.inventory[i], i, player.func_110124_au()), (ServerPlayerEntity)sp);
                }
            }
            if (player.func_184592_cb() != null && !player.func_184592_cb().equals(data.inventory[9], false)) {
                data.inventory[9] = player.func_184592_cb().func_77946_l();
                for (Object sp : player.field_70170_p.func_217369_A()) {
                    if (!(sp.func_70068_e((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(data.inventory[9], 9, player.func_110124_au()), (ServerPlayerEntity)sp);
                }
            }
            boolean hasProjectileWeaponItem = false;
            for (int j = 0; j < 9; ++j) {
                if (data.inventory[j] == null || !(data.inventory[j].func_77973_b() instanceof ShootableItem)) continue;
                hasProjectileWeaponItem = true;
                ItemStack ammo = ServerHelper.getProjectile(player, data.inventory[j]);
                if (data.inventory[10].equals(ammo, false)) continue;
                data.inventory[10] = ammo.func_77946_l();
                hasProjectileWeaponItem = true;
                for (PlayerEntity sp : player.field_70170_p.func_217369_A()) {
                    if (!(sp.func_70068_e((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(ammo, 10, player.func_110124_au()), (ServerPlayerEntity)sp);
                }
                break;
            }
            if (!hasProjectileWeaponItem && !data.inventory[10].equals(ItemStack.field_190927_a, false)) {
                data.inventory[10] = ItemStack.field_190927_a;
                for (PlayerEntity sp : player.field_70170_p.func_217369_A()) {
                    if (!(sp.func_70068_e((Entity)player) < 4000.0)) continue;
                    Networking.sendToClient(new ItemStackCPacket(ItemStack.field_190927_a, 10, player.func_110124_au()), (ServerPlayerEntity)sp);
                }
            }
        }
    }
}

