/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.itemlayers;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import com.minecraftserverzone.weaponmaster.itemlayers.RenderHelper;
import com.minecraftserverzone.weaponmaster.renderer.quiver.QuiverWithArrowsModel;
import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.configs.WeaponsMasterMultiModConfig;
import com.minecraftserverzone.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.helper.ModUtils;
import com.minecraftserverzone.weaponmaster.setup.helper.ServerHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.IArmorVanishable;
import net.minecraft.enchantment.IVanishable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SpectralArrowItem;
import net.minecraft.item.TieredItem;
import net.minecraft.item.TridentItem;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HumanoidItemLayer<T extends LivingEntity, M extends BipedModel<T>>
extends LayerRenderer<T, M> {
    public QuiverWithArrowsModel<T> quiver;
    public QuiverWithArrowsModel<T> arrows;
    public static ResourceLocation QUIVER = new ResourceLocation("weaponmaster_ydm", "textures/entity/quiver.png");
    public static ResourceLocation ARROW_TEXTURE = new ResourceLocation("weaponmaster_ydm", "textures/entity/normal_arrow.png");
    public static ResourceLocation ARROW_TEXTURE_SPECTRAL = new ResourceLocation("weaponmaster_ydm", "textures/entity/spectral_arrow.png");

    public HumanoidItemLayer(IEntityRenderer<T, M> p_174516_) {
        super(p_174516_);
    }

    public void renderPlayerWithItems(LivingEntity p_174525_, MatrixStack p_174529_, IRenderTypeBuffer p_174530_, int p_174531_) {
        if (this.quiver == null) {
            this.quiver = new QuiverWithArrowsModel(64, 64);
        }
        if (this.arrows == null) {
            this.arrows = new QuiverWithArrowsModel(64, 64);
        }
        if (p_174525_ instanceof ClientPlayerEntity) {
            this.renderWithItems(p_174525_, p_174529_, p_174530_, p_174531_);
        } else if (WeaponMasterMod.isMultiplayer && p_174525_ instanceof PlayerEntity && this.func_215332_c() instanceof BipedModel) {
            RenderHelper.renderOtherPlayerWithItems((PlayerEntity)p_174525_, p_174529_, p_174530_, p_174531_, (BipedModel<LivingEntity>)((BipedModel)this.func_215332_c()));
        }
    }

    public boolean blackListed(Item item) {
        if (ClientOnlyForgeSetup.blacklist != null) {
            String[] blacklist;
            for (String bl : blacklist = ClientOnlyForgeSetup.blacklist.split(",")) {
                if (!item.toString().equals(bl)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean whiteListed(Item item) {
        if (ClientOnlyForgeSetup.whitelist != null) {
            String[] whitelist;
            for (String bl : whitelist = ClientOnlyForgeSetup.whitelist.split(",")) {
                if (!item.toString().equals(bl)) continue;
                return true;
            }
        }
        return false;
    }

    private int hasItems(PlayerEntity player, String[][] moveTypes, int slot, int selected, int shieldSlot, int bannerSlot, int[] toggleSlots) {
        int j;
        int i = 0;
        for (j = 0; j < 9; ++j) {
            if (!moveTypes[slot][0].contains(String.valueOf(j + 1)) || player.field_71071_by.func_70301_a(j).func_190926_b() || player.field_71071_by.field_70461_c == j || toggleSlots[j] != 1) continue;
            ++i;
        }
        if (moveTypes[slot][0].contains("shield") && shieldSlot > -1 && player.field_71071_by.field_70461_c != shieldSlot && toggleSlots[9] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("banner") && bannerSlot > -1 && player.field_71071_by.field_70461_c != bannerSlot && toggleSlots[10] == 1) {
            ++i;
        }
        if (moveTypes[slot][0].contains("quiver")) {
            for (j = 0; j < 9; ++j) {
                if (ServerHelper.getProjectile(player, player.field_71071_by.func_70301_a(j)) == null || !(ServerHelper.getProjectile(player, player.field_71071_by.func_70301_a(j)).func_77973_b() instanceof ArrowItem) || player.field_71071_by.func_70301_a(j).func_190926_b() || toggleSlots[10] != 1) continue;
                ++i;
                break;
            }
        }
        return i;
    }

    public void render(MatrixStack p_117204_, IRenderTypeBuffer p_117205_, int p_117206_, T p_117207_, float p_117208_, float p_117209_, float p_117210_, float p_117211_, float p_117212_, float p_117213_) {
        p_117204_.func_227860_a_();
        if (ModList.get().isLoaded("yearsc") && ((BipedModel)this.func_215332_c()).field_217114_e) {
            float f = 0.5f;
            p_117204_.func_227861_a_(0.0, 0.75, 0.0);
            p_117204_.func_227862_a_(f, f, f);
        }
        this.renderPlayerWithItems((LivingEntity)p_117207_, p_117204_, p_117205_, p_117206_);
        p_117204_.func_227865_b_();
    }

    private void move(MatrixStack matrixStack, String[][] moveTypes, int slot, float translation) {
        if (moveTypes[slot][2].equals("-")) {
            translation = -translation;
        }
        if (moveTypes[slot][1].equals("x")) {
            matrixStack.func_227861_a_((double)translation, 0.0, 0.0);
        } else if (moveTypes[slot][1].equals("y")) {
            matrixStack.func_227861_a_(0.0, (double)translation, 0.0);
        } else if (moveTypes[slot][1].equals("z")) {
            matrixStack.func_227861_a_(0.0, 0.0, (double)translation);
        }
    }

    private boolean hasEquipments(PlayerEntity player, String[][] moveTypes, int slot) {
        boolean move = false;
        if (moveTypes[slot][0].contains("helm") && !player.field_71071_by.func_70440_f(3).func_190926_b()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("chest") && !player.field_71071_by.func_70440_f(2).func_190926_b()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("legs") && !player.field_71071_by.func_70440_f(1).func_190926_b()) {
            move = true;
        }
        if (moveTypes[slot][0].contains("boots") && !player.field_71071_by.func_70440_f(0).func_190926_b()) {
            move = true;
        }
        return move;
    }

    private void renderWithItems(LivingEntity p_174518_, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_) {
        float f;
        float scalePlus;
        float f2;
        float scalePlus2;
        int[] add;
        float moveBy;
        String[] moveSlots = ClientOnlyForgeSetup.slotMover.split("_");
        String[][] moveTypes = new String[][]{moveSlots[0].split(";"), moveSlots[1].split(";"), moveSlots[2].split(";"), moveSlots[3].split(";"), moveSlots[4].split(";"), moveSlots[5].split(";"), moveSlots[6].split(";"), moveSlots[7].split(";"), moveSlots[8].split(";"), moveSlots[9].split(";"), moveSlots[10].split(";"), moveSlots[11].split(";"), moveSlots[12].split(";")};
        PlayerEntity p = (PlayerEntity)p_174518_;
        int selected = p.field_71071_by.field_70461_c;
        ItemStack stack1 = this.blackListed(p.field_71071_by.func_70301_a(0).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(0);
        ItemStack stack2 = this.blackListed(p.field_71071_by.func_70301_a(1).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(1);
        ItemStack stack3 = this.blackListed(p.field_71071_by.func_70301_a(2).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(2);
        ItemStack stack4 = this.blackListed(p.field_71071_by.func_70301_a(3).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(3);
        ItemStack stack5 = this.blackListed(p.field_71071_by.func_70301_a(4).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(4);
        ItemStack stack6 = this.blackListed(p.field_71071_by.func_70301_a(5).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(5);
        ItemStack stack7 = this.blackListed(p.field_71071_by.func_70301_a(6).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(6);
        ItemStack stack8 = this.blackListed(p.field_71071_by.func_70301_a(7).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(7);
        ItemStack stack9 = this.blackListed(p.field_71071_by.func_70301_a(8).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(8);
        ItemStack ammo = this.blackListed(p.field_71071_by.func_70301_a(10).func_77973_b()) ? ItemStack.field_190927_a : p.field_71071_by.func_70301_a(10);
        ItemStack offhand = this.blackListed(p.func_184592_cb().func_77973_b()) ? ItemStack.field_190927_a : p.func_184592_cb();
        ItemStack[] items = new ItemStack[]{stack1, stack2, stack3, stack4, stack5, stack6, stack7, stack8, stack9, offhand, ammo};
        int[] toggleSlots = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] slotPositions = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
        int[] slotRotations = new int[WeaponMasterMod.maxDisplaySlotNum * 3];
        int[] scale = new int[WeaponMasterMod.maxDisplaySlotNum];
        String[] bodyattachments = ClientOnlyForgeSetup.slotAttachment.split(",");
        String[][] bodyattachment = new String[WeaponMasterMod.maxDisplaySlotNum][2];
        for (int i = 0; i < WeaponMasterMod.maxDisplaySlotNum; ++i) {
            bodyattachment[i][0] = bodyattachments[i].split("-")[0];
            bodyattachment[i][1] = bodyattachments[i].split("-")[1];
        }
        if (p instanceof ClientPlayerEntity) {
            int[] toggleSlots2 = new int[]{(Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[0].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[1].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[2].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[3].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[4].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[5].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[6].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[7].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[8].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[9].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[10].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[11].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[12].get() != false ? 1 : 0, (Boolean)ConfigHolder.COMMON.TOGGLE_SLOT_MODEL[13].get() != false ? 1 : 0};
            toggleSlots = toggleSlots2;
            slotPositions = ClientOnlyForgeSetup.slotPositions;
            slotRotations = ClientOnlyForgeSetup.slotRotations;
            scale = ClientOnlyForgeSetup.scale;
        }
        if (ClientOnlyForgeSetup.lastMainhandHit >= ClientOnlyForgeSetup.hideTick && ((Boolean)WeaponsMasterMultiModConfig.TOGGLE_SLOT_MODEL[11].get()).booleanValue()) {
            selected = -1;
        }
        int shieldAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].func_77973_b() instanceof ShieldItem)) continue;
            shieldAt = i;
            break;
        }
        int bannerAt = -1;
        for (int i = 0; i < 9; ++i) {
            if (!(items[i].func_77973_b() instanceof BannerItem)) continue;
            bannerAt = i;
            break;
        }
        if (bannerAt != -1 && selected != bannerAt && toggleSlots[10] == 1) {
            p_174521_.func_227860_a_();
            this.copyModelPartRotation(p_174521_, 10, bodyattachment, 0.01f, 1.0f);
            float moveBy2 = (float)this.hasItems(p, moveTypes, 10, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            this.move(p_174521_, moveTypes, 10, moveBy2);
            moveBy = this.hasEquipments(p, moveTypes, 10) ? 0.038f : 0.0f;
            this.move(p_174521_, moveTypes, 10, moveBy);
            add = HumanoidItemLayer.uniqueSettings(items[bannerAt], 10);
            p_174521_.func_227861_a_((double)((float)(slotPositions[30] + add[0]) / 100.0f), (double)((float)(slotPositions[31] + add[1]) / 100.0f), (double)((float)(slotPositions[32] + add[2]) / 100.0f));
            p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[30] + add[3])));
            p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[31] + add[4])));
            p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[32] + add[5])));
            p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
            p_174521_.func_227861_a_(0.0, 0.6, -0.3);
            scalePlus2 = ((float)scale[10] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.75f;
            p_174521_.func_227862_a_(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, items[bannerAt], ItemCameraTransforms.TransformType.NONE, false, p_174521_, p_174522_, p_174523_);
            p_174521_.func_227865_b_();
        }
        p_174521_.func_227860_a_();
        if (shieldAt != -1 && selected != shieldAt && toggleSlots[9] == 1) {
            p_174521_.func_227860_a_();
            this.copyModelPartRotation(p_174521_, 9, bodyattachment, 1.0f, 1.0f);
            float moveBy2 = (float)this.hasItems(p, moveTypes, 9, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            this.move(p_174521_, moveTypes, 9, moveBy2);
            moveBy = this.hasEquipments(p, moveTypes, 9) ? 0.038f : 0.0f;
            this.move(p_174521_, moveTypes, 9, moveBy);
            add = HumanoidItemLayer.uniqueSettings(items[shieldAt], 9);
            p_174521_.func_227861_a_((double)((float)(slotPositions[27] + add[0]) / 100.0f), (double)((float)(slotPositions[28] + add[1]) / 100.0f), (double)((float)(slotPositions[29] + add[2]) / 100.0f));
            p_174521_.func_227861_a_(0.0, 0.0, 0.015);
            p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[27] + add[3])));
            p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[28] + add[4])));
            p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[29] + add[5])));
            p_174521_.func_227861_a_((double)0.3f, 0.7, 0.5);
            scalePlus2 = ((float)scale[9] + 0.001f + (float)add[6]) / 100.0f;
            f2 = 0.6f;
            p_174521_.func_227862_a_(f2 + scalePlus2, f2 + scalePlus2, f2 + scalePlus2);
            p_174521_.func_227861_a_(-0.25, -0.375, -0.625);
            p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, items[shieldAt], ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, false, p_174521_, p_174522_, p_174523_);
            p_174521_.func_227865_b_();
        }
        if (p.field_71071_by != null && toggleSlots[13] == 1) {
            int size;
            boolean hasBowOrCrossbow = false;
            ItemStack projectile = new ItemStack((IItemProvider)Items.field_190931_a);
            for (int i = 0; i < 9; ++i) {
                if (items[i] == null || !(items[i].func_77973_b() instanceof ShootableItem)) continue;
                projectile = ServerHelper.getProjectile(p, items[i]);
                hasBowOrCrossbow = true;
                break;
            }
            if ((size = projectile.func_190916_E()) > 0 && hasBowOrCrossbow) {
                p_174521_.func_227860_a_();
                this.copyModelPartRotation(p_174521_, 12, bodyattachment, 1.0f, 1.0f);
                int[] add2 = new int[]{0, 0, 0, 0, 0, 0, 0};
                p_174521_.func_227861_a_((double)((float)(slotPositions[36] + add2[0]) / 100.0f), (double)((float)(slotPositions[37] + add2[1]) / 100.0f), (double)((float)(slotPositions[38] + add2[2]) / 100.0f));
                float moveBy2 = (float)this.hasItems(p, moveTypes, 12, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, 12, moveBy2);
                float moveByArmor = this.hasEquipments(p, moveTypes, 12) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, 12, moveByArmor);
                p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[36] + add2[3])));
                p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[37] + add2[4])));
                p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[38] + add2[5])));
                scalePlus = ((float)scale[12] + 0.001f + (float)add2[6]) / 100.0f;
                f = 0.5f;
                p_174521_.func_227862_a_(f + scalePlus, f + scalePlus, f + scalePlus);
                this.quiver.setupAnim(0, p, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                ResourceLocation texture = QUIVER;
                if (projectile.func_77973_b() != null && projectile.func_77973_b() != Items.field_190931_a) {
                    IVertexBuilder vertexConsumer;
                    ResourceLocation arrow;
                    if (projectile.func_77973_b() instanceof SpectralArrowItem) {
                        arrow = ARROW_TEXTURE_SPECTRAL;
                        vertexConsumer = p_174522_.getBuffer(RenderType.func_228640_c_((ResourceLocation)arrow));
                        this.arrows.setupAnim(size, p, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        this.arrows.func_225598_a_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                    } else if (projectile.func_77973_b() instanceof ArrowItem) {
                        arrow = ARROW_TEXTURE;
                        vertexConsumer = p_174522_.getBuffer(RenderType.func_228640_c_((ResourceLocation)arrow));
                        this.arrows.setupAnim(size, p, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                        this.arrows.func_225598_a_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                }
                IVertexBuilder vertexConsumer = p_174522_.getBuffer(RenderType.func_228640_c_((ResourceLocation)texture));
                this.quiver.func_225598_a_(p_174521_, vertexConsumer, p_174523_, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                p_174521_.func_227865_b_();
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            boolean rightHanded;
            if (items[slot].func_190926_b() || selected == slot || shieldAt == slot || bannerAt == slot || toggleSlots[slot] != 1) continue;
            p_174521_.func_227860_a_();
            this.copyModelPartRotation(p_174521_, slot, bodyattachment, 1.0f, 1.0f);
            int[] add3 = HumanoidItemLayer.uniqueSettings(items[slot], slot);
            p_174521_.func_227861_a_((double)((float)(slotPositions[slot * 3] + add3[0]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 1] + add3[1]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 2] + add3[2]) / 100.0f));
            float moveBy3 = (float)this.hasItems(p, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
            this.move(p_174521_, moveTypes, slot, moveBy3);
            float moveByArmor = this.hasEquipments(p, moveTypes, slot) ? 0.038f : 0.0f;
            this.move(p_174521_, moveTypes, slot, moveByArmor);
            p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[slot * 3] + add3[3])));
            p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[slot * 3 + 1] + add3[4])));
            p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[slot * 3 + 2] + add3[5])));
            ItemCameraTransforms.TransformType ctx = ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            boolean bl = rightHanded = p_174518_.func_184591_cq() == HandSide.RIGHT;
            if (slot == 11) {
                ctx = rightHanded ? ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            }
            scalePlus = ((float)scale[slot] + 0.001f + (float)add3[6]) / 100.0f;
            f = 1.0f;
            p_174521_.func_227862_a_(f + scalePlus, f + scalePlus, f + scalePlus);
            if (items[slot].func_77973_b() instanceof BowItem) {
                this.renderBowItem(slot, p_174518_, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].func_77973_b() instanceof CrossbowItem) {
                this.renderCrossbowItem(slot, p_174518_, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (items[slot].func_77973_b().getClass().equals(TridentItem.class)) {
                this.renderTridentItem(slot, p_174518_, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if ((items[slot].func_77973_b() instanceof TieredItem || items[slot].func_77973_b() instanceof IVanishable) && !(items[slot].func_77973_b() instanceof IArmorVanishable)) {
                this.renderTieredItem(slot, p_174518_, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            } else if (this.whiteListed(items[slot].func_77973_b())) {
                p_174521_.func_227861_a_(0.0, 0.7, 0.0);
                p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                this.renderNormalItem(slot, p_174518_, items[slot], p_174521_, p_174522_, p_174523_, ctx);
            }
            p_174521_.func_227865_b_();
        }
        int itemslot = 9;
        int slot = 11;
        if (!items[itemslot].func_190926_b() && toggleSlots[slot + 1] == 1 && ClientOnlyForgeSetup.lastOffhandHit >= ClientOnlyForgeSetup.hideTick) {
            float moveByArmor;
            if (items[itemslot].func_77973_b() != null && items[itemslot].func_77973_b() instanceof ShieldItem) {
                p_174521_.func_227860_a_();
                this.copyModelPartRotation(p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add4 = HumanoidItemLayer.uniqueSettings(items[itemslot], 11);
                p_174521_.func_227861_a_((double)((float)(slotPositions[slot * 3] + add4[0]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 1] + add4[1]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 2] + add4[2]) / 100.0f));
                float moveBy4 = (float)this.hasItems(p, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, slot, moveBy4);
                moveByArmor = this.hasEquipments(p, moveTypes, slot) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[slot * 3] + add4[3])));
                p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[slot * 3 + 1] + add4[4])));
                p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[slot * 3 + 2] + add4[5])));
                ItemCameraTransforms.TransformType ctx = ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
                p_174521_.func_227861_a_((double)0.3f, 0.35, 0.38);
                scalePlus = ((float)scale[slot] + 0.001f + (float)add4[6]) / 100.0f;
                f = 0.6f;
                p_174521_.func_227862_a_(f + scalePlus, f + scalePlus, f + scalePlus);
                p_174521_.func_227861_a_(-0.25, -0.375, -0.625);
                p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-35.0f));
                Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, items[itemslot], ctx, false, p_174521_, p_174522_, p_174523_);
                p_174521_.func_227865_b_();
            } else {
                p_174521_.func_227860_a_();
                this.copyModelPartRotation(p_174521_, slot, bodyattachment, 1.0f, 1.0f);
                int[] add5 = HumanoidItemLayer.uniqueSettings(items[itemslot], 11);
                p_174521_.func_227861_a_((double)((float)(slotPositions[slot * 3] + add5[0]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 1] + add5[1]) / 100.0f), (double)((float)(slotPositions[slot * 3 + 2] + add5[2]) / 100.0f));
                float moveBy5 = (float)this.hasItems(p, moveTypes, slot, selected, shieldAt, bannerAt, toggleSlots) * 0.042f;
                this.move(p_174521_, moveTypes, slot, moveBy5);
                moveByArmor = this.hasEquipments(p, moveTypes, slot) ? 0.038f : 0.0f;
                this.move(p_174521_, moveTypes, slot, moveByArmor);
                p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_((float)(slotRotations[slot * 3] + add5[3])));
                p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(slotRotations[slot * 3 + 1] + add5[4])));
                p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(slotRotations[slot * 3 + 2] + add5[5])));
                ItemCameraTransforms.TransformType ctx = ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
                scalePlus = ((float)scale[slot] + 0.001f + (float)add5[6]) / 100.0f;
                f = 1.0f;
                p_174521_.func_227862_a_(f + scalePlus, f + scalePlus, f + scalePlus);
                if (items[itemslot].func_77973_b() instanceof BowItem) {
                    this.renderBowItem(itemslot, p_174518_, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].func_77973_b() instanceof CrossbowItem) {
                    this.renderCrossbowItem(itemslot, p_174518_, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (items[itemslot].func_77973_b().getClass().equals(TridentItem.class)) {
                    this.renderTridentItem(itemslot, p_174518_, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if ((items[itemslot].func_77973_b() instanceof TieredItem || items[itemslot].func_77973_b() instanceof IVanishable) && !(items[itemslot].func_77973_b() instanceof IArmorVanishable)) {
                    this.renderTieredItem(itemslot, p_174518_, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                } else if (this.whiteListed(items[itemslot].func_77973_b())) {
                    p_174521_.func_227861_a_(0.0, 0.7, 0.0);
                    p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
                    this.renderNormalItem(itemslot, p_174518_, items[itemslot], p_174521_, p_174522_, p_174523_, ctx);
                }
                p_174521_.func_227865_b_();
            }
        }
        p_174521_.func_227865_b_();
    }

    public void translateToHand(ModelRenderer part, HandSide p_102854_, MatrixStack p_102855_) {
        part.func_228307_a_(p_102855_);
    }

    public void translateAndRotate(MatrixStack p_104300_, float x, float y, float z, float xRot, float yRot, float zRot, float xScale, float yScale, float zScale) {
        p_104300_.func_227861_a_((double)(x / 16.0f), (double)(y / 16.0f), (double)(z / 16.0f));
        if (zRot != 0.0f) {
            p_104300_.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(zRot));
        }
        if (yRot != 0.0f) {
            p_104300_.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(yRot));
        }
        if (xRot != 0.0f) {
            p_104300_.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(xRot));
        }
        if (xScale != 1.0f || yScale != 1.0f || zScale != 1.0f) {
            p_104300_.func_227862_a_(xScale, yScale, zScale);
        }
    }

    public void copyModelPartRotation(MatrixStack ps, int slot, String[][] bodyattachment, float multiplier, float maxRotateChanger) {
        ModelRenderer part = ((BipedModel)this.func_215332_c()).field_78115_e;
        if (bodyattachment[slot][1].equals("head")) {
            part = ((BipedModel)this.func_215332_c()).func_205072_a();
        } else if (bodyattachment[slot][1].equals("body")) {
            part = ((BipedModel)this.func_215332_c()).field_78115_e;
        } else if (bodyattachment[slot][1].equals("rarm")) {
            part = ((BipedModel)this.func_215332_c()).field_178723_h;
        } else if (bodyattachment[slot][1].equals("larm")) {
            part = ((BipedModel)this.func_215332_c()).field_178724_i;
        } else if (bodyattachment[slot][1].equals("rleg")) {
            part = ((BipedModel)this.func_215332_c()).field_178721_j;
        } else if (bodyattachment[slot][1].equals("lleg")) {
            part = ((BipedModel)this.func_215332_c()).field_178722_k;
        }
        part.func_228307_a_(ps);
    }

    private void renderTridentItem(int slot, LivingEntity p_174518_, ItemStack itemStack, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_, ItemCameraTransforms.TransformType ctx) {
        p_174521_.func_227860_a_();
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(140.0f));
        p_174521_.func_227861_a_((double)0.7f, 0.9, 0.61);
        p_174521_.func_227862_a_(0.9f, 0.9f, 0.9f);
        p_174521_.func_227861_a_((double)-0.45f, (double)-1.07f, (double)-0.535f);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-60.0f));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.func_227865_b_();
    }

    private void renderCrossbowItem(int slot, LivingEntity p_174518_, ItemStack itemStack, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_, ItemCameraTransforms.TransformType ctx) {
        p_174521_.func_227860_a_();
        p_174521_.func_227861_a_(-0.05, 0.35, 0.16);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(270.0f));
        p_174521_.func_227862_a_(0.8f, -0.8f, -0.8f);
        p_174521_.func_227861_a_((double)0.1f, (double)-0.2f, 0.0);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(0.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(60.0f));
        p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.func_227865_b_();
    }

    private void renderBowItem(int slot, LivingEntity p_174518_, ItemStack itemStack, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_, ItemCameraTransforms.TransformType ctx) {
        p_174521_.func_227860_a_();
        p_174521_.func_227861_a_(0.0, 0.35, 0.16);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        p_174521_.func_227862_a_(0.8f, -0.8f, -0.8f);
        p_174521_.func_227861_a_(-0.05, 0.2, -0.07);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(97.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-6.0f));
        p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(40.0f));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.func_227865_b_();
    }

    private void renderNormalItem(int slot, LivingEntity p_174518_, ItemStack itemStack, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_, ItemCameraTransforms.TransformType ctx) {
        p_174521_.func_227860_a_();
        p_174521_.func_227861_a_(0.0, 0.35, 0.16);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        p_174521_.func_227862_a_(0.8f, -0.8f, -0.8f);
        p_174521_.func_227861_a_((double)0.1f, (double)-0.1f, (double)-0.08f);
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.func_227865_b_();
    }

    private void renderTieredItem(int slot, LivingEntity p_174518_, ItemStack itemStack, MatrixStack p_174521_, IRenderTypeBuffer p_174522_, int p_174523_, ItemCameraTransforms.TransformType ctx) {
        p_174521_.func_227860_a_();
        p_174521_.func_227861_a_(-0.05, 0.3, 0.16);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        p_174521_.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        p_174521_.func_227862_a_(0.8f, -0.8f, -0.8f);
        p_174521_.func_227861_a_(-0.2, -0.1, -0.0);
        p_174521_.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        p_174521_.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(55.0f));
        Minecraft.func_71410_x().func_175597_ag().func_228397_a_(p_174518_, itemStack, ctx, false, p_174521_, p_174522_, p_174523_);
        p_174521_.func_227865_b_();
    }

    public static int[] uniqueSettings(ItemStack stack, int slotNumber) {
        String selectedSlotNumber = "0";
        if (slotNumber < 9) {
            selectedSlotNumber = String.valueOf(slotNumber + 1);
        } else if (slotNumber == 9) {
            selectedSlotNumber = "shield";
        } else if (slotNumber == 10) {
            selectedSlotNumber = "banner";
        } else if (slotNumber == 11) {
            selectedSlotNumber = "offhand";
        } else if (slotNumber == 12) {
            selectedSlotNumber = "quiver";
        }
        if (stack != null && stack.func_77973_b() != null && ModUtils.stringContains(ClientOnlyForgeSetup.uniqueItemDisplay, ",")) {
            if (ModUtils.stringContains(ClientOnlyForgeSetup.uniqueItemDisplay, " ")) {
                String[] allData = ClientOnlyForgeSetup.uniqueItemDisplay.split(" ");
                for (int i = 0; i < allData.length; ++i) {
                    if (!ModUtils.stringContains(allData[i], ",")) continue;
                    String name = StringUtils.substringBefore((String)allData[i], (String)",");
                    String[] data = allData[i].split(",");
                    if (!ModUtils.arrayExist(data, 9) || stack.func_77973_b().toString() == null || !stack.func_77973_b().toString().equals(name) || !ModUtils.stringEquals(data[8], selectedSlotNumber)) continue;
                    return HumanoidItemLayer.getData(allData[i]);
                }
            } else {
                String name = StringUtils.substringBefore((String)ClientOnlyForgeSetup.uniqueItemDisplay, (String)",");
                String[] data = ClientOnlyForgeSetup.uniqueItemDisplay.split(",");
                if (ModUtils.arrayExist(data, 9) && stack.func_77973_b().toString() != null && stack.func_77973_b().toString().equals(name) && ModUtils.stringEquals(data[8], selectedSlotNumber)) {
                    return HumanoidItemLayer.getData(ClientOnlyForgeSetup.uniqueItemDisplay);
                }
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }

    public static int[] getData(String s) {
        String[] txtArray = s.split(",");
        if (ModUtils.arrayExist(txtArray, 8)) {
            int x = 0;
            if (NumberUtils.isCreatable((String)txtArray[1])) {
                x = NumberUtils.createInteger((String)txtArray[1]);
            }
            int y = 0;
            if (NumberUtils.isCreatable((String)txtArray[2])) {
                y = NumberUtils.createInteger((String)txtArray[2]);
            }
            int z = 0;
            if (NumberUtils.isCreatable((String)txtArray[3])) {
                z = NumberUtils.createInteger((String)txtArray[3]);
            }
            int xrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[4])) {
                xrot = NumberUtils.createInteger((String)txtArray[4]);
            }
            int yrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[5])) {
                yrot = NumberUtils.createInteger((String)txtArray[5]);
            }
            int zrot = 0;
            if (NumberUtils.isCreatable((String)txtArray[6])) {
                zrot = NumberUtils.createInteger((String)txtArray[6]);
            }
            int scale = 0;
            if (NumberUtils.isCreatable((String)txtArray[7])) {
                scale = NumberUtils.createInteger((String)txtArray[7]);
            }
            return new int[]{x, y, z, xrot, yrot, zrot, scale};
        }
        return new int[]{0, 0, 0, 0, 0, 0, 0};
    }
}

