/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.gui.togglebutton;

import com.minecraftserverzone.weaponmaster.setup.helper.GuiHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IRenderable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractToggleWidget
extends AbstractGui
implements IRenderable,
IGuiEventListener {
    public static final ResourceLocation WIDGETS_LOCATION = new ResourceLocation("weaponmaster_ydm", "textures/gui/widgets.png");
    protected int width;
    protected int height;
    public int x;
    public int y;
    private ITextComponent message;
    protected boolean isHovered;
    public boolean active = true;
    public boolean visible = true;
    protected float alpha = 1.0f;
    private boolean focused;
    public boolean toggle;
    public static final int UNSET_FG_COLOR = -1;
    protected int packedFGColor = -1;

    public AbstractToggleWidget(int p_93629_, int p_93630_, int p_93631_, int p_93632_, ITextComponent p_93633_, boolean toggle, int visible) {
        this.x = p_93629_;
        this.y = p_93630_;
        this.width = p_93631_;
        this.height = p_93632_;
        this.message = p_93633_;
        this.toggle = toggle;
        if (visible == 1) {
            this.visible = false;
        }
    }

    public int getHeight() {
        return this.height;
    }

    protected int getYImage(boolean p_93668_) {
        int i = 1;
        if (!this.active) {
            i = 0;
        } else if (p_93668_) {
            i = 2;
        }
        return i;
    }

    public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
        if (this.visible) {
            this.isHovered = p_93658_ >= this.x && p_93659_ >= this.y && p_93658_ < this.x + this.width && p_93659_ < this.y + this.height;
            this.renderButton(p_93657_, p_93658_, p_93659_, p_93660_);
        }
    }

    public void renderButton(MatrixStack p_93676_, int p_93677_, int p_93678_, float p_93679_) {
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer font = minecraft.field_71466_p;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int i = this.getYImage(this.isHoveredOrFocused());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        if (!this.toggle) {
            i = i == 1 ? 0 : 3;
        }
        GuiHelper.blit(WIDGETS_LOCATION, p_93676_, this.x, this.y, 0, 46 + i * 20, this.width / 2, this.height);
        GuiHelper.blit(WIDGETS_LOCATION, p_93676_, this.x + this.width / 2, this.y, 200 - this.width / 2, 46 + i * 20, this.width / 2, this.height);
        int j = this.getFGColor();
        AbstractToggleWidget.func_238472_a_((MatrixStack)p_93676_, (FontRenderer)font, (ITextComponent)this.getMessage(), (int)(this.x + this.width / 2), (int)(this.y + (this.height - 8) / 2), (int)(j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24));
    }

    protected void renderBg(MatrixStack p_93661_, Minecraft p_93662_, int p_93663_, int p_93664_) {
    }

    public void onRelease(double p_93669_, double p_93670_) {
    }

    protected void onDrag(double p_93636_, double p_93637_, double p_93638_, double p_93639_) {
    }

    public boolean func_231044_a_(double p_93641_, double p_93642_, int p_93643_) {
        if (this.active && this.visible) {
            boolean flag;
            if (this.isValidClickButton(p_93643_) && (flag = this.clicked(p_93641_, p_93642_))) {
                this.playDownSound(Minecraft.func_71410_x().func_147118_V());
                this.onClick(p_93641_, p_93642_);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean func_231048_c_(double p_93684_, double p_93685_, int p_93686_) {
        if (this.isValidClickButton(p_93686_)) {
            this.onRelease(p_93684_, p_93685_);
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int p_93652_) {
        return p_93652_ == 0;
    }

    public boolean func_231045_a_(double p_93645_, double p_93646_, int p_93647_, double p_93648_, double p_93649_) {
        if (this.isValidClickButton(p_93647_)) {
            this.onDrag(p_93645_, p_93646_, p_93648_, p_93649_);
            return true;
        }
        return false;
    }

    protected boolean clicked(double p_93681_, double p_93682_) {
        return this.active && this.visible && p_93681_ >= (double)this.x && p_93682_ >= (double)this.y && p_93681_ < (double)(this.x + this.width) && p_93682_ < (double)(this.y + this.height);
    }

    public boolean isHoveredOrFocused() {
        return this.isHovered || this.focused;
    }

    public boolean func_231049_c__(boolean p_93691_) {
        if (this.active && this.visible) {
            this.focused = !this.focused;
            this.onFocusedChanged(this.focused);
            return this.focused;
        }
        return false;
    }

    protected void onFocusedChanged(boolean p_93689_) {
    }

    public boolean func_231047_b_(double p_93672_, double p_93673_) {
        return this.active && this.visible && p_93672_ >= (double)this.x && p_93673_ >= (double)this.y && p_93672_ < (double)(this.x + this.width) && p_93673_ < (double)(this.y + this.height);
    }

    public void renderToolTip(MatrixStack p_93653_, int p_93654_, int p_93655_) {
    }

    public void playDownSound(SoundHandler p_93665_) {
        p_93665_.func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int p_93675_) {
        this.width = p_93675_;
    }

    public void setHeight(int value) {
        this.height = value;
    }

    public void setAlpha(float p_93651_) {
        this.alpha = p_93651_;
    }

    public void setMessage(ITextComponent p_93667_) {
        this.message = p_93667_;
    }

    public ITextComponent getMessage() {
        return this.message;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isActive() {
        return this.visible && this.active;
    }

    public void setFocused(boolean p_93693_) {
        this.focused = p_93693_;
    }

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.active ? 0xFFFFFF : 0xA0A0A0;
    }

    public void setFGColor(int color) {
        this.packedFGColor = color;
    }

    public void clearFGColor() {
        this.packedFGColor = -1;
    }

    public abstract void onPress();

    public void onClick(double p_93371_, double p_93372_) {
        this.onPress();
    }

    public boolean func_231046_a_(int p_93374_, int p_93375_, int p_93376_) {
        if (this.active && this.visible) {
            if (p_93374_ != 257 && p_93374_ != 32 && p_93374_ != 335) {
                return false;
            }
            this.playDownSound(Minecraft.func_71410_x().func_147118_V());
            this.onPress();
            return true;
        }
        return false;
    }
}

