/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.gui.slider;

import com.minecraftserverzone.weaponmaster.gui.DetailedSettingsScreen;
import com.minecraftserverzone.weaponmaster.gui.UniqueItemSettingScreen;
import com.minecraftserverzone.weaponmaster.gui.slider.NewAbstractSlider;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NewForgeSlider
extends NewAbstractSlider {
    public ITextComponent prefix;
    public ITextComponent suffix;
    public double minValue;
    public double maxValue;
    public double stepSize;
    public boolean drawString;
    public final DecimalFormat format;

    public NewForgeSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        this.visible = false;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = MathHelper.func_219806_b((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.updateMessage();
    }

    public NewForgeSlider(int x, int y, int width, int height, ITextComponent prefix, ITextComponent suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.value = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.updateMessage();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double dragX, double dragY) {
        super.onDrag(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
        this.setData();
    }

    public void setData() {
        if (Minecraft.func_71410_x().field_71462_r.getClass() == DetailedSettingsScreen.class) {
            DetailedSettingsScreen.setData();
        } else if (Minecraft.func_71410_x().field_71462_r.getClass() == UniqueItemSettingScreen.class) {
            UniqueItemSettingScreen.setData();
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.value + (double)(f / (float)(this.width - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    public void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.x + 4)) / (double)(this.width - 8));
    }

    public void setSliderValue(double value) {
        double oldValue = this.value;
        this.value = this.snapToNearest(value);
        if (!NewForgeSlider.equal(oldValue, this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    public double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return NewForgeSlider.clamp(value, 0.0, 1.0);
        }
        value = NewForgeSlider.lerp(NewForgeSlider.clamp(value, 0.0, 1.0), this.minValue, this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? NewForgeSlider.clamp(value, this.maxValue, this.minValue) : NewForgeSlider.clamp(value, this.minValue, this.maxValue);
        return NewForgeSlider.map(value, this.minValue, this.maxValue, 0.0, 1.0);
    }

    @Override
    public void updateMessage() {
        if (this.drawString) {
            this.setMessage((ITextComponent)new StringTextComponent("").func_230529_a_(this.prefix).func_240702_b_(this.getValueString()).func_230529_a_(this.suffix));
        } else {
            this.setMessage((ITextComponent)new StringTextComponent(""));
        }
    }

    @Override
    public void applyValue() {
    }

    public void setX(int p_265236_) {
        this.x = p_265236_;
    }

    public void setY(int p_265404_) {
        this.y = p_265404_;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

