/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.integration.jei;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IRegistryDelegate;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.integration.jei.ChiselRecipeCategory;
import team.chisel.common.integration.jei.ChiselRecipeRegistryPlugin;
import team.chisel.common.item.ItemChisel;
import team.chisel.repack.registrate.util.entry.ItemEntry;

@ParametersAreNonnullByDefault
@JeiPlugin
public class ChiselJEIPlugin
implements IModPlugin {
    private ChiselRecipeCategory category;
    private final ChiselRecipeRegistryPlugin plugin = new ChiselRecipeRegistryPlugin();
    private final Map<IRegistryDelegate<Item>, ChiselLangKeys> descriptions;

    public ChiselJEIPlugin() {
        this.descriptions = ImmutableMap.of((Object)((ItemChisel)ChiselItems.IRON_CHISEL.get()).delegate, (Object)((Object)ChiselLangKeys.JEI_DESC_CHISEL_IRON), (Object)((ItemChisel)ChiselItems.DIAMOND_CHISEL.get()).delegate, (Object)((Object)ChiselLangKeys.JEI_DESC_CHISEL_DIAMOND), (Object)((ItemChisel)ChiselItems.HITECH_CHISEL.get()).delegate, (Object)((Object)ChiselLangKeys.JEI_DESC_CHISEL_HITECH));
    }

    public void registerRecipes(IRecipeRegistration registry) {
        for (ItemEntry chisel : ChiselItems.CHISELS) {
            ItemStack stack = new ItemStack((IItemProvider)chisel.get());
            registry.addIngredientInfo((Object)stack, VanillaTypes.ITEM, new String[]{ChiselLangKeys.JEI_DESC_CHISEL_GENERIC.getComponent().func_150268_i(), "\n", this.descriptions.get(((ItemChisel)chisel.get()).delegate).getComponent().func_150268_i()});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (ItemEntry chisel : ChiselItems.CHISELS) {
            registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)chisel.get()), new ResourceLocation[]{this.category.getUid()});
        }
    }

    public void registerAdvanced(IAdvancedRegistration registry) {
        registry.addRecipeManagerPlugin((IRecipeManagerPlugin)this.plugin);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        this.category = new ChiselRecipeCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{this.category});
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("chisel", "chisel");
    }
}

