/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.client.gui.ButtonChiselMode;
import team.chisel.common.inventory.ChiselContainer;
import team.chisel.common.inventory.SlotChiselInput;
import team.chisel.common.item.PacketChiselMode;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class GuiChisel<T extends ChiselContainer>
extends ContainerScreen<T> {
    public PlayerEntity player;

    public GuiChisel(T container, PlayerInventory iinventory, ITextComponent displayName) {
        super(container, iinventory, displayName);
        this.player = iinventory.field_70458_d;
        this.field_146999_f = 252;
        this.field_147000_g = 202;
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        ((ChiselContainer)this.func_212873_a_()).func_75134_a(this.player);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        super.func_231044_a_(mouseX, mouseY, mouseButton);
        return false;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        int id = 0;
        Rectangle2d area = this.getModeButtonArea();
        int buttonsPerRow = area.func_199316_c() / 20;
        int padding = (area.func_199316_c() - buttonsPerRow * 20) / buttonsPerRow;
        IChiselMode currentMode = NBTUtil.getChiselMode(((ChiselContainer)this.func_212873_a_()).getChisel());
        for (IChiselMode mode : CarvingUtils.getModeRegistry().getAllModes()) {
            if (!((IChiselItem)((ChiselContainer)this.func_212873_a_()).getChisel().func_77973_b()).supportsMode(this.player, ((ChiselContainer)this.func_212873_a_()).getChisel(), mode)) continue;
            int x = area.func_199318_a() + padding / 2 + id % buttonsPerRow * (20 + padding);
            int y = area.func_199319_b() + id / buttonsPerRow * (20 + padding);
            ButtonChiselMode button = new ButtonChiselMode(x, y, mode, b -> {
                b.field_230693_o_ = false;
                IChiselMode m = ((ButtonChiselMode)b).getMode();
                NBTUtil.setChiselMode(((ChiselContainer)this.func_212873_a_()).getChisel(), m);
                Chisel.network.sendToServer((Object)new PacketChiselMode(((ChiselContainer)this.func_212873_a_()).getChiselSlot(), m));
                for (Widget other : this.field_230710_m_) {
                    if (other == b || !(other instanceof ButtonChiselMode)) continue;
                    other.field_230693_o_ = true;
                }
            });
            if (mode == currentMode) {
                button.field_230693_o_ = false;
            }
            this.func_230480_a_((Widget)button);
            ++id;
        }
    }

    protected Rectangle2d getModeButtonArea() {
        int down = 73;
        int padding = 7;
        return new Rectangle2d(this.field_147003_i + padding, this.field_147009_r + down + padding, 50, this.field_147000_g - down - padding * 2);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int j, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        List lines = this.field_230712_o_.func_238425_b_((ITextProperties)this.field_230704_d_, 40);
        int y = 60;
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        for (IReorderingProcessor s : lines) {
            this.field_230712_o_.func_238416_a_(s, (float)(32 - this.field_230712_o_.func_243245_a(s) / 2), (float)y, 0x404040, false, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
            y += 10;
        }
        irendertypebuffer$impl.func_228461_a_();
        this.drawButtonTooltips(matrixStack, j, i);
    }

    protected void drawButtonTooltips(MatrixStack matrixStack, int mx, int my) {
        for (Widget button : this.field_230710_m_) {
            if (!button.func_231047_b_((double)mx, (double)my) || !(button instanceof ButtonChiselMode)) continue;
            String unloc = ((ButtonChiselMode)button).getMode().getUnlocName();
            ArrayList ttLines = Lists.newArrayList((Object[])new ITextComponent[]{new TranslationTextComponent(unloc), new TranslationTextComponent(unloc + ".desc").func_240699_a_(TextFormatting.GRAY)});
            GuiUtils.drawHoveringText((MatrixStack)matrixStack, (List)ttLines, (int)(mx - this.field_147003_i), (int)(my - this.field_147009_r), (int)(this.field_230708_k_ - this.field_147003_i), (int)(this.field_230709_l_ - this.field_147009_r), (int)-1, (FontRenderer)this.field_230712_o_);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_230708_k_ - this.field_146999_f >> 1;
        int j = this.field_230709_l_ - this.field_147000_g >> 1;
        String texture = "chisel:textures/chisel2gui.png";
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation(texture));
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        Slot main = (Slot)((ChiselContainer)this.func_212873_a_()).field_75151_b.get(((ChiselContainer)this.func_212873_a_()).getInventoryChisel().size);
        if (main.func_75211_c().func_190926_b()) {
            GuiChisel.drawSlotOverlay(matrixStack, this, x + 14, y + 14, main, 0, this.field_147000_g, 60);
        }
    }

    protected boolean func_195362_a(Slot slotIn, double mouseX, double mouseY) {
        if (slotIn == ((ChiselContainer)this.field_147002_h).getInputSlot()) {
            return this.func_195359_a(slotIn.field_75223_e - 8, slotIn.field_75221_f - 8, 32, 32, mouseX, mouseY);
        }
        return super.func_195362_a(slotIn, mouseX, mouseY);
    }

    protected void func_238468_a_(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
        if (x1 == ((ChiselContainer)this.field_147002_h).getInputSlot().field_75223_e && y1 == ((ChiselContainer)this.field_147002_h).getInputSlot().field_75221_f) {
            super.func_238468_a_(matrixStack, x1 - 8, y1 - 8, x2 + 8, y2 + 8, colorFrom, colorTo);
        } else {
            super.func_238468_a_(matrixStack, x1, y1, x2, y2, colorFrom, colorTo);
        }
    }

    public void func_238746_a_(MatrixStack matrixStack, Slot slot) {
        if (slot instanceof SlotChiselInput) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(2.0f, 2.0f, 1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)2.0f, (float)2.0f, (float)1.0f);
            slot.field_75223_e -= 16;
            slot.field_75221_f -= 16;
            super.func_238746_a_(matrixStack, slot);
            slot.field_75223_e += 16;
            slot.field_75221_f += 16;
            matrixStack.func_227865_b_();
            RenderSystem.popMatrix();
        } else {
            super.func_238746_a_(matrixStack, slot);
        }
    }

    public static void drawSlotOverlay(MatrixStack matrixStack, ContainerScreen<?> gui, int x, int y, Slot slot, int u, int v, int padding) {
        gui.func_238474_b_(matrixStack, x + (slot.field_75223_e - (padding /= 2)), y + (slot.field_75221_f - padding), u, v, 18 + padding, 18 + padding);
    }
}

