/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.carving;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public interface ICarvingGroup {
    public ResourceLocation getId();

    public String getTranslationKey();

    default public TranslationTextComponent getDisplayName() {
        return new TranslationTextComponent(this.getTranslationKey());
    }

    default public ITag<Item> getItemTag() {
        ITag ret = ItemTags.func_199903_a().func_199910_a(this.getId());
        if (ret == null) {
            throw new IllegalStateException("Group " + this.getId() + " does not have an associated item tag");
        }
        return ret;
    }

    default public Optional<ITag<Block>> getBlockTag() {
        return Optional.ofNullable(BlockTags.func_199896_a().func_199910_a(this.getId()));
    }

    public SoundEvent getSound();
}

