/*
 * Decompiled with CFR 0.152.
 */
package team.chisel;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.chisel.Features;
import team.chisel.api.ChiselAPIProps;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.client.gui.PacketChiselButton;
import team.chisel.client.gui.PacketHitechSettings;
import team.chisel.client.gui.PreviewType;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.Reference;
import team.chisel.common.block.MessageAutochiselFX;
import team.chisel.common.block.MessageUpdateAutochiselSource;
import team.chisel.common.carving.CarvingVariationRegistry;
import team.chisel.common.carving.ChiselModeRegistry;
import team.chisel.common.init.ChiselItems;
import team.chisel.common.init.ChiselSounds;
import team.chisel.common.init.ChiselTabs;
import team.chisel.common.init.ChiselTileEntities;
import team.chisel.common.init.ChiselWorldGen;
import team.chisel.common.integration.imc.IMCHandler;
import team.chisel.common.item.ChiselController;
import team.chisel.common.item.ChiselMode;
import team.chisel.common.item.PacketChiselMode;
import team.chisel.common.util.PerChunkData;
import team.chisel.repack.registrate.Registrate;
import team.chisel.repack.registrate.providers.ProviderType;
import team.chisel.repack.registrate.util.NonNullLazyValue;

@Mod(value="chisel")
public class Chisel
implements Reference {
    public static final Logger logger = LogManager.getLogger((String)"Chisel");
    public static final boolean debug = false;
    public static final SimpleChannel network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("chisel", "main"), () -> "1", "1"::equals, "1"::equals);
    private static Map<String, Block> remaps;
    private static final NonNullLazyValue<Registrate> REGISTRATE;

    public Chisel() {
        CarvingUtils.chisel = new CarvingVariationRegistry();
        CarvingUtils.modes = ChiselModeRegistry.INSTANCE;
        ChiselMode.values();
        PreviewType.values();
        ChiselAPIProps.MOD_ID = "chisel";
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::setup);
        modBus.addListener(this::imcEnqueue);
        modBus.addListener(this::imcProcess);
        modBus.addGenericListener(Block.class, this::onMissingBlock);
        modBus.addGenericListener(Item.class, this::onMissingItem);
        ChiselSounds.init();
        ChiselItems.init();
        ChiselTileEntities.init();
        Features.init();
        ChiselLangKeys.init(Chisel.registrate());
        ChiselWorldGen.FEATURES.register(modBus);
        ChiselWorldGen.PLACEMENTS.register(modBus);
    }

    public static Registrate registrate() {
        return (Registrate)REGISTRATE.func_179281_c();
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ChiselController.class);
        MinecraftForge.EVENT_BUS.addListener(ChiselWorldGen::registerWorldGen);
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
        remaps = ImmutableMap.builder().build();
    }

    private static void addCompactorPressRecipe(int energy, ItemStack input, ItemStack output) {
        CompoundNBT message = new CompoundNBT();
        message.func_74768_a("energy", energy);
        message.func_218657_a("input", (INBT)new CompoundNBT());
        message.func_218657_a("output", (INBT)new CompoundNBT());
        input.func_77955_b(message.func_74775_l("input"));
        output.func_77955_b(message.func_74775_l("output"));
        InterModComms.sendTo((String)"thermalexpansion", (String)"addcompactorpressrecipe", () -> message);
    }

    private void imcProcess(InterModProcessEvent event) {
        event.getIMCStream().forEach(IMCHandler.INSTANCE::handleMessage);
        IMCHandler.INSTANCE.imcCounts.object2IntEntrySet().forEach(e -> logger.info("Received {} IMC messages from mod {}.", e.getKey(), (Object)e.getIntValue()));
        IMCHandler.INSTANCE.imcCounts.clear();
    }

    public static void debug(String message) {
    }

    public static void debug(float[] array) {
    }

    private void onMissingBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            Optional.ofNullable(remaps.get(mapping.key.func_110623_a())).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
        }
    }

    private void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings()) {
            Optional.ofNullable(remaps.get(mapping.key.func_110623_a())).map(Block::func_199767_j).ifPresent(arg_0 -> ((RegistryEvent.MissingMappings.Mapping)mapping).remap(arg_0));
        }
    }

    static {
        network.registerMessage(0, PacketChiselButton.class, PacketChiselButton::encode, PacketChiselButton::decode, PacketChiselButton::handle);
        network.registerMessage(1, PacketHitechSettings.class, PacketHitechSettings::encode, PacketHitechSettings::decode, PacketHitechSettings::handle);
        network.registerMessage(2, PerChunkData.MessageChunkData.class, PerChunkData.MessageChunkData::encode, PerChunkData.MessageChunkData::decode, PerChunkData.MessageChunkData::handle);
        network.registerMessage(3, PacketChiselMode.class, PacketChiselMode::encode, PacketChiselMode::decode, PacketChiselMode::handle);
        network.registerMessage(4, MessageUpdateAutochiselSource.class, MessageUpdateAutochiselSource::encode, MessageUpdateAutochiselSource::decode, MessageUpdateAutochiselSource::handle);
        network.registerMessage(5, MessageAutochiselFX.class, MessageAutochiselFX::encode, MessageAutochiselFX::decode, MessageAutochiselFX::handle);
        remaps = ImmutableMap.of();
        REGISTRATE = new NonNullLazyValue<Registrate>(() -> {
            Registrate ret = (Registrate)Registrate.create("chisel").itemGroup(() -> ChiselTabs.base);
            ret.addDataGenerator(ProviderType.LANG, prov -> prov.add(ChiselTabs.base, "Chisel"));
            return ret;
        });
    }
}

