/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item.crafting;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.crafting.CopyColorRecipe;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.Blender;
import me.paulf.fairylights.util.OreDictUtils;
import me.paulf.fairylights.util.Utils;
import me.paulf.fairylights.util.crafting.GenericRecipe;
import me.paulf.fairylights.util.crafting.GenericRecipeBuilder;
import me.paulf.fairylights.util.crafting.ingredient.BasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.BasicRegularIngredient;
import me.paulf.fairylights.util.crafting.ingredient.InertBasicAuxiliaryIngredient;
import me.paulf.fairylights.util.crafting.ingredient.LazyTagIngredient;
import me.paulf.fairylights.util.crafting.ingredient.RegularIngredient;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="fairylights")
public final class FLCraftingRecipes {
    public static final DeferredRegister<IRecipeSerializer<?>> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"fairylights");
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> HANGING_LIGHTS = REG.register("crafting_special_hanging_lights", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createHangingLights));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> HANGING_LIGHTS_AUGMENTATION = REG.register("crafting_special_hanging_lights_augmentation", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createHangingLightsAugmentation));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> TINSEL_GARLAND = REG.register("crafting_special_tinsel_garland", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createTinselGarland));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> PENNANT_BUNTING = REG.register("crafting_special_pennant_bunting", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createPennantBunting));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> PENNANT_BUNTING_AUGMENTATION = REG.register("crafting_special_pennant_bunting_augmentation", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createPennantBuntingAugmentation));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> TRIANGLE_PENNANT = REG.register("crafting_special_triangle_pennant", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createTrianglePennant));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SPEARHEAD_PENNANT = REG.register("crafting_special_spearhead_pennant", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSpearheadPennant));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SWALLOWTAIL_PENNANT = REG.register("crafting_special_swallowtail_pennant", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSwallowtailPennant));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SQUARE_PENNANT = REG.register("crafting_special_square_pennant", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSquarePennant));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> FAIRY_LIGHT = REG.register("crafting_special_fairy_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createFairyLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> PAPER_LANTERN = REG.register("crafting_special_paper_lantern", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createPaperLantern));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> ORB_LANTERN = REG.register("crafting_special_orb_lantern", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createOrbLantern));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> FLOWER_LIGHT = REG.register("crafting_special_flower_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createFlowerLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> CANDLE_LANTERN_LIGHT = REG.register("crafting_special_candle_lantern_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createCandleLanternLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> OIL_LANTERN_LIGHT = REG.register("crafting_special_oil_lantern_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createOilLanternLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> JACK_O_LANTERN = REG.register("crafting_special_jack_o_lantern", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createJackOLantern));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SKULL_LIGHT = REG.register("crafting_special_skull_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSkullLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> GHOST_LIGHT = REG.register("crafting_special_ghost_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createGhostLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SPIDER_LIGHT = REG.register("crafting_special_spider_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSpiderLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> WITCH_LIGHT = REG.register("crafting_special_witch_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createWitchLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> SNOWFLAKE_LIGHT = REG.register("crafting_special_snowflake_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createSnowflakeLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> HEART_LIGHT = REG.register("crafting_special_heart_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createHeartLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> MOON_LIGHT = REG.register("crafting_special_moon_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createMoonLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> STAR_LIGHT = REG.register("crafting_special_star_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createStarLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> ICICLE_LIGHTS = REG.register("crafting_special_icicle_lights", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createIcicleLights));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> METEOR_LIGHT = REG.register("crafting_special_meteor_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createMeteorLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> LIGHT_TWINKLE = REG.register("crafting_special_light_twinkle", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createLightTwinkle));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> COLOR_CHANGING_LIGHT = REG.register("crafting_special_color_changing_light", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createColorChangingLight));
    public static final RegistryObject<IRecipeSerializer<GenericRecipe>> EDIT_COLOR = REG.register("crafting_special_edit_color", FLCraftingRecipes.makeSerializer(FLCraftingRecipes::createDyeColor));
    public static final RegistryObject<IRecipeSerializer<CopyColorRecipe>> COPY_COLOR = REG.register("crafting_special_copy_color", FLCraftingRecipes.makeSerializer(CopyColorRecipe::new));
    public static final ITag.INamedTag<Item> LIGHTS = ItemTags.func_199901_a((String)"fairylights:lights");
    public static final ITag.INamedTag<Item> TWINKLING_LIGHTS = ItemTags.func_199901_a((String)"fairylights:twinkling_lights");
    public static final ITag.INamedTag<Item> PENNANTS = ItemTags.func_199901_a((String)"fairylights:pennants");
    public static final ITag.INamedTag<Item> DYEABLE = ItemTags.func_199901_a((String)"fairylights:dyeable");
    public static final ITag.INamedTag<Item> DYEABLE_LIGHTS = ItemTags.func_199901_a((String)"fairylights:dyeable_lights");
    public static final RegularIngredient DYE_SUBTYPE_INGREDIENT = new BasicRegularIngredient(LazyTagIngredient.of((ITag<Item>)Tags.Items.DYES)){

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            return DyeableItem.getDyeColor(output).map(dye -> ImmutableList.of(OreDictUtils.getDyes(dye))).orElse(ImmutableList.of());
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public void matched(ItemStack ingredient, CompoundNBT nbt) {
            DyeableItem.setColor(nbt, OreDictUtils.getDyeColor(ingredient));
        }
    };

    private FLCraftingRecipes() {
    }

    private static <T extends ICraftingRecipe> Supplier<IRecipeSerializer<T>> makeSerializer(Function<ResourceLocation, T> factory) {
        return () -> new SpecialRecipeSerializer(factory);
    }

    private static GenericRecipe createDyeColor(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)EDIT_COLOR).withShape("I").withIngredient('I', (ITag<Item>)DYEABLE).withOutput('I').withAuxiliaryIngredient(new BasicAuxiliaryIngredient<Blender>((Ingredient)LazyTagIngredient.of((ITag<Item>)Tags.Items.DYES), true, 8){

            @Override
            public Blender accumulator() {
                return new Blender();
            }

            @Override
            public void consume(Blender data, ItemStack ingredient) {
                data.add(DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient)));
            }

            @Override
            public boolean finish(Blender data, CompoundNBT nbt) {
                DyeableItem.setColor(nbt, data.blend());
                return false;
            }
        }).build();
    }

    private static GenericRecipe createLightTwinkle(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)LIGHT_TWINKLE).withShape("L").withIngredient('L', (ITag<Item>)TWINKLING_LIGHTS).withOutput('L').withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((ITag<Item>)Tags.Items.DUSTS_GLOWSTONE), true, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return FLCraftingRecipes.useInputsForTagBool(output, "twinkle", true) ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(CompoundNBT nbt) {
                nbt.func_74757_a("twinkle", true);
            }

            @Override
            public void absent(CompoundNBT nbt) {
                nbt.func_74757_a("twinkle", false);
            }

            @Override
            public void addTooltip(List<ITextComponent> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.twinkling_lights.glowstone"));
            }
        }).build();
    }

    private static GenericRecipe createColorChangingLight(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)COLOR_CHANGING_LIGHT).withShape("IG").withIngredient('I', (ITag<Item>)DYEABLE_LIGHTS).withOutput('I').withIngredient('G', (ITag<Item>)Tags.Items.NUGGETS_GOLD).withAuxiliaryIngredient(new BasicAuxiliaryIngredient<ListNBT>((Ingredient)LazyTagIngredient.of((ITag<Item>)Tags.Items.DYES), true, 8){

            @Override
            public ListNBT accumulator() {
                return new ListNBT();
            }

            @Override
            public void consume(ListNBT data, ItemStack ingredient) {
                data.add((Object)IntNBT.func_229692_a_((int)DyeableItem.getColor(OreDictUtils.getDyeColor(ingredient))));
            }

            @Override
            public boolean finish(ListNBT data, CompoundNBT nbt) {
                if (!data.isEmpty()) {
                    if (nbt.func_150297_b("color", 3)) {
                        data.add(0, (INBT)IntNBT.func_229692_a_((int)nbt.func_74762_e("color")));
                        nbt.func_82580_o("color");
                    }
                    nbt.func_218657_a("colors", (INBT)data);
                }
                return false;
            }
        }).build();
    }

    private static GenericRecipe createHangingLights(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)HANGING_LIGHTS, (Item)FLItems.HANGING_LIGHTS.get()).withShape("I-I").withIngredient('I', (ITag<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (ITag<Item>)Tags.Items.STRING).withAuxiliaryIngredient(new LightIngredient(true)).withAuxiliaryIngredient(new InertBasicAuxiliaryIngredient(LazyTagIngredient.of((ITag<Item>)Tags.Items.DYES_WHITE), false, 1){

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                CompoundNBT tag = output.func_77978_p();
                return tag != null && HangingLightsConnectionItem.getString(tag) == StringTypes.WHITE_STRING.get() ? super.getInput(output) : ImmutableList.of();
            }

            @Override
            public void present(CompoundNBT nbt) {
                HangingLightsConnectionItem.setString(nbt, (StringType)StringTypes.WHITE_STRING.get());
            }

            @Override
            public void absent(CompoundNBT nbt) {
                HangingLightsConnectionItem.setString(nbt, (StringType)StringTypes.BLACK_STRING.get());
            }

            @Override
            public void addTooltip(List<ITextComponent> tooltip) {
                super.addTooltip(tooltip);
                tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.string"));
            }
        }).build();
    }

    private static boolean useInputsForTagBool(ItemStack output, String key, boolean value) {
        CompoundNBT compound = output.func_77978_p();
        return compound != null && compound.func_74767_n(key) == value;
    }

    private static GenericRecipe createHangingLightsAugmentation(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)HANGING_LIGHTS_AUGMENTATION, (Item)FLItems.HANGING_LIGHTS.get()).withShape("F").withIngredient('F', new BasicRegularIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)FLItems.HANGING_LIGHTS.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.func_193365_a()).map(ItemStack::func_77946_l).flatMap(stack -> {
                    stack.func_77982_d(new CompoundNBT());
                    return FLCraftingRecipes.makeHangingLightsExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                ItemStack stack = output.func_77946_l();
                CompoundNBT compound = stack.func_77978_p();
                if (compound == null) {
                    return ImmutableList.of();
                }
                stack.func_190920_e(1);
                return ImmutableList.of((Object)ImmutableList.of((Object)stack));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundNBT nbt) {
                CompoundNBT compound = ingredient.func_77978_p();
                if (compound != null) {
                    nbt.func_197643_a(compound);
                }
            }
        }).withAuxiliaryIngredient(new LightIngredient(true){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return ImmutableList.of();
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                return ImmutableList.of();
            }
        }).build();
    }

    private static ImmutableList<ItemStack> makeHangingLightsExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.MAGENTA, DyeColor.CYAN, DyeColor.WHITE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.CYAN, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PINK, DyeColor.CYAN, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.LIGHT_GRAY, DyeColor.PURPLE, DyeColor.LIGHT_GRAY, DyeColor.GREEN), (Object)FLCraftingRecipes.makeHangingLights(stack, DyeColor.CYAN, DyeColor.YELLOW, DyeColor.CYAN, DyeColor.PURPLE));
    }

    public static ItemStack makeHangingLights(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.func_77946_l();
        CompoundNBT compound = stack.func_77978_p();
        ListNBT lights = new ListNBT();
        for (DyeColor color : colors) {
            lights.add((Object)DyeableItem.setColor(new ItemStack((IItemProvider)FLItems.FAIRY_LIGHT.get()), color).func_77955_b(new CompoundNBT()));
        }
        if (compound == null) {
            compound = new CompoundNBT();
            stack.func_77982_d(compound);
        }
        compound.func_218657_a("pattern", (INBT)lights);
        HangingLightsConnectionItem.setString(compound, (StringType)StringTypes.BLACK_STRING.get());
        return stack;
    }

    private static GenericRecipe createTinselGarland(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)TINSEL_GARLAND, (Item)FLItems.TINSEL.get()).withShape(" P ", "I-I", " D ").withIngredient('P', Items.field_151121_aF).withIngredient('I', (ITag<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (ITag<Item>)Tags.Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createPennantBunting(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)PENNANT_BUNTING, (Item)FLItems.PENNANT_BUNTING.get()).withShape("I-I").withIngredient('I', (ITag<Item>)Tags.Items.INGOTS_IRON).withIngredient('-', (ITag<Item>)Tags.Items.STRING).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static GenericRecipe createPennantBuntingAugmentation(ResourceLocation name) {
        return new GenericRecipeBuilder(name, (Supplier<? extends IRecipeSerializer<GenericRecipe>>)PENNANT_BUNTING_AUGMENTATION, (Item)FLItems.PENNANT_BUNTING.get()).withShape("B").withIngredient('B', new BasicRegularIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)FLItems.PENNANT_BUNTING.get()})){

            @Override
            public ImmutableList<ItemStack> getInputs() {
                return (ImmutableList)Arrays.stream(this.ingredient.func_193365_a()).map(ItemStack::func_77946_l).flatMap(stack -> {
                    stack.func_77982_d(new CompoundNBT());
                    return FLCraftingRecipes.makePennantExamples(stack).stream();
                }).collect(ImmutableList.toImmutableList());
            }

            @Override
            public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
                CompoundNBT compound = output.func_77978_p();
                if (compound == null) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)FLCraftingRecipes.makePennantExamples(output));
            }

            @Override
            public void matched(ItemStack ingredient, CompoundNBT nbt) {
                CompoundNBT compound = ingredient.func_77978_p();
                if (compound != null) {
                    nbt.func_197643_a(compound);
                }
            }
        }).withAuxiliaryIngredient(new PennantIngredient()).build();
    }

    private static ImmutableList<ItemStack> makePennantExamples(ItemStack stack) {
        return ImmutableList.of((Object)FLCraftingRecipes.makePennant(stack, DyeColor.BLUE, DyeColor.YELLOW, DyeColor.RED), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.PINK, DyeColor.LIGHT_BLUE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.ORANGE, DyeColor.WHITE), (Object)FLCraftingRecipes.makePennant(stack, DyeColor.LIME, DyeColor.YELLOW));
    }

    public static ItemStack makePennant(ItemStack base, DyeColor ... colors) {
        ItemStack stack = base.func_77946_l();
        CompoundNBT compound = stack.func_77978_p();
        ListNBT pennants = new ListNBT();
        for (DyeColor color : colors) {
            ItemStack pennant = new ItemStack((IItemProvider)FLItems.TRIANGLE_PENNANT.get());
            DyeableItem.setColor(pennant, color);
            pennants.add((Object)pennant.func_77955_b(new CompoundNBT()));
        }
        if (compound == null) {
            compound = new CompoundNBT();
            stack.func_77982_d(compound);
        }
        compound.func_218657_a("pattern", (INBT)pennants);
        compound.func_218657_a("text", (INBT)StyledString.serialize(new StyledString()));
        return stack;
    }

    private static GenericRecipe createPennant(ResourceLocation name, Supplier<IRecipeSerializer<GenericRecipe>> serializer, Item item, String pattern) {
        return new GenericRecipeBuilder(name, serializer, item).withShape("- -", "PDP", pattern).withIngredient('P', Items.field_151121_aF).withIngredient('-', (ITag<Item>)Tags.Items.STRING).withIngredient('D', DYE_SUBTYPE_INGREDIENT).build();
    }

    private static GenericRecipe createTrianglePennant(ResourceLocation name) {
        return FLCraftingRecipes.createPennant(name, TRIANGLE_PENNANT, (Item)FLItems.TRIANGLE_PENNANT.get(), " P ");
    }

    private static GenericRecipe createSpearheadPennant(ResourceLocation name) {
        return FLCraftingRecipes.createPennant(name, SPEARHEAD_PENNANT, (Item)FLItems.SPEARHEAD_PENNANT.get(), " PP");
    }

    private static GenericRecipe createSwallowtailPennant(ResourceLocation name) {
        return FLCraftingRecipes.createPennant(name, SWALLOWTAIL_PENNANT, (Item)FLItems.SWALLOWTAIL_PENNANT.get(), "P P");
    }

    private static GenericRecipe createSquarePennant(ResourceLocation name) {
        return FLCraftingRecipes.createPennant(name, SQUARE_PENNANT, (Item)FLItems.SQUARE_PENNANT.get(), "PPP");
    }

    private static GenericRecipe createFairyLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, FAIRY_LIGHT, FLItems.FAIRY_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS));
    }

    private static GenericRecipe createPaperLantern(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, PAPER_LANTERN, FLItems.PAPER_LANTERN, b -> b.withShape(" I ", "PDP", "PPP").withIngredient('P', Items.field_151121_aF));
    }

    private static GenericRecipe createOrbLantern(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, ORB_LANTERN, FLItems.ORB_LANTERN, b -> b.withShape(" I ", "SDS", " W ").withIngredient('S', (ITag<Item>)Tags.Items.STRING).withIngredient('W', Items.field_221603_aE));
    }

    private static GenericRecipe createFlowerLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, FLOWER_LIGHT, FLItems.FLOWER_LIGHT, b -> b.withShape(" I ", "RDB", " Y ").withIngredient('R', Items.field_221620_aV).withIngredient('Y', Items.field_221619_aU).withIngredient('B', Items.field_221621_aW));
    }

    private static GenericRecipe createCandleLanternLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, CANDLE_LANTERN_LIGHT, FLItems.CANDLE_LANTERN_LIGHT, b -> b.withShape(" I ", "GDG", "IGI").withIngredient('G', (ITag<Item>)Tags.Items.NUGGETS_GOLD));
    }

    private static GenericRecipe createOilLanternLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, OIL_LANTERN_LIGHT, FLItems.OIL_LANTERN_LIGHT, b -> b.withShape(" I ", "SDS", "IGI").withIngredient('S', Items.field_151055_y).withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS));
    }

    private static GenericRecipe createJackOLantern(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, JACK_O_LANTERN, FLItems.JACK_O_LANTERN, b -> b.withShape(" I ", "SDS", "GPG").withIngredient('S', (ITag<Item>)ItemTags.field_202899_i).withIngredient('G', Items.field_221657_bQ).withIngredient('P', Items.field_221697_cK));
    }

    private static GenericRecipe createSkullLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, SKULL_LIGHT, FLItems.SKULL_LIGHT, b -> b.withShape(" I ", "IDI", " B ").withIngredient('B', (ITag<Item>)Tags.Items.BONES));
    }

    private static GenericRecipe createGhostLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, GHOST_LIGHT, FLItems.GHOST_LIGHT, b -> b.withShape(" I ", "PDP", "IGI").withIngredient('P', Items.field_151121_aF).withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_WHITE));
    }

    private static GenericRecipe createSpiderLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, SPIDER_LIGHT, FLItems.SPIDER_LIGHT, b -> b.withShape(" I ", "WDW", "SES").withIngredient('W', Items.field_221672_ax).withIngredient('S', (ITag<Item>)Tags.Items.STRING).withIngredient('E', Items.field_151070_bp));
    }

    private static GenericRecipe createWitchLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, WITCH_LIGHT, FLItems.WITCH_LIGHT, b -> b.withShape(" I ", "BDW", " S ").withIngredient('B', Items.field_151069_bo).withIngredient('W', Items.field_151015_O).withIngredient('S', Items.field_151055_y));
    }

    private static GenericRecipe createSnowflakeLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, SNOWFLAKE_LIGHT, FLItems.SNOWFLAKE_LIGHT, b -> b.withShape(" I ", "SDS", " G ").withIngredient('S', Items.field_151126_ay).withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_WHITE));
    }

    private static GenericRecipe createHeartLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, HEART_LIGHT, FLItems.HEART_LIGHT, b -> b.withShape(" I ", "IDI", " G ").withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_RED));
    }

    private static GenericRecipe createMoonLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, MOON_LIGHT, FLItems.MOON_LIGHT, b -> b.withShape(" I ", "GDG", " C ").withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_WHITE).withIngredient('C', Items.field_151113_aN));
    }

    private static GenericRecipe createStarLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, STAR_LIGHT, FLItems.STAR_LIGHT, b -> b.withShape(" I ", "PDP", " G ").withIngredient('P', (ITag<Item>)Tags.Items.GLASS_PANES_WHITE).withIngredient('G', (ITag<Item>)Tags.Items.NUGGETS_GOLD));
    }

    private static GenericRecipe createIcicleLights(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, ICICLE_LIGHTS, FLItems.ICICLE_LIGHTS, b -> b.withShape(" I ", "GDG", " B ").withIngredient('G', (ITag<Item>)Tags.Items.GLASS_PANES_COLORLESS).withIngredient('B', Items.field_151131_as));
    }

    private static GenericRecipe createMeteorLight(ResourceLocation name) {
        return FLCraftingRecipes.createLight(name, METEOR_LIGHT, FLItems.METEOR_LIGHT, b -> b.withShape(" I ", "GDG", "IPI").withIngredient('G', (ITag<Item>)Tags.Items.DUSTS_GLOWSTONE).withIngredient('P', Items.field_151121_aF));
    }

    private static GenericRecipe createLight(ResourceLocation name, Supplier<? extends IRecipeSerializer<GenericRecipe>> serializer, Supplier<? extends Item> variant, UnaryOperator<GenericRecipeBuilder> recipe) {
        return ((GenericRecipeBuilder)recipe.apply(new GenericRecipeBuilder(name, serializer))).withIngredient('I', (ITag<Item>)Tags.Items.INGOTS_IRON).withIngredient('D', DYE_SUBTYPE_INGREDIENT).withOutput(variant.get(), 4).build();
    }

    private static class PennantIngredient
    extends BasicAuxiliaryIngredient<ListNBT> {
        private PennantIngredient() {
            super(LazyTagIngredient.of(PENNANTS), true, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            CompoundNBT compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            ListNBT pattern = compound.func_150295_c("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder pennants = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                pennants.add((Object)ImmutableList.of((Object)ItemStack.func_199557_a((CompoundNBT)pattern.func_150305_b(i))));
            }
            return pennants.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListNBT accumulator() {
            return new ListNBT();
        }

        @Override
        public void consume(ListNBT patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.func_77955_b(new CompoundNBT()));
        }

        @Override
        public boolean finish(ListNBT pattern, CompoundNBT nbt) {
            if (pattern.size() > 0) {
                nbt.func_218657_a("pattern", (INBT)pattern);
                nbt.func_218657_a("text", (INBT)StyledString.serialize(new StyledString()));
            }
            return false;
        }

        @Override
        public void addTooltip(List<ITextComponent> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.pennantBunting.pennant"));
        }
    }

    private static class LightIngredient
    extends BasicAuxiliaryIngredient<ListNBT> {
        private LightIngredient(boolean isRequired) {
            super(LazyTagIngredient.of(LIGHTS), isRequired, 8);
        }

        @Override
        public ImmutableList<ImmutableList<ItemStack>> getInput(ItemStack output) {
            CompoundNBT compound = output.func_77978_p();
            if (compound == null) {
                return ImmutableList.of();
            }
            ListNBT pattern = compound.func_150295_c("pattern", 10);
            if (pattern.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lights = ImmutableList.builder();
            for (int i = 0; i < pattern.size(); ++i) {
                lights.add((Object)ImmutableList.of((Object)ItemStack.func_199557_a((CompoundNBT)pattern.func_150305_b(i))));
            }
            return lights.build();
        }

        @Override
        public boolean dictatesOutputType() {
            return true;
        }

        @Override
        public ListNBT accumulator() {
            return new ListNBT();
        }

        @Override
        public void consume(ListNBT patternList, ItemStack ingredient) {
            patternList.add((Object)ingredient.func_77955_b(new CompoundNBT()));
        }

        @Override
        public boolean finish(ListNBT pattern, CompoundNBT nbt) {
            if (pattern.size() > 0) {
                nbt.func_218657_a("pattern", (INBT)pattern);
            }
            return false;
        }

        @Override
        public void addTooltip(List<ITextComponent> tooltip) {
            tooltip.add(Utils.formatRecipeTooltip("recipe.fairylights.hangingLights.light"));
        }
    }
}

