/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.HangingFeatureConnection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.Pennant;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.OreDictUtils;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;

public final class PennantBuntingConnection
extends HangingFeatureConnection<Pennant>
implements Lettered {
    private List<ItemStack> pattern = new ArrayList<ItemStack>();
    private StyledString text = new StyledString();

    public PennantBuntingConnection(ConnectionType<? extends PennantBuntingConnection> type, World world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
    }

    @Override
    public float getRadius() {
        return 0.045f;
    }

    @Override
    public void processClientAction(PlayerEntity player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public boolean interact(PlayerEntity player, Vector3d hit, FeatureType featureType, int feature, ItemStack heldStack, Hand hand) {
        int index;
        ItemStack pennant;
        if (featureType == FEATURE && OreDictUtils.isDye(heldStack) && !ItemStack.func_77989_b((ItemStack)(pennant = this.pattern.get(index = feature % this.pattern.size())), (ItemStack)heldStack)) {
            ItemStack placed = heldStack.func_77979_a(1);
            this.pattern.set(index, placed);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)pennant);
            this.computeCatenary();
            heldStack.func_190918_g(1);
            this.world.func_184148_a(null, hit.field_72450_a, hit.field_72448_b, hit.field_72449_c, (SoundEvent)FLSounds.FEATURE_COLOR_CHANGE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        return super.interact(player, hit, featureType, feature, heldStack, hand);
    }

    @Override
    protected void onUpdate() {
        super.onUpdate();
        for (Pennant light : (Pennant[])this.features) {
            light.tick(this.world);
        }
    }

    protected Pennant[] createFeatures(int length) {
        return new Pennant[length];
    }

    @Override
    protected Pennant createFeature(int index, Vector3d point, float yaw, float pitch) {
        ItemStack data = this.pattern.isEmpty() ? ItemStack.field_190927_a : this.pattern.get(index % this.pattern.size());
        return new Pennant(index, point, yaw, pitch, DyeableItem.getColor(data), data.func_77973_b());
    }

    @Override
    protected float getFeatureSpacing() {
        return 0.6875f;
    }

    @Override
    public boolean isSupportedText(StyledString text) {
        return text.length() <= ((Pennant[])this.features).length && Lettered.super.isSupportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        this.computeCatenary();
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createTextGUI() {
        return new EditLetteredConnectionScreen<PennantBuntingConnection>(this);
    }

    @Override
    public CompoundNBT serializeLogic() {
        CompoundNBT compound = super.serializeLogic();
        ListNBT patternList = new ListNBT();
        for (ItemStack entry : this.pattern) {
            patternList.add((Object)entry.func_77955_b(new CompoundNBT()));
        }
        compound.func_218657_a("pattern", (INBT)patternList);
        compound.func_218657_a("text", (INBT)StyledString.serialize(this.text));
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundNBT compound) {
        super.deserializeLogic(compound);
        this.pattern = new ArrayList<ItemStack>();
        ListNBT patternList = compound.func_150295_c("pattern", 10);
        for (int i = 0; i < patternList.size(); ++i) {
            this.pattern.add(ItemStack.func_199557_a((CompoundNBT)patternList.func_150305_b(i)));
        }
        this.text = StyledString.deserialize(compound.func_74775_l("text"));
    }
}

