/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Function;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.gui.EditLetteredConnectionScreen;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.connection.SymbolSet;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.Letter;
import me.paulf.fairylights.server.net.clientbound.OpenEditLetteredConnectionScreenMessage;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public final class LetterBuntingConnection
extends Connection
implements Lettered {
    public static final SymbolSet SYMBOLS = new SymbolSet.Builder(7, "0-9, A-Z, &, !, ?").add(" 0123456789ABCDEFGHJKLMNOPQRSTUVWXYZ&?", 6).add("I", 4).add("!", 2).build();
    private static final float TRACKING = 0.0625f;
    private static final StylingPresence SUPPORTED_STYLING = new StylingPresence(true, false, false, false, false, false);
    private StyledString text;
    private Letter[] letters = new Letter[0];

    public LetterBuntingConnection(ConnectionType<? extends LetterBuntingConnection> type, World world, Fastener<?> fastener, UUID uuid) {
        super(type, world, fastener, uuid);
        this.text = new StyledString();
    }

    @Override
    public float getRadius() {
        return 0.028125f;
    }

    public Letter[] getLetters() {
        return this.letters;
    }

    @Override
    public void processClientAction(PlayerEntity player, PlayerAction action, Intersection intersection) {
        if (this.openTextGui(player, action, intersection)) {
            super.processClientAction(player, action, intersection);
        }
    }

    @Override
    public void onConnect(World world, PlayerEntity user, ItemStack heldStack) {
        if (this.text.isEmpty()) {
            FairyLights.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)user), new OpenEditLetteredConnectionScreenMessage<LetterBuntingConnection>(this));
        }
    }

    @Override
    protected void onUpdate() {
        for (Letter letter : this.letters) {
            letter.tick(this.world);
        }
    }

    @Override
    protected void onCalculateCatenary(boolean relocated) {
        this.updateLetters();
    }

    private void updateLetters() {
        if (this.text.isEmpty()) {
            this.letters = new Letter[0];
        } else {
            Catenary catenary = this.getCatenary();
            float textWidth = 0.0f;
            int textLen = 0;
            float[] pointOffsets = new float[this.text.length()];
            float catLength = catenary.getLength();
            for (int i = 0; i < this.text.length(); ++i) {
                float w = SYMBOLS.getWidth(this.text.charAt(i));
                pointOffsets[i] = textWidth + w / 2.0f;
                if ((textWidth += w + 0.0625f) > catLength) break;
                ++textLen;
            }
            float offset = catLength / 2.0f - textWidth / 2.0f;
            int i = 0;
            while (i < textLen) {
                int n = i++;
                pointOffsets[n] = pointOffsets[n] + offset;
            }
            int pointIdx = 0;
            Letter[] prevLetters = this.letters;
            ArrayList<Letter> letters = new ArrayList<Letter>(this.text.length());
            Catenary.SegmentIterator it = catenary.iterator();
            float distance = 0.0f;
            while (it.next()) {
                float pointOffset;
                float length = it.getLength();
                for (int n = pointIdx; n < textLen && (pointOffset = pointOffsets[n]) < distance + length; ++n) {
                    Letter letter;
                    float t = (pointOffset - distance) / length;
                    Vector3d point = new Vector3d((double)it.getX(t), (double)it.getY(t), (double)it.getZ(t));
                    if (prevLetters != null && pointIdx < prevLetters.length) {
                        letter = prevLetters[pointIdx];
                        letter.set(point, it.getYaw(), it.getPitch());
                        letter.set(this.text.charAt(pointIdx), this.text.styleAt(pointIdx));
                    } else {
                        letter = new Letter(pointIdx, point, it.getYaw(), it.getPitch(), SYMBOLS, this.text.charAt(pointIdx), this.text.styleAt(pointIdx));
                    }
                    letters.add(letter);
                    ++pointIdx;
                }
                if (pointIdx == textLen) break;
                distance += length;
            }
            this.letters = letters.toArray(new Letter[0]);
        }
    }

    @Override
    public StylingPresence getSupportedStyling() {
        return SUPPORTED_STYLING;
    }

    @Override
    public boolean isSupportedCharacter(int chr) {
        return SYMBOLS.contains(chr);
    }

    @Override
    public boolean isSupportedText(StyledString text) {
        float len = 0.0f;
        float available = this.getCatenary().getLength();
        for (int i = 0; i < text.length(); ++i) {
            float w = SYMBOLS.getWidth(text.charAt(i));
            if ((len += w + 0.0625f) > available) {
                return false;
            }
            if (text.styleAt(i).isPlain()) continue;
            return false;
        }
        return Lettered.super.isSupportedText(text);
    }

    @Override
    public void setText(StyledString text) {
        this.text = text;
        this.computeCatenary();
    }

    @Override
    public StyledString getText() {
        return this.text;
    }

    @Override
    public Function<String, String> getInputTransformer() {
        return str -> Normalizer.normalize(str, Normalizer.Form.NFKD).replaceAll("[\\p{Mn}\\p{Sk}]", "").toUpperCase(Locale.ROOT);
    }

    @Override
    public String getAllowedDescription() {
        return SYMBOLS.getDescription();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Screen createTextGUI() {
        return new EditLetteredConnectionScreen<LetterBuntingConnection>(this);
    }

    @Override
    public CompoundNBT serializeLogic() {
        CompoundNBT compound = super.serializeLogic();
        compound.func_218657_a("text", (INBT)StyledString.serialize(this.text));
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundNBT compound) {
        super.deserializeLogic(compound);
        this.text = StyledString.deserialize(compound.func_74775_l("text"));
    }
}

