/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block.entity;

import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.util.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LightBlockEntity
extends TileEntity {
    private Light<?> light = new Light<StandardLightBehavior>(0, Vector3d.field_186680_a, 0.0f, 0.0f, ItemStack.field_190927_a, SimpleLightVariant.FAIRY_LIGHT, 0.0f);
    private boolean on = true;

    public LightBlockEntity() {
        super((TileEntityType)FLBlockEntities.LIGHT.get());
    }

    public Light<?> getLight() {
        return this.light;
    }

    public void setItemStack(ItemStack stack) {
        this.light = new Light(0, Vector3d.field_186680_a, 0.0f, 0.0f, stack, (LightVariant)LightVariant.get((ICapabilityProvider)stack).orElse(SimpleLightVariant.FAIRY_LIGHT), 0.0f);
        this.func_70296_d();
    }

    private void setOn(boolean on) {
        this.on = on;
        this.light.power(on, true);
        this.func_70296_d();
    }

    public void interact(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        float pitch;
        SoundEvent lightSnd;
        this.setOn(!this.on);
        world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LightBlock.LIT, (Comparable)Boolean.valueOf(this.on)));
        if (this.on) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.field_145850_b.func_184133_a(null, pos, lightSnd, SoundCategory.BLOCKS, 1.0f, pitch);
    }

    public void animateTick() {
        BlockState state = this.func_195044_w();
        AttachFace face = (AttachFace)state.func_177229_b((Property)LightBlock.field_196366_M);
        float rotation = ((Direction)state.func_177229_b((Property)LightBlock.field_185512_D)).func_185119_l();
        MatrixStack matrix = new MatrixStack();
        matrix.translate(0.5f, 0.5f, 0.5f);
        matrix.rotate((float)Math.toRadians(180.0f - rotation), 0.0f, 1.0f, 0.0f);
        if (this.light.getVariant().isOrientable()) {
            if (face == AttachFace.WALL) {
                matrix.rotate(1.5707964f, 1.0f, 0.0f, 0.0f);
            } else if (face == AttachFace.FLOOR) {
                matrix.rotate((float)(-Math.PI), 1.0f, 0.0f, 0.0f);
            }
            matrix.translate(0.0f, 0.5f, 0.0f);
        } else if (face == AttachFace.CEILING) {
            matrix.translate(0.0f, 0.25f, 0.0f);
        } else if (face == AttachFace.WALL) {
            matrix.translate(0.0f, 0.1875f, 0.125f);
        } else {
            matrix.translate(0.0f, -((float)this.light.getVariant().getBounds().field_72338_b) - 0.5f, 0.0f);
        }
        this.light.getBehavior().animateTick(this.field_145850_b, Vector3d.func_237491_b_((Vector3i)this.func_174877_v()).func_178787_e(matrix.transform(Vector3d.field_186680_a)), this.light);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("item", (INBT)this.light.getItem().func_77955_b(new CompoundNBT()));
        compound.func_74757_a("on", this.on);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.setItemStack(ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("item")));
        this.setOn(compound.func_74767_n("on"));
    }
}

