/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.config.FLConfig;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FenceFastener;
import me.paulf.fairylights.server.fastener.PlayerFastener;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleManager;
import me.paulf.fairylights.server.net.clientbound.JingleMessage;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.item.LeashKnotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SBlockActionPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.management.PlayerList;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public final class ServerEventHandler {
    private final Random rng = new Random();
    private boolean eventOccurring = false;

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof PlayerEntity || entity instanceof FenceFastenerEntity) {
            entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(f -> f.setWorld(event.getWorld()));
        }
    }

    @SubscribeEvent
    public void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof PlayerEntity) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new PlayerFastener((PlayerEntity)entity));
        } else if (entity instanceof FenceFastenerEntity) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new FenceFastener((FenceFastenerEntity)entity));
        }
    }

    @SubscribeEvent
    public void onAttachBlockEntityCapability(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity entity = (TileEntity)event.getObject();
        if (entity instanceof FastenerBlockEntity) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new BlockFastener((FastenerBlockEntity)entity, ServerProxy.buildBlockView()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> {
                if (fastener.update() && !event.player.field_70170_p.field_72995_K) {
                    ServerProxy.sendToPlayersWatchingEntity(new UpdateEntityFastenerMessage((Entity)event.player, fastener.serializeNBT()), (Entity)event.player);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNoteBlockPlay(NoteBlockEvent.Play event) {
        World world = (World)event.getWorld();
        BlockPos pos = event.getPos();
        Block noteBlock = world.func_180495_p(pos).func_177230_c();
        BlockState below = world.func_180495_p(pos.func_177977_b());
        if (below.func_177230_c() == FLBlocks.FASTENER.get() && below.func_177229_b((Property)FastenerBlock.field_176387_N) == Direction.DOWN) {
            int note = event.getVanillaNoteId();
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            world.func_184133_a(null, pos, (SoundEvent)FLSounds.JINGLE_BELL.get(), SoundCategory.RECORDS, 3.0f, pitch);
            world.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, (double)note / 24.0, 0.0, 0.0);
            if (!world.field_72995_K) {
                SBlockActionPacket pkt = new SBlockActionPacket(pos, noteBlock, event.getInstrument().ordinal(), note);
                PlayerList players = world.func_73046_m().func_184103_al();
                players.func_148543_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0, world.func_234923_W_(), (IPacket)pkt);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        HangingEntity entity;
        ItemStack offhandStack;
        BlockPos pos;
        World world = event.getWorld();
        if (!(world.func_180495_p(pos = event.getPos()).func_177230_c() instanceof FenceBlock)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean checkHanging = stack.func_77973_b() == Items.field_151058_ca;
        PlayerEntity player = event.getPlayer();
        if (event.getHand() == Hand.MAIN_HAND && (offhandStack = player.func_184592_cb()).func_77973_b() instanceof ConnectionItem) {
            if (checkHanging) {
                event.setCanceled(true);
                return;
            }
            event.setUseBlock(Event.Result.DENY);
        }
        if (!checkHanging && !world.field_72995_K) {
            double range = 7.0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            AxisAlignedBB area = new AxisAlignedBB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0);
            for (MobEntity entity2 : world.func_217357_a(MobEntity.class, area)) {
                if (!entity2.func_110167_bD() || entity2.func_110166_bE() != player) continue;
                checkHanging = true;
                break;
            }
        }
        if (checkHanging && (entity = FenceFastenerEntity.findHanging(world, pos)) != null && !(entity instanceof LeashKnotEntity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT || !FLConfig.isJingleEnabled()) {
            return;
        }
        if (event.world.func_82737_E() % 6000L == 0L) {
            boolean bl = this.eventOccurring = FairyLights.CHRISTMAS.isOccurringNow() || FairyLights.HALLOWEEN.isOccurringNow();
        }
        if (this.eventOccurring && this.rng.nextFloat() < 1.6666666E-4f) {
            List connections;
            List<TileEntity> tileEntities = Collections.emptyList();
            try {
                tileEntities = new ArrayList<TileEntity>(event.world.field_175730_i);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            ArrayList playingSources = new ArrayList();
            HashMap feasibleConnections = new HashMap();
            for (TileEntity tileEntity : tileEntities) {
                tileEntity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> {
                    List<Vector3d> newPlayingSources = this.getPlayingLightSources(event.world, feasibleConnections, (Fastener<?>)fastener);
                    if (!newPlayingSources.isEmpty()) {
                        playingSources.addAll(newPlayingSources);
                    }
                });
            }
            ((ServerWorld)event.world).getEntities().forEach(entity -> entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> {
                List<Vector3d> newPlayingSources = this.getPlayingLightSources(event.world, feasibleConnections, (Fastener<?>)fastener);
                if (!newPlayingSources.isEmpty()) {
                    playingSources.addAll(newPlayingSources);
                }
            }));
            Iterator feasibleFasteners = feasibleConnections.keySet().iterator();
            while (feasibleFasteners.hasNext()) {
                Fastener fastener2 = (Fastener)feasibleFasteners.next();
                connections = (List)feasibleConnections.get(fastener2);
                connections.removeIf(connection -> this.isTooCloseTo(fastener2, (Light[])connection.getFeatures(), playingSources));
                if (connections.size() != 0) continue;
                feasibleFasteners.remove();
            }
            if (feasibleConnections.size() == 0) {
                return;
            }
            Fastener fastener2 = feasibleConnections.keySet().toArray(new Fastener[0])[this.rng.nextInt(feasibleConnections.size())];
            connections = (List)feasibleConnections.get(fastener2);
            HangingLightsConnection connection2 = (HangingLightsConnection)connections.get(this.rng.nextInt(connections.size()));
            ServerEventHandler.tryJingle(event.world, connection2, FairyLights.CHRISTMAS.isOccurringNow() ? "christmas" : "halloween");
        }
    }

    private List<Vector3d> getPlayingLightSources(World world, Map<Fastener<?>, List<HangingLightsConnection>> feasibleConnections, Fastener<?> fastener) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        double expandAmount = FLConfig.getJingleAmplitude();
        AxisAlignedBB listenerRegion = fastener.getBounds().func_72321_a(expandAmount, expandAmount, expandAmount);
        List nearPlayers = world.func_217357_a(PlayerEntity.class, listenerRegion);
        boolean arePlayersNear = nearPlayers.size() > 0;
        for (Connection connection : fastener.getOwnConnections()) {
            if (!connection.getDestination().get(world, false).isPresent() || !(connection instanceof HangingLightsConnection)) continue;
            HangingLightsConnection connectionLogic = (HangingLightsConnection)connection;
            Light[] lightPoints = (Light[])connectionLogic.getFeatures();
            if (connectionLogic.canCurrentlyPlayAJingle()) {
                if (!arePlayersNear) continue;
                if (feasibleConnections.containsKey(fastener)) {
                    feasibleConnections.get(fastener).add((HangingLightsConnection)connection);
                    continue;
                }
                ArrayList<HangingLightsConnection> connections = new ArrayList<HangingLightsConnection>();
                connections.add((HangingLightsConnection)connection);
                feasibleConnections.put(fastener, connections);
                continue;
            }
            for (Light light : lightPoints) {
                points.add(light.getAbsolutePoint(fastener));
            }
        }
        return points;
    }

    public boolean isTooCloseTo(Fastener<?> fastener, Light<?>[] lights, List<Vector3d> playingSources) {
        for (Light<?> light : lights) {
            for (Vector3d point : playingSources) {
                if (!(light.getAbsolutePoint(fastener).func_72438_d(point) <= (double)FLConfig.getJingleAmplitude())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean tryJingle(World world, HangingLightsConnection hangingLights, String lib) {
        if (world.field_72995_K) {
            return false;
        }
        Light[] lights = (Light[])hangingLights.getFeatures();
        Jingle jingle = JingleManager.INSTANCE.get(lib).getRandom(world.field_73012_v, lights.length);
        if (jingle != null) {
            int lightOffset = lights.length / 2 - jingle.getRange() / 2;
            hangingLights.play(jingle, lightOffset);
            ServerProxy.sendToPlayersWatchingChunk(new JingleMessage(hangingLights, lightOffset, jingle), world, hangingLights.getFastener().getPos());
            return true;
        }
        return false;
    }
}

