/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.model.light;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.MeteorLightBehavior;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class MeteorLightModel
extends LightModel<MeteorLightBehavior> {
    private final LightModel.BulbBuilder[] lights;
    private final ModelRenderer connector = new ModelRenderer((Model)this, 77, 0);
    private final ModelRenderer cap;
    private float stage;

    public MeteorLightModel() {
        this.connector.func_228301_a_(-1.0f, -0.5f, -1.0f, 2.0f, 2.0f, 2.0f, -0.05f);
        this.unlit.func_78792_a(this.connector);
        this.cap = new ModelRenderer((Model)this, 77, 0);
        this.cap.func_228301_a_(-1.0f, -25.400002f, -1.0f, 2.0f, 1.0f, 2.0f, 0.0f);
        this.unlit.func_78792_a(this.cap);
        int lightCount = 12;
        this.lights = new LightModel.BulbBuilder[12];
        float rodScale = 0.8f;
        LightModel.BulbBuilder bulb = this.createBulb();
        for (int i = 0; i < 12; ++i) {
            LightModel.BulbBuilder light = bulb.createChild(37, 72, (m, u, v) -> new ModelRenderer(m, u, v){

                public void func_228307_a_(MatrixStack stack) {
                    super.func_228307_a_(stack);
                    stack.func_227862_a_(0.8f, 1.0f, 0.8f);
                }
            });
            light.addBox(-1.0f, (float)(-i * 2) - 2.5f + 0.05f, -1.0f, 2.0f, 2.0f, 2.0f, MathHelper.func_76126_a((float)((float)i * (float)Math.PI / 12.0f)) * 0.1f);
            this.lights[i] = light;
        }
    }

    @Override
    public void animate(Light<?> light, MeteorLightBehavior behavior, float delta) {
        super.animate(light, behavior, delta);
        this.red = behavior.getRed(delta);
        this.green = behavior.getGreen(delta);
        this.blue = behavior.getBlue(delta);
        this.stage = behavior.getProgress(delta) * 3.0f - 1.0f;
    }

    private float computeBrightness(float t) {
        return MathHelper.func_76131_a((float)(t - this.stage > 0.0f ? 1.0f - Math.abs(t - this.stage) * 4.0f : 1.0f - Math.abs(t - this.stage)), (float)0.0f, (float)1.0f);
    }

    @Override
    public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            this.connector.field_78806_j = i == 0;
            this.cap.field_78806_j = i == this.lights.length - 1;
            super.func_225598_a_(matrix, builder, light, overlay, r, g, b, a);
        }
    }

    @Override
    public void renderTranslucent(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
        for (int i = 0; i < this.lights.length; ++i) {
            this.brightness = this.computeBrightness((float)i / (float)this.lights.length);
            for (int n = 0; n < this.lights.length; ++n) {
                this.lights[n].setVisible(i == n);
            }
            super.renderTranslucent(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

