/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import com.google.common.collect.ObjectArrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.util.ConnectionLocations;

public class TextureContextPillar
implements ITextureContext {
    private static final ConnectionLocations[] MAIN_VALUES = new ConnectionLocations[]{ConnectionLocations.UP, ConnectionLocations.DOWN, ConnectionLocations.NORTH, ConnectionLocations.SOUTH, ConnectionLocations.EAST, ConnectionLocations.WEST};
    private static final ConnectionLocations[] OFFSET_VALUES = (ConnectionLocations[])ArrayUtils.removeElements((Object[])ConnectionLocations.VALUES, (Object[])ObjectArrays.concat((Object[])new ConnectionLocations[]{ConnectionLocations.NORTH_EAST_UP, ConnectionLocations.NORTH_EAST_DOWN, ConnectionLocations.NORTH_WEST_UP, ConnectionLocations.NORTH_WEST_DOWN, ConnectionLocations.SOUTH_WEST_UP, ConnectionLocations.SOUTH_WEST_DOWN, ConnectionLocations.SOUTH_EAST_UP, ConnectionLocations.SOUTH_EAST_DOWN}, (Object[])MAIN_VALUES, ConnectionLocations.class));
    private static final ConnectionLocations[] ALL_VALUES = (ConnectionLocations[])ObjectArrays.concat((Object[])MAIN_VALUES, (Object[])OFFSET_VALUES, ConnectionLocations.class);
    private ConnectionData data;
    private long compressedData;

    public TextureContextPillar(IBlockReader world, BlockPos pos) {
        this.data = new ConnectionData(world, pos);
        BlockState state = world.func_180495_p(pos);
        for (ConnectionLocations loc : ALL_VALUES) {
            if (state != world.func_180495_p(loc.transform(pos))) continue;
            this.compressedData |= loc.getMask();
        }
    }

    public TextureContextPillar(long data) {
        this.data = new ConnectionData(data);
    }

    @Override
    public long getCompressedData() {
        return this.compressedData;
    }

    public ConnectionData getData() {
        return this.data;
    }

    public static class ConnectionData {
        private Connections connections;
        private Map<Direction, Connections> connectionConnections = new EnumMap<Direction, Connections>(Direction.class);

        public ConnectionData(IBlockReader world, BlockPos pos) {
            this.connections = Connections.forPos(world, pos);
            BlockState state = world.func_180495_p(pos);
            for (Direction f : Direction.values()) {
                this.connectionConnections.put(f, Connections.forPos(world, state, pos.func_177972_a(f)));
            }
        }

        public ConnectionData(long data) {
            this.connections = Connections.forData(data, null);
            for (Direction f : Direction.values()) {
                this.connectionConnections.put(f, Connections.forData(data, f));
            }
        }

        public Connections getConnections(Direction facing) {
            return this.connectionConnections.get(facing);
        }

        public String toString() {
            return "TextureContextPillar.ConnectionData(connections=" + this.getConnections() + ", connectionConnections=" + this.connectionConnections + ")";
        }

        public Connections getConnections() {
            return this.connections;
        }
    }

    public static class Connections {
        private EnumSet<Direction> connections;

        public boolean connected(Direction facing) {
            return this.connections.contains(facing);
        }

        public boolean connectedAnd(Direction ... facings) {
            for (Direction f : facings) {
                if (this.connected(f)) continue;
                return false;
            }
            return true;
        }

        public boolean connectedOr(Direction ... facings) {
            for (Direction f : facings) {
                if (!this.connected(f)) continue;
                return true;
            }
            return false;
        }

        public static Connections forPos(IBlockReader world, BlockPos pos) {
            BlockState state = world.func_180495_p(pos);
            return Connections.forPos(world, state, pos);
        }

        public static Connections forData(long data, Direction offset) {
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            if (offset == null) {
                for (ConnectionLocations loc : MAIN_VALUES) {
                    if ((data & loc.getMask()) == 0L) continue;
                    connections.add(ConnectionLocations.toFacing(loc));
                }
            } else {
                for (ConnectionLocations loc : OFFSET_VALUES) {
                    Direction facing;
                    if ((data & loc.getMask()) == 0L || (facing = loc.clipOrDestroy(offset)) == null) continue;
                    connections.add(facing);
                }
            }
            return new Connections(connections);
        }

        public static Connections forPos(IBlockReader world, BlockState baseState, BlockPos pos) {
            EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
            BlockState state = world.func_180495_p(pos);
            if (state == baseState) {
                for (Direction f : Direction.values()) {
                    if (world.func_180495_p(pos.func_177972_a(f)) != baseState) continue;
                    connections.add(f);
                }
            }
            return new Connections(connections);
        }

        public Connections(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public EnumSet<Direction> getConnections() {
            return this.connections;
        }

        public String toString() {
            return "TextureContextPillar.Connections(connections=" + this.getConnections() + ")";
        }
    }
}

