/*
 * Decompiled with CFR 0.152.
 */
package tfar.anviltweaks.mixin;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.AbstractRepairContainer;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RepairContainer;
import net.minecraft.util.IWorldPosCallable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tfar.anviltweaks.AnvilTile;
import tfar.anviltweaks.Configs;
import tfar.anviltweaks.RepairContainerDuck;

@Mixin(value={RepairContainer.class})
abstract class RepairContainerMixin
extends AbstractRepairContainer
implements RepairContainerDuck {
    private AnvilTile anvilTile;
    private boolean loading = false;

    public RepairContainerMixin(@Nullable ContainerType<?> p_i231587_1_, int p_i231587_2_, PlayerInventory p_i231587_3_, IWorldPosCallable p_i231587_4_) {
        super(p_i231587_1_, p_i231587_2_, p_i231587_3_, p_i231587_4_);
    }

    @Inject(method={"getNewRepairCost"}, at={@At(value="HEAD")}, cancellable=true)
    private static void removePriorWorkPenalty(int oldRepairCost, CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)Configs.ServerConfig.prior_work_penalty.get()).booleanValue()) {
            cir.setReturnValue((Object)0);
        }
    }

    @Override
    public boolean isLoading() {
        return this.loading;
    }

    @Override
    public boolean isClient() {
        return this.field_234645_f_.field_70170_p.field_72995_K;
    }

    @Inject(method={"getNewRepairCost"}, at={@At(value="RETURN")}, cancellable=true)
    private static void scalePriorWorkPenalty(int oldRepairCost, CallbackInfoReturnable<Integer> cir) {
        if (!((Boolean)Configs.ServerConfig.prior_work_penalty.get()).booleanValue() && !((Double)Configs.ServerConfig.prior_work_penalty_scale.get()).equals(2.0)) {
            cir.setReturnValue((Object)((int)((Double)Configs.ServerConfig.prior_work_penalty_scale.get() * (double)oldRepairCost + 1.0)));
        }
    }

    @Inject(method={"<init>(ILnet/minecraft/entity/player/PlayerInventory;Lnet/minecraft/util/IWorldPosCallable;)V"}, at={@At(value="RETURN")})
    private void addInventory(int id, PlayerInventory playerInventory, IWorldPosCallable posCallable, CallbackInfo ci) {
        posCallable.func_221486_a((world, pos) -> {
            this.anvilTile = (AnvilTile)world.func_175625_s(pos);
            this.loading = true;
            this.anvilTile.load(this.field_234643_d_);
            this.loading = false;
        });
    }

    @Override
    public AnvilTile getAnvilTile() {
        return this.anvilTile;
    }

    @ModifyConstant(method={"updateRepairOutput"}, constant={@Constant(intValue=39)})
    private int cheapRename(int cost) {
        return (Boolean)Configs.ServerConfig.cheap_renaming.get() != false ? 1 : 39;
    }

    @ModifyConstant(method={"updateRepairOutput"}, constant={@Constant(intValue=40)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/util/IntReferenceHolder;get()I", ordinal=1))})
    private int uncapRepairCost(int cost) {
        return (Integer)Configs.ServerConfig.repair_cost_cap.get();
    }
}

