/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.guns.init.ModParticleTypes;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.registries.ForgeRegistries;

public class TrailData
implements IParticleData {
    public static final Codec<TrailData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.fieldOf("enchanted").forGetter(data -> data.enchanted)).apply((Applicative)builder, TrailData::new));
    public static final IParticleData.IDeserializer<TrailData> DESERIALIZER = new IParticleData.IDeserializer<TrailData>(){

        public TrailData fromCommand(ParticleType<TrailData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            return new TrailData(reader.readBoolean());
        }

        public TrailData fromNetwork(ParticleType<TrailData> particleType, PacketBuffer buffer) {
            return new TrailData(buffer.readBoolean());
        }
    };
    private boolean enchanted;

    public TrailData(boolean enchanted) {
        this.enchanted = enchanted;
    }

    public boolean isEnchanted() {
        return this.enchanted;
    }

    public ParticleType<?> func_197554_b() {
        return (ParticleType)ModParticleTypes.TRAIL.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeBoolean(this.enchanted);
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.enchanted;
    }
}

