/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.init;

import com.mrcrayfish.guns.entity.GrenadeEntity;
import com.mrcrayfish.guns.entity.MissileEntity;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.entity.ThrowableGrenadeEntity;
import com.mrcrayfish.guns.entity.ThrowableStunGrenadeEntity;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"cgm");
    public static final RegistryObject<EntityType<ProjectileEntity>> PROJECTILE = ModEntities.registerProjectile("projectile", ProjectileEntity::new);
    public static final RegistryObject<EntityType<GrenadeEntity>> GRENADE = ModEntities.registerBasic("grenade", GrenadeEntity::new);
    public static final RegistryObject<EntityType<MissileEntity>> MISSILE = ModEntities.registerBasic("missile", MissileEntity::new);
    public static final RegistryObject<EntityType<ThrowableGrenadeEntity>> THROWABLE_GRENADE = ModEntities.registerBasic("throwable_grenade", ThrowableGrenadeEntity::new);
    public static final RegistryObject<EntityType<ThrowableStunGrenadeEntity>> THROWABLE_STUN_GRENADE = ModEntities.registerBasic("throwable_stun_grenade", ThrowableStunGrenadeEntity::new);

    private static <T extends Entity> RegistryObject<EntityType<T>> registerBasic(String id, BiFunction<EntityType<T>, World, T> function) {
        EntityType type = EntityType.Builder.func_220322_a(function::apply, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(100).setUpdateInterval(1).func_200705_b().func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a(id);
        return REGISTER.register(id, () -> type);
    }

    private static <T extends ProjectileEntity> RegistryObject<EntityType<T>> registerProjectile(String id, BiFunction<EntityType<T>, World, T> function) {
        EntityType type = EntityType.Builder.func_220322_a(function::apply, (EntityClassification)EntityClassification.MISC).func_220321_a(0.25f, 0.25f).setTrackingRange(0).func_200705_b().func_220320_c().setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> null).func_206830_a(id);
        return REGISTER.register(id, () -> type);
    }
}

