/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.client.GunRenderType;
import com.mrcrayfish.guns.client.SwayType;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.RecoilHandler;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.client.render.gun.ModelOverrides;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.event.GunFireEvent;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.guns.item.GrenadeItem;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.attachment.IAttachment;
import com.mrcrayfish.guns.item.attachment.IBarrel;
import com.mrcrayfish.guns.item.attachment.impl.Barrel;
import com.mrcrayfish.guns.item.attachment.impl.Scope;
import com.mrcrayfish.guns.util.GunEnchantmentHelper;
import com.mrcrayfish.guns.util.GunModifierHelper;
import com.mrcrayfish.guns.util.OptifineHelper;
import com.mrcrayfish.obfuscate.client.event.PlayerModelEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.LightType;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class GunRenderingHandler {
    private static GunRenderingHandler instance;
    public static final ResourceLocation MUZZLE_FLASH_TEXTURE;
    private final Random random = new Random();
    private final Set<Integer> entityIdForMuzzleFlash = new HashSet<Integer>();
    private final Set<Integer> entityIdForDrawnMuzzleFlash = new HashSet<Integer>();
    private final Map<Integer, Float> entityIdToRandomValue = new HashMap<Integer, Float>();
    private int sprintTransition;
    private int prevSprintTransition;
    private int sprintCooldown;
    private float sprintIntensity;
    private float offhandTranslate;
    private float prevOffhandTranslate;
    private Field equippedProgressMainHandField;
    private Field prevEquippedProgressMainHandField;
    private float immersiveWeaponRoll;
    private float immersiveRoll;
    private float prevImmersiveRoll;
    private float fallSway;
    private float prevFallSway;
    @Nullable
    private ItemStack renderingWeapon;

    public static GunRenderingHandler get() {
        if (instance == null) {
            instance = new GunRenderingHandler();
        }
        return instance;
    }

    private GunRenderingHandler() {
    }

    @Nullable
    public ItemStack getRenderingWeapon() {
        return this.renderingWeapon;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.updateSprinting();
        this.updateMuzzleFlash();
        this.updateOffhandTranslate();
        this.updateImmersiveCamera();
    }

    private void updateSprinting() {
        this.prevSprintTransition = this.sprintTransition;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71439_g.func_70051_ag() && !((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.SHOOTING)).booleanValue() && !((Boolean)SyncedPlayerData.instance().get((PlayerEntity)mc.field_71439_g, ModSyncedDataKeys.RELOADING)).booleanValue() && !AimingHandler.get().isAiming() && this.sprintCooldown == 0) {
            if (this.sprintTransition < 5) {
                ++this.sprintTransition;
            }
        } else if (this.sprintTransition > 0) {
            --this.sprintTransition;
        }
        if (this.sprintCooldown > 0) {
            --this.sprintCooldown;
        }
    }

    private void updateMuzzleFlash() {
        this.entityIdForMuzzleFlash.removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdToRandomValue.keySet().removeAll(this.entityIdForDrawnMuzzleFlash);
        this.entityIdForDrawnMuzzleFlash.clear();
        this.entityIdForDrawnMuzzleFlash.addAll(this.entityIdForMuzzleFlash);
    }

    private void updateOffhandTranslate() {
        this.prevOffhandTranslate = this.offhandTranslate;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        boolean down = false;
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        if (heldItem.func_77973_b() instanceof GunItem) {
            Gun modifiedGun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            down = !modifiedGun.getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem();
        }
        float direction = down ? -0.3f : 0.3f;
        this.offhandTranslate = MathHelper.func_76131_a((float)(this.offhandTranslate + direction), (float)0.0f, (float)1.0f);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        this.sprintTransition = 0;
        this.sprintCooldown = 20;
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (modifiedGun.getDisplay().getFlash() != null) {
            this.showMuzzleFlashForPlayer(Minecraft.func_71410_x().field_71439_g.func_145782_y());
        }
    }

    public void showMuzzleFlashForPlayer(int entityId) {
        this.entityIdForMuzzleFlash.add(entityId);
        this.entityIdToRandomValue.put(entityId, Float.valueOf(this.random.nextFloat()));
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderHandEvent event) {
        ClientPlayerEntity player;
        MatrixStack matrixStack = event.getMatrixStack();
        boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? event.getHand() == Hand.MAIN_HAND : event.getHand() == Hand.OFF_HAND;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == Hand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.func_77973_b() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            float offhand = 1.0f - MathHelper.func_219799_g((float)event.getPartialTicks(), (float)this.prevOffhandTranslate, (float)this.offhandTranslate);
            matrixStack.func_227861_a_(0.0, (double)(offhand * -0.6f), 0.0);
            player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && player.func_184614_ca().func_77973_b() instanceof GunItem && !(modifiedGun = ((GunItem)player.func_184614_ca().func_77973_b()).getModifiedGun(player.func_184614_ca())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                return;
            }
            matrixStack.func_227861_a_(0.0, -1.0 * AimingHandler.get().getNormalisedAdsProgress(), 0.0);
        }
        if (!(heldItem.func_77973_b() instanceof GunItem)) {
            return;
        }
        event.setCanceled(true);
        ItemStack overrideModel = ItemStack.field_190927_a;
        if (heldItem.func_77978_p() != null && heldItem.func_77978_p().func_150297_b("Model", 10)) {
            overrideModel = ItemStack.func_199557_a((CompoundNBT)heldItem.func_77978_p().func_74775_l("Model"));
        }
        player = Minecraft.func_71410_x().field_71439_g;
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(overrideModel.func_190926_b() ? heldItem : overrideModel, player.field_70170_p, (LivingEntity)player);
        float scaleX = model.func_177552_f().field_188039_n.field_178363_d.func_195899_a();
        float scaleY = model.func_177552_f().field_188039_n.field_178363_d.func_195900_b();
        float scaleZ = model.func_177552_f().field_188039_n.field_178363_d.func_195902_c();
        float translateX = model.func_177552_f().field_188039_n.field_178365_c.func_195899_a();
        float translateY = model.func_177552_f().field_188039_n.field_178365_c.func_195900_b();
        float translateZ = model.func_177552_f().field_188039_n.field_178365_c.func_195902_c();
        matrixStack.func_227860_a_();
        GunItem gunItem = (GunItem)heldItem.func_77973_b();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        if (AimingHandler.get().getNormalisedAdsProgress() > 0.0 && modifiedGun.canAimDownSight() && event.getHand() == Hand.MAIN_HAND) {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double zOffset = 0.0;
            Scope scope = Gun.getScope(heldItem);
            if (modifiedGun.canAttachType(IAttachment.Type.SCOPE) && scope != null) {
                double viewFinderOffset = scope.getViewFinderOffset();
                if (OptifineHelper.isShadersEnabled()) {
                    viewFinderOffset *= 0.75;
                }
                Gun.ScaledPositioned scaledPos = modifiedGun.getModules().getAttachments().getScope();
                xOffset = (double)(-translateX) + scaledPos.getXOffset() * 0.0625 * (double)scaleX;
                yOffset = (double)(-translateY) + (8.0 - scaledPos.getYOffset()) * 0.0625 * (double)scaleY - scope.getCenterOffset() * (double)scaleY * 0.0625 * scaledPos.getScale();
                zOffset = (double)(-translateZ) - scaledPos.getZOffset() * 0.0625 * (double)scaleZ + 0.72 - viewFinderOffset * (double)scaleZ * scaledPos.getScale();
            } else if (modifiedGun.getModules().getZoom() != null) {
                xOffset = (double)(-translateX) + modifiedGun.getModules().getZoom().getXOffset() * 0.0625 * (double)scaleX;
                yOffset = (double)(-translateY) + (8.0 - modifiedGun.getModules().getZoom().getYOffset()) * 0.0625 * (double)scaleY;
                zOffset = (double)(-translateZ) + modifiedGun.getModules().getZoom().getZOffset() * 0.0625 * (double)scaleZ;
            }
            float side = right ? 1.0f : -1.0f;
            double transition = 1.0 - Math.pow(1.0 - AimingHandler.get().getNormalisedAdsProgress(), 2.0);
            matrixStack.func_227861_a_(-0.56 * (double)side * transition, 0.52 * transition, 0.0);
            matrixStack.func_227861_a_(xOffset * (double)side * transition, yOffset * transition, zOffset * transition);
        }
        this.applyBobbingTransforms(matrixStack, event.getPartialTicks());
        float equipProgress = this.getEquipProgress(event.getPartialTicks());
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(equipProgress * -50.0f));
        HandSide hand = right ? HandSide.RIGHT : HandSide.LEFT;
        Objects.requireNonNull(player);
        this.renderReloadArm(matrixStack, event.getBuffers(), event.getLight(), modifiedGun, heldItem, hand, translateX);
        int offset = right ? 1 : -1;
        matrixStack.func_227861_a_(0.56 * (double)offset, -0.52, -0.72);
        this.applyAimingTransforms(matrixStack, translateX, translateY, translateZ, offset);
        this.applySwayTransforms(matrixStack, modifiedGun, player, translateX, translateY, translateZ, event.getPartialTicks());
        this.applySprintingTransforms(modifiedGun, hand, matrixStack, event.getPartialTicks());
        this.applyRecoilTransforms(matrixStack, heldItem, modifiedGun);
        this.applyReloadTransforms(matrixStack, event.getPartialTicks());
        int blockLight = player.func_70027_ad() ? 15 : player.field_70170_p.func_226658_a_(LightType.BLOCK, new BlockPos(player.func_174824_e(event.getPartialTicks())));
        blockLight += this.entityIdForMuzzleFlash.contains(player.func_145782_y()) ? 3 : 0;
        blockLight = Math.min(blockLight, 15);
        int packedLight = LightTexture.func_228451_a_((int)blockLight, (int)player.field_70170_p.func_226658_a_(LightType.SKY, new BlockPos(player.func_174824_e(event.getPartialTicks()))));
        matrixStack.func_227860_a_();
        modifiedGun.getGeneral().getGripType().getHeldAnimation().renderFirstPersonArms((PlayerEntity)Minecraft.func_71410_x().field_71439_g, hand, heldItem, matrixStack, event.getBuffers(), event.getLight(), event.getPartialTicks());
        matrixStack.func_227865_b_();
        ItemCameraTransforms.TransformType transformType = right ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
        this.renderWeapon((LivingEntity)Minecraft.func_71410_x().field_71439_g, heldItem, transformType, event.getMatrixStack(), event.getBuffers(), packedLight, event.getPartialTicks());
        matrixStack.func_227865_b_();
    }

    private void applyAimingTransforms(MatrixStack matrixStack, float x, float y, float z, int offset) {
        if (!((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            matrixStack.func_227861_a_((double)(x * (float)offset), (double)y, (double)z);
            matrixStack.func_227861_a_(0.0, -0.25, 0.25);
            float aiming = (float)Math.sin(Math.toRadians(AimingHandler.get().getNormalisedAdsProgress() * 180.0));
            aiming = (float)(1.0 - Math.cos((double)aiming * Math.PI / 2.0));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(aiming * 10.0f * (float)offset));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(aiming * 5.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(aiming * 5.0f * (float)offset));
            matrixStack.func_227861_a_(0.0, 0.25, -0.25);
            matrixStack.func_227861_a_((double)(-x * (float)offset), (double)(-y), (double)(-z));
        }
    }

    private void applyBobbingTransforms(MatrixStack matrixStack, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74336_f && mc.func_175606_aa() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)mc.func_175606_aa();
            float deltaDistanceWalked = player.field_70140_Q - player.field_70141_P;
            float distanceWalked = -(player.field_70140_Q + deltaDistanceWalked * partialTicks);
            float cameraYaw = MathHelper.func_219799_g((float)partialTicks, (float)player.field_71107_bF, (float)player.field_71109_bG);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-(Math.abs(MathHelper.func_76134_b((float)(distanceWalked * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f)));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-(MathHelper.func_76126_a((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 3.0f)));
            matrixStack.func_227861_a_((double)(-(MathHelper.func_76126_a((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 0.5f)), (double)(-(-Math.abs(MathHelper.func_76134_b((float)(distanceWalked * (float)Math.PI)) * cameraYaw))), 0.0);
            cameraYaw = (float)((double)cameraYaw * (player.func_70051_ag() ? 8.0 : 4.0));
            cameraYaw = (float)((double)cameraYaw * (Double)Config.CLIENT.display.bobbingIntensity.get());
            double invertZoomProgress = 1.0 - AimingHandler.get().getNormalisedAdsProgress() * (double)this.sprintIntensity;
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(distanceWalked * (float)Math.PI)) * cameraYaw * 3.0f * (float)invertZoomProgress));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(Math.abs(MathHelper.func_76134_b((float)(distanceWalked * (float)Math.PI - 0.2f)) * cameraYaw) * 5.0f * (float)invertZoomProgress));
        }
    }

    private void applySwayTransforms(MatrixStack matrixStack, Gun modifiedGun, ClientPlayerEntity player, float x, float y, float z, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.weaponSway.get()).booleanValue() && player != null) {
            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
            double zOffset = modifiedGun.getGeneral().getGripType().getHeldAnimation().getFallSwayZOffset();
            matrixStack.func_227861_a_(0.0, -0.25, zOffset);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)this.prevFallSway, (float)this.fallSway)));
            matrixStack.func_227861_a_(0.0, 0.25, -zOffset);
            float armPitch = MathHelper.func_219805_h((float)partialTicks, (float)player.field_71164_i, (float)player.field_71155_g);
            float headPitch = MathHelper.func_219805_h((float)partialTicks, (float)player.field_70127_C, (float)player.field_70125_A);
            float swayPitch = headPitch - armPitch;
            swayPitch = (float)((double)swayPitch * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            matrixStack.func_227863_a_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getPitchRotation().func_229187_a_(swayPitch * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            float armYaw = MathHelper.func_219805_h((float)partialTicks, (float)player.field_71163_h, (float)player.field_71154_f);
            float headYaw = MathHelper.func_219805_h((float)partialTicks, (float)player.field_70758_at, (float)player.field_70759_as);
            float swayYaw = headYaw - armYaw;
            swayYaw = (float)((double)swayYaw * (1.0 - 0.5 * AimingHandler.get().getNormalisedAdsProgress()));
            matrixStack.func_227863_a_(((SwayType)((Object)Config.CLIENT.display.swayType.get())).getYawRotation().func_229187_a_(swayYaw * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()));
            matrixStack.func_227861_a_((double)(-x), (double)(-y), (double)(-z));
        }
    }

    private void applySprintingTransforms(Gun modifiedGun, HandSide hand, MatrixStack matrixStack, float partialTicks) {
        if (((Boolean)Config.CLIENT.display.sprintAnimation.get()).booleanValue() && modifiedGun.getGeneral().getGripType().getHeldAnimation().canApplySprintingAnimation()) {
            float leftHanded = hand == HandSide.LEFT ? -1.0f : 1.0f;
            float transition = ((float)this.prevSprintTransition + (float)(this.sprintTransition - this.prevSprintTransition) * partialTicks) / 5.0f;
            transition = (float)Math.sin((double)transition * Math.PI / 2.0);
            matrixStack.func_227861_a_(-0.25 * (double)leftHanded * (double)transition, -0.1 * (double)transition, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f * leftHanded * transition));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-25.0f * transition));
        }
    }

    private void applyReloadTransforms(MatrixStack matrixStack, float partialTicks) {
        float reloadProgress = ReloadHandler.get().getReloadProgress(partialTicks);
        matrixStack.func_227861_a_(0.0, 0.35 * (double)reloadProgress, 0.0);
        matrixStack.func_227861_a_(0.0, 0.0, -0.1 * (double)reloadProgress);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(45.0f * reloadProgress));
    }

    private void applyRecoilTransforms(MatrixStack matrixStack, ItemStack item, Gun gun) {
        double recoilNormal = RecoilHandler.get().getGunRecoilNormal();
        if (Gun.hasAttachmentEquipped(item, gun, IAttachment.Type.SCOPE)) {
            recoilNormal -= recoilNormal * (0.5 * AimingHandler.get().getNormalisedAdsProgress());
        }
        float kickReduction = 1.0f - GunModifierHelper.getKickReduction(item);
        float recoilReduction = 1.0f - GunModifierHelper.getRecoilModifier(item);
        double kick = (double)gun.getGeneral().getRecoilKick() * 0.0625 * recoilNormal * RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilLift = (float)((double)gun.getGeneral().getRecoilAngle() * recoilNormal) * (float)RecoilHandler.get().getAdsRecoilReduction(gun);
        float recoilSwayAmount = (float)(2.0 + 1.0 * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        float recoilSway = (float)((double)(RecoilHandler.get().getGunRecoilRandom() * recoilSwayAmount - recoilSwayAmount / 2.0f) * recoilNormal);
        matrixStack.func_227861_a_(0.0, 0.0, kick * (double)kickReduction);
        matrixStack.func_227861_a_(0.0, 0.0, 0.15);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(recoilSway * recoilReduction));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(recoilSway * recoilReduction));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(recoilLift * recoilReduction));
        matrixStack.func_227861_a_(0.0, 0.0, -0.15);
    }

    @SubscribeEvent
    public void onTick(TickEvent.RenderTickEvent event) {
        float coolDown;
        Gun gun;
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!mc.func_195544_aj()) {
            return;
        }
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (Minecraft.func_71410_x().field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) {
            return;
        }
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (player.func_184587_cr() && player.func_184600_cs() == Hand.MAIN_HAND && heldItem.func_77973_b() instanceof GrenadeItem) {
            float cookTime;
            if (!((GrenadeItem)heldItem.func_77973_b()).canCook()) {
                return;
            }
            int duration = player.func_184612_cw();
            if (duration >= 10 && (cookTime = 1.0f - (float)(duration - 10) / (float)(player.func_184607_cu().func_77988_m() - 10)) > 0.0f) {
                double scale = 3.0;
                MainWindow window = mc.func_228018_at_();
                int i = (int)((double)(window.func_198087_p() / 2 - 7 - 60) / scale);
                int j = (int)Math.ceil(((double)(window.func_198107_o() / 2) - 8.0 * scale) / scale);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                RenderSystem.pushMatrix();
                RenderSystem.scaled((double)scale, (double)scale, (double)scale);
                int progress = (int)Math.ceil(cookTime * 17.0f) - 1;
                MatrixStack matrixStack = new MatrixStack();
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
                Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
                RenderSystem.popMatrix();
                RenderSystem.disableBlend();
            }
            return;
        }
        if (((Boolean)Config.CLIENT.display.cooldownIndicator.get()).booleanValue() && heldItem.func_77973_b() instanceof GunItem && !(gun = ((GunItem)heldItem.func_77973_b()).getGun()).getGeneral().isAuto() && (coolDown = player.func_184811_cZ().func_185143_a(heldItem.func_77973_b(), event.renderTickTime)) > 0.0f) {
            double scale = 3.0;
            MainWindow window = mc.func_228018_at_();
            int i = (int)((double)(window.func_198087_p() / 2 - 7 - 60) / scale);
            int j = (int)Math.ceil(((double)(window.func_198107_o() / 2) - 8.0 * scale) / scale);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)scale, (double)scale, (double)scale);
            int progress = (int)Math.ceil(((double)coolDown + 0.05) * 17.0) - 1;
            MatrixStack matrixStack = new MatrixStack();
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)36.0f, (float)94.0f, (int)16, (int)4, (int)256, (int)256);
            Screen.func_238463_a_((MatrixStack)matrixStack, (int)j, (int)i, (float)52.0f, (float)94.0f, (int)progress, (int)4, (int)256, (int)256);
            RenderSystem.popMatrix();
            RenderSystem.disableBlend();
        }
    }

    @SubscribeEvent
    public void onRenderHeldItem(RenderItemEvent.Held.Pre event) {
        Hand hand = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? (event.getHandSide() == HandSide.RIGHT ? Hand.MAIN_HAND : Hand.OFF_HAND) : (event.getHandSide() == HandSide.LEFT ? Hand.MAIN_HAND : Hand.OFF_HAND);
        LivingEntity entity = event.getEntity();
        ItemStack heldItem = entity.func_184586_b(hand);
        if (hand == Hand.OFF_HAND) {
            Gun modifiedGun;
            if (heldItem.func_77973_b() instanceof GunItem) {
                event.setCanceled(true);
                return;
            }
            if (entity.func_184614_ca().func_77973_b() instanceof GunItem && !(modifiedGun = ((GunItem)entity.func_184614_ca().func_77973_b()).getModifiedGun(entity.func_184614_ca())).getGeneral().getGripType().getHeldAnimation().canRenderOffhandItem()) {
                event.setCanceled(true);
                return;
            }
        }
        if (heldItem.func_77973_b() instanceof GunItem) {
            event.setCanceled(true);
            this.applyWeaponScale(heldItem, event.getMatrixStack());
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            if (entity instanceof PlayerEntity) {
                gun.getGeneral().getGripType().getHeldAnimation().applyHeldItemTransforms((PlayerEntity)entity, hand, AimingHandler.get().getAimProgress((PlayerEntity)entity, event.getPartialTicks()), event.getMatrixStack(), event.getRenderTypeBuffer());
            }
            this.renderWeapon(entity, heldItem, event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks());
        }
    }

    private void applyWeaponScale(ItemStack heldItem, MatrixStack stack) {
        CompoundNBT compound;
        if (heldItem.func_77978_p() != null && (compound = heldItem.func_77978_p()).func_150297_b("Scale", 5)) {
            float scale = compound.func_74760_g("Scale");
            stack.func_227862_a_(scale, scale, scale);
        }
    }

    @SubscribeEvent
    public void onSetupAngles(PlayerModelEvent.SetupAngles.Post event) {
        if (event.getAgeInTicks() == 0.0f) {
            event.getModelPlayer().field_178723_h.field_78795_f = 0.0f;
            event.getModelPlayer().field_178723_h.field_78796_g = 0.0f;
            event.getModelPlayer().field_178723_h.field_78808_h = 0.0f;
            event.getModelPlayer().field_178724_i.field_78795_f = 0.0f;
            event.getModelPlayer().field_178724_i.field_78796_g = 0.0f;
            event.getModelPlayer().field_178724_i.field_78808_h = 0.0f;
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            PlayerModel model = event.getModelPlayer();
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerModelRotation(player, model, Hand.MAIN_HAND, AimingHandler.get().getAimProgress((PlayerEntity)event.getEntity(), event.getPartialTicks()));
            GunRenderingHandler.copyModelAngles(model.field_178723_h, model.field_178732_b);
            GunRenderingHandler.copyModelAngles(model.field_178724_i, model.field_178734_a);
        }
    }

    private static void copyModelAngles(ModelRenderer source, ModelRenderer dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184614_ca();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            gun.getGeneral().getGripType().getHeldAnimation().applyPlayerPreRender(player, Hand.MAIN_HAND, AimingHandler.get().getAimProgress((PlayerEntity)event.getEntity(), event.getPartialRenderTick()), event.getMatrixStack(), event.getBuffers());
        }
    }

    @SubscribeEvent
    public void onModelRender(PlayerModelEvent.Render.Pre event) {
        PlayerEntity player = event.getPlayer();
        ItemStack offHandStack = player.func_184592_cb();
        if (offHandStack.func_77973_b() instanceof GunItem) {
            switch (player.func_184591_cq().func_188468_a()) {
                case LEFT: {
                    event.getModelPlayer().field_187075_l = BipedModel.ArmPose.EMPTY;
                    break;
                }
                case RIGHT: {
                    event.getModelPlayer().field_187076_m = BipedModel.ArmPose.EMPTY;
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(PlayerModelEvent.Render.Post event) {
        MatrixStack matrixStack = event.getMatrixStack();
        PlayerEntity player = event.getPlayer();
        ItemStack heldItem = player.func_184592_cb();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof GunItem) {
            matrixStack.func_227860_a_();
            Gun gun = ((GunItem)heldItem.func_77973_b()).getModifiedGun(heldItem);
            if (gun.getGeneral().getGripType().getHeldAnimation().applyOffhandTransforms(player, event.getModelPlayer(), heldItem, matrixStack, event.getPartialTicks())) {
                IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
                this.renderWeapon((LivingEntity)player, heldItem, ItemCameraTransforms.TransformType.FIXED, matrixStack, (IRenderTypeBuffer)buffer, event.getLight(), event.getPartialTicks());
            }
            matrixStack.func_227865_b_();
        }
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Entity.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getItem().func_77973_b() instanceof GunItem) {
            this.applyWeaponScale(event.getItem(), event.getMatrixStack());
        }
        event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
    }

    @SubscribeEvent
    public void onRenderEntityItem(RenderItemEvent.Gui.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
    }

    @SubscribeEvent
    public void onRenderItemFrame(RenderItemEvent.ItemFrame.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        event.setCanceled(this.renderWeapon((LivingEntity)mc.field_71439_g, event.getItem(), event.getTransformType(), event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getPartialTicks()));
    }

    public boolean renderWeapon(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof GunItem) {
            matrixStack.func_227860_a_();
            ItemStack model = ItemStack.field_190927_a;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("Model", 10)) {
                model = ItemStack.func_199557_a((CompoundNBT)stack.func_77978_p().func_74775_l("Model"));
            }
            RenderUtil.applyTransformType(model.func_190926_b() ? stack : model, matrixStack, transformType, entity);
            this.renderingWeapon = stack;
            this.renderGun(entity, transformType, model.func_190926_b() ? stack : model, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderAttachments(entity, transformType, stack, matrixStack, renderTypeBuffer, light, partialTicks);
            this.renderMuzzleFlash(entity, matrixStack, renderTypeBuffer, stack, transformType, partialTicks);
            this.renderingWeapon = null;
            matrixStack.func_227865_b_();
            return true;
        }
        return false;
    }

    private void renderGun(LivingEntity entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (ModelOverrides.hasModel(stack)) {
            IOverrideModel model = ModelOverrides.getModel(stack);
            if (model != null) {
                model.render(partialTicks, transformType, stack, ItemStack.field_190927_a, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
            }
        } else {
            IBakedModel bakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_, bakedModel);
        }
    }

    private void renderAttachments(LivingEntity entity, ItemCameraTransforms.TransformType transformType, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, float partialTicks) {
        if (stack.func_77973_b() instanceof GunItem) {
            Gun gun = ((GunItem)stack.func_77973_b()).getModifiedGun(stack);
            CompoundNBT gunTag = stack.func_196082_o();
            CompoundNBT attachments = gunTag.func_74775_l("Attachments");
            for (String tagKey : attachments.func_150296_c()) {
                Gun.ScaledPositioned positioned;
                ItemStack attachmentStack;
                IAttachment.Type type = IAttachment.Type.byTagKey(tagKey);
                if (!gun.canAttachType(type) || (attachmentStack = Gun.getAttachment(type, stack)).func_190926_b() || (positioned = gun.getAttachmentPosition(type)) == null) continue;
                matrixStack.func_227860_a_();
                double displayX = positioned.getXOffset() * 0.0625;
                double displayY = positioned.getYOffset() * 0.0625;
                double displayZ = positioned.getZOffset() * 0.0625;
                matrixStack.func_227861_a_(displayX, displayY, displayZ);
                matrixStack.func_227861_a_(0.0, -0.5, 0.0);
                matrixStack.func_227862_a_((float)positioned.getScale(), (float)positioned.getScale(), (float)positioned.getScale());
                IOverrideModel model = ModelOverrides.getModel(attachmentStack);
                if (model != null) {
                    model.render(partialTicks, transformType, attachmentStack, stack, entity, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_);
                } else {
                    IBakedModel bakedModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(attachmentStack);
                    Minecraft.func_71410_x().func_175599_af().func_229111_a_(attachmentStack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, renderTypeBuffer, light, OverlayTexture.field_229196_a_, bakedModel);
                }
                matrixStack.func_227865_b_();
            }
        }
    }

    private void renderMuzzleFlash(LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, ItemStack weapon, ItemCameraTransforms.TransformType transformType, float partialTicks) {
        Gun modifiedGun = ((GunItem)weapon.func_77973_b()).getModifiedGun(weapon);
        if (modifiedGun.getDisplay().getFlash() == null) {
            return;
        }
        if ((transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND || transformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND || transformType == ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND) && this.entityIdForMuzzleFlash.contains(entity.func_145782_y())) {
            float randomValue;
            this.drawMuzzleFlash(weapon, modifiedGun, randomValue, (randomValue = this.entityIdToRandomValue.get(entity.func_145782_y()).floatValue()) >= 0.5f, matrixStack, buffer, partialTicks);
        }
    }

    private void drawMuzzleFlash(ItemStack weapon, Gun modifiedGun, float random, boolean flip, MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks) {
        matrixStack.func_227860_a_();
        Gun.Display.Flash muzzleFlash = modifiedGun.getDisplay().getFlash();
        if (muzzleFlash == null) {
            return;
        }
        double displayX = muzzleFlash.getXOffset() * 0.0625;
        double displayY = muzzleFlash.getYOffset() * 0.0625;
        double displayZ = muzzleFlash.getZOffset() * 0.0625;
        matrixStack.func_227861_a_(displayX, displayY, displayZ);
        matrixStack.func_227861_a_(0.0, -0.5, 0.0);
        ItemStack barrelStack = Gun.getAttachment(IAttachment.Type.BARREL, weapon);
        if (!barrelStack.func_190926_b() && barrelStack.func_77973_b() instanceof IBarrel) {
            Barrel barrel = (Barrel)((IBarrel)barrelStack.func_77973_b()).getProperties();
            Gun.ScaledPositioned positioned = modifiedGun.getModules().getAttachments().getBarrel();
            if (positioned != null) {
                matrixStack.func_227861_a_(0.0, 0.0, (double)(-barrel.getLength()) * 0.0625 * positioned.getScale());
            }
        }
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.0f);
        float scale = 0.5f + 0.5f * (1.0f - partialTicks);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        double partialSize = modifiedGun.getDisplay().getFlash().getSize() / 5.0;
        float size = (float)(modifiedGun.getDisplay().getFlash().getSize() - partialSize + partialSize * (double)random);
        size = (float)GunModifierHelper.getMuzzleFlashSize(weapon, size);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(360.0f * random));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(flip ? 180.0f : 0.0f));
        matrixStack.func_227861_a_((double)(-size / 2.0f), (double)(-size / 2.0f), 0.0);
        float minU = weapon.func_77948_v() ? 0.5f : 0.0f;
        float maxU = weapon.func_77948_v() ? 1.0f : 0.5f;
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder builder = buffer.getBuffer(GunRenderType.getMuzzleFlash());
        builder.func_227888_a_(matrix, 0.0f, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, size, 0.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, 1.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, size, size, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        builder.func_227888_a_(matrix, 0.0f, size, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, 0.0f).func_227886_a_(0xF000F0).func_181675_d();
        matrixStack.func_227865_b_();
    }

    private void renderReloadArm(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, Gun modifiedGun, ItemStack stack, HandSide hand, float translateX) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71439_g.field_70173_aa < ReloadHandler.get().getStartReloadTick() || ReloadHandler.get().getReloadTimer() != 5) {
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(modifiedGun.getProjectile().getItem());
        if (item == null) {
            return;
        }
        matrixStack.func_227860_a_();
        int side = hand.func_188468_a() == HandSide.RIGHT ? 1 : -1;
        matrixStack.func_227861_a_((double)(translateX * (float)side), 0.0, 0.0);
        float interval = GunEnchantmentHelper.getReloadInterval(stack);
        float reload = ((float)(mc.field_71439_g.field_70173_aa - ReloadHandler.get().getStartReloadTick()) + mc.func_184121_ak()) % interval / interval;
        float percent = 1.0f - reload;
        if (percent >= 0.5f) {
            percent = 1.0f - percent;
        }
        percent = (double)(percent *= 2.0f) < 0.5 ? 2.0f * percent * percent : -1.0f + (4.0f - 2.0f * percent) * percent;
        matrixStack.func_227861_a_(3.5 * (double)side * 0.0625, -0.5625, -0.5625);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227861_a_(0.0, -0.35 * (1.0 - (double)percent), 0.0);
        matrixStack.func_227861_a_((double)side * 0.0625, 0.0, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(35.0f * (float)(-side)));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-75.0f * percent));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        RenderUtil.renderFirstPersonArm(mc.field_71439_g, hand.func_188468_a(), matrixStack, buffer, light);
        if (reload < 0.5f) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(-side * 5) * 0.0625, 0.9375, -0.0625);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
            matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
            ItemStack ammo = new ItemStack((IItemProvider)item, modifiedGun.getGeneral().getReloadAmount());
            IBakedModel model = RenderUtil.getModel(ammo);
            boolean isModel = model.func_177556_c();
            this.random.setSeed(Item.func_150891_b((Item)item));
            int count = Math.min(modifiedGun.getGeneral().getReloadAmount(), 5);
            for (int i = 0; i < count; ++i) {
                matrixStack.func_227860_a_();
                if (i > 0) {
                    float y;
                    float x;
                    if (isModel) {
                        x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float z = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        matrixStack.func_227861_a_((double)x, (double)y, (double)z);
                    } else {
                        x = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        y = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
                    }
                }
                RenderUtil.renderModel(ammo, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, matrixStack, buffer, light, OverlayTexture.field_229196_a_, null);
                matrixStack.func_227865_b_();
                if (isModel) continue;
                matrixStack.func_227861_a_(0.0, 0.0, 0.09375);
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private float getEquipProgress(float partialTicks) {
        if (this.equippedProgressMainHandField == null) {
            this.equippedProgressMainHandField = ObfuscationReflectionHelper.findField(FirstPersonRenderer.class, (String)"field_187469_f");
            this.equippedProgressMainHandField.setAccessible(true);
        }
        if (this.prevEquippedProgressMainHandField == null) {
            this.prevEquippedProgressMainHandField = ObfuscationReflectionHelper.findField(FirstPersonRenderer.class, (String)"field_187470_g");
            this.prevEquippedProgressMainHandField.setAccessible(true);
        }
        FirstPersonRenderer firstPersonRenderer = Minecraft.func_71410_x().func_175597_ag();
        try {
            float equippedProgressMainHand = ((Float)this.equippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            float prevEquippedProgressMainHand = ((Float)this.prevEquippedProgressMainHandField.get(firstPersonRenderer)).floatValue();
            return 1.0f - MathHelper.func_219799_g((float)partialTicks, (float)prevEquippedProgressMainHand, (float)equippedProgressMainHand);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    private void updateImmersiveCamera() {
        this.prevImmersiveRoll = this.immersiveRoll;
        this.prevFallSway = this.fallSway;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        ItemStack heldItem = mc.field_71439_g.func_184614_ca();
        float targetAngle = heldItem.func_77973_b() instanceof GunItem ? mc.field_71439_g.field_71158_b.field_78902_a : 0.0f;
        float speed = mc.field_71439_g.field_71158_b.field_78902_a != 0.0f ? 0.1f : 0.15f;
        this.immersiveRoll = MathHelper.func_219799_g((float)speed, (float)this.immersiveRoll, (float)targetAngle);
        float deltaY = (float)MathHelper.func_151237_a((double)(mc.field_71439_g.field_70167_r - mc.field_71439_g.func_226278_cu_()), (double)-1.0, (double)1.0);
        deltaY = (float)((double)deltaY * (1.0 - AimingHandler.get().getNormalisedAdsProgress()));
        deltaY = (float)((double)deltaY * (1.0 - (double)(MathHelper.func_76135_e((float)mc.field_71439_g.field_70125_A) / 90.0f)));
        this.fallSway = MathHelper.func_203300_b((float)this.fallSway, (float)(deltaY * 60.0f * ((Double)Config.CLIENT.display.swaySensitivity.get()).floatValue()), (float)10.0f);
        float intensity = mc.field_71439_g.func_70051_ag() ? 0.75f : 1.0f;
        this.sprintIntensity = MathHelper.func_203300_b((float)this.sprintIntensity, (float)intensity, (float)0.1f);
    }

    @SubscribeEvent
    public void onCameraSetup(EntityViewRenderEvent.CameraSetup event) {
        if (((Boolean)Config.CLIENT.display.cameraRollEffect.get()).booleanValue()) {
            float roll = (float)MathHelper.func_219803_d((double)event.getRenderPartialTicks(), (double)this.prevImmersiveRoll, (double)this.immersiveRoll);
            roll = (float)Math.sin((double)roll * Math.PI / 2.0);
            event.setRoll(-(roll *= ((Double)Config.CLIENT.display.cameraRollAngle.get()).floatValue()));
        }
    }

    static {
        MUZZLE_FLASH_TEXTURE = new ResourceLocation("cgm", "textures/effect/muzzle_flash.png");
    }
}

