/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.java.utility.nullness;

import java.util.Objects;
import java.util.function.Supplier;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.java.utility.nullness.NullableType;

@FunctionalInterface
public interface NullableSupplier<@NullableType T>
extends Supplier<T> {
    @Override
    public T get();

    default public T getNonnull() {
        return this.getNonnull(() -> "Unexpected null value from supplier");
    }

    default public T getNonnull(NonnullSupplier<String> errorMessage) {
        return Objects.requireNonNull(this.get(), errorMessage);
    }

    default public NonnullSupplier<T> asNonnull() {
        return this::getNonnull;
    }

    default public NonnullSupplier<T> asNonnull(NonnullSupplier<String> errorMessage) {
        return () -> this.getNonnull(errorMessage);
    }
}

