/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.entry;

import com.mojang.serialization.Codec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.fml.RegistryObject;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.data.template.TemplatePools;
import xyz.apex.forge.utility.registrator.entry.RegistryEntry;
import xyz.apex.java.utility.nullness.NonnullSupplier;

public final class StructureEntry<STRUCTURE extends Structure<FEATURE_CONFIG>, FEATURE_CONFIG extends IFeatureConfig>
extends RegistryEntry<STRUCTURE>
implements NonnullSupplier<STRUCTURE> {
    private final TemplatePools templatePool;

    public StructureEntry(AbstractRegistrator<?> registrator, RegistryObject<STRUCTURE> delegate, TemplatePools templatePool) {
        super(registrator, delegate);
        this.templatePool = templatePool;
    }

    public TemplatePools getTemplatePool() {
        return this.templatePool;
    }

    @Nullable
    public JigsawPattern getJigsawPattern(DynamicRegistries registries) {
        return (JigsawPattern)registries.func_243612_b(Registry.field_243555_ax).func_82594_a(this.templatePool.getPoolName());
    }

    public Structure<?> asStructure() {
        return (Structure)this.get();
    }

    public GenerationStage.Decoration step() {
        return this.asStructure().func_236396_f_();
    }

    public Codec<StructureFeature<FEATURE_CONFIG, Structure<FEATURE_CONFIG>>> configuredFeatureCodec() {
        return ((Structure)this.get()).func_236398_h_();
    }

    public StructureFeature<FEATURE_CONFIG, ? extends Structure<FEATURE_CONFIG>> configured(FEATURE_CONFIG featureConfig) {
        return ((Structure)this.get()).func_236391_a_(featureConfig);
    }

    @Nullable
    public BlockPos getNearestGenerationFeature(IWorldReader level, StructureManager structureManager, BlockPos pos, int searchRadius, boolean skipKnownStructures, long seed, StructureSeparationSettings separationSettings) {
        return this.asStructure().func_236388_a_(level, structureManager, pos, searchRadius, skipKnownStructures, seed, separationSettings);
    }

    public ChunkPos getPotentialFeatureConfig(StructureSeparationSettings separationSettings, long seed, SharedSeedRandom rng, int x, int z) {
        return this.asStructure().func_236392_a_(separationSettings, seed, rng, x, z);
    }

    public StructureStart<?> generate(DynamicRegistries registries, ChunkGenerator generator, BiomeProvider biomeProvider, TemplateManager templateManager, long seed, ChunkPos chunkPos, Biome biome, int references, SharedSeedRandom rng, StructureSeparationSettings separationSettings, FEATURE_CONFIG featureConfig) {
        return ((Structure)this.get()).func_242785_a(registries, generator, biomeProvider, templateManager, seed, chunkPos, biome, references, rng, separationSettings, featureConfig);
    }

    public Structure.IStartFactory<?> getStartFactory() {
        return this.asStructure().func_214557_a();
    }

    public String getFeatureName() {
        return this.asStructure().func_143025_a();
    }

    public List<MobSpawnInfo.Spawners> getSpecialEnemies() {
        return this.asStructure().func_202279_e();
    }

    public List<MobSpawnInfo.Spawners> getSpecialAnimals() {
        return this.asStructure().func_214469_f();
    }

    public List<MobSpawnInfo.Spawners> getSpawnList(EntityClassification entityClassification) {
        return this.asStructure().getSpawnList(entityClassification);
    }

    public static <STRUCTURE extends Structure<FEATURE_CONFIG>, FEATURE_CONFIG extends IFeatureConfig> StructureEntry<STRUCTURE, FEATURE_CONFIG> cast(RegistryEntry<STRUCTURE> registryEntry) {
        return StructureEntry.cast(StructureEntry.class, registryEntry);
    }

    public static <STRUCTURE extends Structure<FEATURE_CONFIG>, FEATURE_CONFIG extends IFeatureConfig> StructureEntry<STRUCTURE, FEATURE_CONFIG> cast(xyz.apex.repack.com.tterrag.registrate.util.entry.RegistryEntry<STRUCTURE> registryEntry) {
        return StructureEntry.cast(StructureEntry.class, registryEntry);
    }
}

