/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.particles.ParticleType;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ParticleProvider
implements IDataProvider {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger LOGGER = LogManager.getLogger();
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(ResourcePackType.CLIENT_RESOURCES, ".png", "textures");
    protected final DataGenerator generator;
    protected final ExistingFileHelper fileHelper;
    private final Map<ResourceLocation, ParticleDefinition> particleDefinitions = Maps.newHashMap();

    protected ParticleProvider(DataGenerator generator, ExistingFileHelper fileHelper) {
        this.generator = generator;
        this.fileHelper = fileHelper;
    }

    protected abstract void registerParticleDefs();

    public final void func_200398_a(DirectoryCache cache) throws IOException {
        this.particleDefinitions.clear();
        this.registerParticleDefs();
        this.validateParticleDefs();
        Path dataPath = this.generator.func_200391_b().resolve("assets");
        this.particleDefinitions.forEach((particleName, def) -> ParticleProvider.saveParticleDefinition(cache, particleName, def, dataPath));
    }

    public String func_200397_b() {
        return "Particles";
    }

    private void validateParticleDefs() {
        this.particleDefinitions.forEach((particleName, definition) -> {
            for (ResourceLocation texture : ((ParticleDefinition)definition).textures) {
                ResourceLocation relativePath = new ResourceLocation(texture.func_110624_b(), "particle/" + texture.func_110623_a());
                Preconditions.checkArgument((boolean)this.fileHelper.exists(relativePath, (ExistingFileHelper.IResourceType)TEXTURE), (String)"Texture %s does not exist in any known resource pack", (Object)relativePath);
            }
        });
    }

    public static void saveParticleDefinition(DirectoryCache cache, ResourceLocation particleName, ParticleDefinition definition, Path dataPath) {
        try {
            Path particlePath = dataPath.resolve(Paths.get(particleName.func_110624_b(), "particles", particleName.func_110623_a() + ".json"));
            JsonElement serialized = ParticleProvider.serializeParticleDefinition(definition);
            IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)serialized, (Path)particlePath);
        }
        catch (IOException e) {
            LOGGER.error("Couldn't save ParticleDefinition {}", (Object)particleName);
        }
    }

    private static JsonElement serializeParticleDefinition(ParticleDefinition definition) {
        JsonObject json = new JsonObject();
        JsonArray texturesJson = new JsonArray();
        definition.textures.stream().map(Object::toString).forEach(arg_0 -> ((JsonArray)texturesJson).add(arg_0));
        json.add("textures", (JsonElement)texturesJson);
        return json;
    }

    public ParticleDefinition definition(ParticleType<?> particleType) {
        ResourceLocation name = Objects.requireNonNull(particleType.getRegistryName());
        return this.particleDefinitions.computeIfAbsent(name, $ -> new ParticleDefinition());
    }

    public final class ParticleDefinition {
        private final Set<ResourceLocation> textures = Sets.newHashSet();

        private ParticleDefinition() {
        }

        public ParticleDefinition texture(ResourceLocation texture) {
            this.textures.add(texture);
            return this;
        }

        public ParticleDefinition textures(ResourceLocation ... textures) {
            Collections.addAll(this.textures, textures);
            return this;
        }

        public ParticleDefinition texture(String namespace, String texturePath) {
            return this.texture(new ResourceLocation(namespace, texturePath));
        }
    }
}

