/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.Validate;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.data.ParticleProvider;
import xyz.apex.forge.utility.registrator.entry.ParticleEntry;
import xyz.apex.forge.utility.registrator.factory.ParticleFactory;
import xyz.apex.java.utility.nullness.NonnullConsumer;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class ParticleBuilder<OWNER extends AbstractRegistrator<OWNER>, PARTICLE extends IParticleData, PARENT>
extends RegistratorBuilder<OWNER, ParticleType<?>, ParticleType<PARTICLE>, PARENT, ParticleBuilder<OWNER, PARTICLE, PARENT>, ParticleEntry<PARTICLE>> {
    private final ParticleFactory<PARTICLE> particleFactory;
    @Nullable
    private NonnullSupplier<Supplier<IParticleFactory<PARTICLE>>> factory = null;
    @Nullable
    private NonnullSupplier<Supplier<ParticleManager.IParticleMetaFactory<PARTICLE>>> metaFactory = null;
    private NonnullConsumer<ParticleProvider.ParticleDefinition> particleDefinitionConsumer = NonnullConsumer.noop();

    public ParticleBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, ParticleFactory<PARTICLE> particleFactory) {
        super(owner, parent, registryName, callback, ParticleType.class, ParticleEntry::new, ParticleEntry::cast);
        this.particleFactory = particleFactory;
        this.onRegister((T particleType) -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> owner.getModBus().addListener(EventPriority.NORMAL, false, ParticleFactoryRegisterEvent.class, event -> {
            ParticleManager particleEngine = Minecraft.func_71410_x().field_71452_i;
            if (this.factory != null) {
                particleEngine.func_199283_a(particleType, this.factory.get().get());
            }
            if (this.metaFactory != null) {
                particleEngine.func_215234_a(particleType, this.metaFactory.get().get());
            }
        })));
        this.setDataGenerator(AbstractRegistrator.PARTICLE_PROVIDER, (ctx, provider) -> this.particleDefinitionConsumer.accept(provider.definition((ParticleType)ctx.get())));
    }

    @Override
    @NonnullType
    protected ParticleType<PARTICLE> createEntry() {
        return this.particleFactory.create();
    }

    public ParticleBuilder<OWNER, PARTICLE, PARENT> definition(NonnullConsumer<ParticleProvider.ParticleDefinition> particleDefinitionConsumer) {
        this.particleDefinitionConsumer = particleDefinitionConsumer.andThen(particleDefinitionConsumer);
        return this;
    }

    public ParticleBuilder<OWNER, PARTICLE, PARENT> factory(NonnullSupplier<Supplier<IParticleFactory<PARTICLE>>> particleFactory) {
        Validate.isTrue((this.metaFactory == null ? 1 : 0) != 0, (String)"Can only specify a IParticleFactory or IParticleMetaFactory never BOTH!!", (Object[])new Object[0]);
        Validate.isTrue((this.factory == null ? 1 : 0) != 0, (String)"IParticleFactory has already been set!", (Object[])new Object[0]);
        this.factory = particleFactory;
        return this;
    }

    public ParticleBuilder<OWNER, PARTICLE, PARENT> metaFactory(NonnullSupplier<Supplier<ParticleManager.IParticleMetaFactory<PARTICLE>>> particleFactory) {
        Validate.isTrue((this.factory == null ? 1 : 0) != 0, (String)"Can only specify a IParticleFactory or IParticleMetaFactory never BOTH!!", (Object[])new Object[0]);
        Validate.isTrue((this.metaFactory == null ? 1 : 0) != 0, (String)"IParticleMetaFactory has already been set!", (Object[])new Object[0]);
        this.metaFactory = particleFactory;
        return this;
    }
}

