/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.utility.registrator.builder;

import com.google.common.collect.Sets;
import com.mojang.datafixers.DSL;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xyz.apex.forge.utility.registrator.AbstractRegistrator;
import xyz.apex.forge.utility.registrator.builder.RegistratorBuilder;
import xyz.apex.forge.utility.registrator.entry.BlockEntityEntry;
import xyz.apex.forge.utility.registrator.factory.BlockEntityFactory;
import xyz.apex.java.utility.nullness.NonnullFunction;
import xyz.apex.java.utility.nullness.NonnullSupplier;
import xyz.apex.repack.com.tterrag.registrate.builders.BuilderCallback;
import xyz.apex.repack.com.tterrag.registrate.util.OneTimeEventReceiver;
import xyz.apex.repack.com.tterrag.registrate.util.nullness.NonnullType;

public final class BlockEntityBuilder<OWNER extends AbstractRegistrator<OWNER>, BLOCK_ENTITY extends TileEntity, PARENT>
extends RegistratorBuilder<OWNER, TileEntityType<?>, TileEntityType<BLOCK_ENTITY>, PARENT, BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT>, BlockEntityEntry<BLOCK_ENTITY>> {
    private final BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory;
    private final Set<NonnullSupplier<? extends Block>> validBlocks = Sets.newHashSet();
    @Nullable
    private NonnullSupplier<NonnullFunction<TileEntityRendererDispatcher, TileEntityRenderer<? super BLOCK_ENTITY>>> renderer = null;

    public BlockEntityBuilder(OWNER owner, PARENT parent, String registryName, BuilderCallback callback, BlockEntityFactory<BLOCK_ENTITY> blockEntityFactory) {
        super(owner, parent, registryName, callback, TileEntityType.class, BlockEntityEntry::new, BlockEntityEntry::cast);
        this.blockEntityFactory = blockEntityFactory;
        this.onRegister(this::onRegister);
    }

    @Override
    private void onRegister(TileEntityType<BLOCK_ENTITY> blockEntityType) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, event -> event.enqueueWork(() -> this.registerRenderer(blockEntityType))));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerRenderer(TileEntityType<BLOCK_ENTITY> blockEntityType) {
        if (this.renderer != null) {
            ClientRegistry.bindTileEntityRenderer(blockEntityType, (Function)this.renderer.get());
        }
    }

    @Override
    @NonnullType
    protected TileEntityType<BLOCK_ENTITY> createEntry() {
        NonnullSupplier supplier = this.toSupplier();
        Block[] validBlocks = (Block[])this.validBlocks.stream().map(NonnullSupplier::get).toArray(Block[]::new);
        TileEntityType.Builder builder = TileEntityType.Builder.func_223042_a(() -> this.blockEntityFactory.create((TileEntityType)supplier.get()), (Block[])validBlocks);
        return builder.func_206865_a(Util.func_240976_a_((DSL.TypeReference)TypeReferences.field_211294_j, (String)this.getRegistryNameFull()));
    }

    public BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> validBlock(NonnullSupplier<? extends Block> block) {
        this.validBlocks.add(block);
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> validBlocks(NonnullSupplier<? extends Block> ... blocks) {
        Collections.addAll(this.validBlocks, blocks);
        return this;
    }

    public BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> renderer(NonnullSupplier<NonnullFunction<TileEntityRendererDispatcher, TileEntityRenderer<? super BLOCK_ENTITY>>> renderer) {
        this.renderer = renderer;
        return this;
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> tag(ITag.INamedTag<TileEntityType<?>> ... tags) {
        return (BlockEntityBuilder)this.tag(AbstractRegistrator.BLOCK_ENTITY_TAGS_PROVIDER, tags);
    }

    @SafeVarargs
    public final BlockEntityBuilder<OWNER, BLOCK_ENTITY, PARENT> removeTag(ITag.INamedTag<TileEntityType<?>> ... tags) {
        return (BlockEntityBuilder)this.removeTag(AbstractRegistrator.BLOCK_ENTITY_TAGS_PROVIDER, tags);
    }
}

