/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.net.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.net.AbstractPacket;
import xyz.apex.forge.apexcore.lib.net.NetworkManager;
import xyz.apex.forge.apexcore.revamp.block.entity.InventoryBlockEntity;

public final class SyncContainerPacket
extends AbstractPacket {
    private final BlockPos pos;
    private final PacketBuffer buffer;

    private SyncContainerPacket(BlockPos pos, PacketBuffer buffer) {
        this.pos = pos;
        this.buffer = buffer;
    }

    public SyncContainerPacket(PacketBuffer buffer) {
        super(buffer);
        this.pos = buffer.func_179259_c();
        this.buffer = buffer;
    }

    @Override
    protected void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeBytes((ByteBuf)this.buffer);
    }

    @Override
    protected void process(NetworkManager network, NetworkEvent.Context ctx) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::processClient);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processClient() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null) {
            return;
        }
        TileEntity tileEntity = mc.field_71441_e.func_175625_s(this.pos);
        if (tileEntity instanceof InventoryBlockEntity) {
            ((InventoryBlockEntity)tileEntity).readContainerSyncData(this.buffer);
        }
    }

    public static void sendToClient(InventoryBlockEntity blockEntity) {
        World level = blockEntity.func_145831_w();
        if (level == null || level.field_72995_K) {
            return;
        }
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        blockEntity.writeContainerSyncData(buffer);
        BlockPos blockPos = blockEntity.func_174877_v();
        ApexCore.NETWORK.sendTo((AbstractPacket)new SyncContainerPacket(blockPos, buffer), PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)192.0, (RegistryKey)level.func_234923_W_())));
    }
}

