/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.revamp.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerProvider;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.INameable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import xyz.apex.forge.apexcore.lib.util.ContainerHelper;
import xyz.apex.forge.apexcore.lib.util.INameableMutable;
import xyz.apex.java.utility.nullness.NonnullConsumer;

public class BaseBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING_4_WAY = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BaseBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.blockConstructor();
    }

    @OverridingMethodsMustInvokeSuper
    protected void registerProperties(NonnullConsumer<Property<?>> consumer) {
    }

    @OverridingMethodsMustInvokeSuper
    protected void preBlockConstructor() {
    }

    private void postBlockConstructor() {
        StateContainer.Builder builder = new StateContainer.Builder((Object)this);
        this.registerProperties(xva$0 -> builder.func_206894_a(new Property[]{xva$0}));
        StateContainer stateDefinition = builder.func_235882_a_(Block::func_176223_P, BlockState::new);
        BlockState defaultBlockState = (BlockState)stateDefinition.func_177621_b();
        defaultBlockState = BaseBlock.setFacing(defaultBlockState, Direction.NORTH);
        defaultBlockState = BaseBlock.setWaterLogged(defaultBlockState, false);
        this.func_180632_j(defaultBlockState);
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)stateDefinition, (String)"field_176227_L");
    }

    private void blockConstructor() {
        this.preBlockConstructor();
        this.postBlockConstructor();
    }

    public final BlockState func_196258_a(BlockItemUseContext ctx) {
        BlockState blockState = this.func_176223_P();
        World level = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        if (BaseBlock.supportsWaterLogging(blockState)) {
            FluidState fluidState = level.func_204610_c(pos);
            boolean waterLogged = fluidState.func_206884_a((ITag)FluidTags.field_206959_a) && fluidState.func_206889_d();
            blockState = BaseBlock.setWaterLogged(blockState, waterLogged);
        }
        if (BaseBlock.supportsFacing(blockState)) {
            blockState = BaseBlock.setFacing(blockState, this.getFourWayFacing(ctx));
        }
        return blockState;
    }

    public BlockState func_196271_a(BlockState blockState, Direction facing, BlockState facingBlockState, IWorld level, BlockPos pos, BlockPos facingPos) {
        if (BaseBlock.isWaterLogged(blockState)) {
            level.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)level));
        }
        return super.func_196271_a(blockState, facing, facingBlockState, level, pos, facingPos);
    }

    protected final void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
    }

    public final BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        if (BaseBlock.supportsFacing(blockState)) {
            return BaseBlock.setFacing(blockState, rotation.func_185831_a(BaseBlock.getFacing(blockState)));
        }
        return blockState;
    }

    public final BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        if (BaseBlock.supportsFacing(blockState)) {
            return blockState.func_185907_a(mirror.func_185800_a(BaseBlock.getFacing(blockState)));
        }
        return blockState;
    }

    public boolean func_200123_i(BlockState blockState, IBlockReader level, BlockPos pos) {
        if (BaseBlock.supportsWaterLogging(blockState)) {
            return !BaseBlock.isWaterLogged(blockState);
        }
        return super.func_200123_i(blockState, level, pos);
    }

    public final FluidState func_204507_t(BlockState blockState) {
        return BaseBlock.isWaterLogged(blockState) ? Fluids.field_204546_a.func_207204_a(false) : Fluids.field_204541_a.func_207188_f();
    }

    public final boolean func_204510_a(IBlockReader level, BlockPos pos, BlockState blockState, Fluid fluid) {
        return BaseBlock.supportsWaterLogging(blockState) && super.func_204510_a(level, pos, blockState, fluid);
    }

    public final boolean func_204509_a(IWorld level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return BaseBlock.supportsWaterLogging(blockState) && super.func_204509_a(level, pos, blockState, fluidState);
    }

    public final Fluid func_204508_a(IWorld level, BlockPos pos, BlockState blockState) {
        return BaseBlock.supportsWaterLogging(blockState) ? super.func_204508_a(level, pos, blockState) : Fluids.field_204541_a;
    }

    public static boolean supportsWaterLogging(BlockState blockState) {
        return blockState.func_235901_b_((Property)WATERLOGGED);
    }

    public static boolean isWaterLogged(BlockState blockState) {
        return blockState.func_235903_d_((Property)WATERLOGGED).orElse(false);
    }

    public static BlockState setWaterLogged(BlockState blockState, boolean waterLogged) {
        return BaseBlock.supportsWaterLogging(blockState) ? (BlockState)blockState.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged)) : blockState;
    }

    protected Direction getFourWayFacing(BlockItemUseContext ctx) {
        return ctx.func_195992_f().func_176734_d();
    }

    public static boolean supportsFacing(BlockState blockState) {
        return blockState.func_235901_b_((Property)FACING_4_WAY);
    }

    public static Direction getFacing(BlockState blockState) {
        return blockState.func_235903_d_((Property)FACING_4_WAY).orElse(Direction.NORTH);
    }

    public static BlockState setFacing(BlockState blockState, Direction facing) {
        return BaseBlock.supportsFacing(blockState) ? (BlockState)blockState.func_206870_a((Property)FACING_4_WAY, (Comparable)facing) : blockState;
    }

    public static abstract class WithContainer<BLOCK_ENTITY extends TileEntity, CONTAINER extends Container>
    extends WithBlockEntity<BLOCK_ENTITY> {
        public WithContainer(AbstractBlock.Properties properties) {
            super(properties);
        }

        protected abstract ContainerType<CONTAINER> getContainerType();

        protected final ActionResultType tryOpenContainerScreen(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            INamedContainerProvider provider = this.func_220052_b(blockState, level, pos);
            if (provider != null) {
                if (level.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                if (player instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)provider, buffer -> buffer.func_179255_a(pos));
                    return ActionResultType.CONSUME;
                }
            }
            return ActionResultType.PASS;
        }

        public final boolean func_149740_M(BlockState blockState) {
            return true;
        }

        public final int func_180641_l(BlockState blockState, World level, BlockPos pos) {
            return ContainerHelper.getRedstoneSignalFromContainer((IBlockReader)level, pos);
        }

        public ActionResultType func_225533_a_(BlockState blockState, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            return this.tryOpenContainerScreen(blockState, level, pos, player, hand, rayTraceResult);
        }

        @OverridingMethodsMustInvokeSuper
        public void func_180633_a(World level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
            super.func_180633_a(level, pos, blockState, placer, stack);
            Object blockEntity = this.getBlockEntity((IBlockReader)level, pos);
            if (blockEntity instanceof INameableMutable && stack.func_82837_s()) {
                ITextComponent customName = stack.func_200301_q();
                ((INameableMutable)blockEntity).setCustomName(customName);
            }
        }

        @OverridingMethodsMustInvokeSuper
        public void func_196243_a(BlockState blockState, World level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
            Object blockEntity;
            if (!blockState.func_203425_a(newBlockState.func_177230_c()) && (blockEntity = this.getBlockEntity((IBlockReader)level, pos)) != null) {
                blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        InventoryHelper.func_180173_a((World)level, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
                    }
                });
            }
            super.func_196243_a(blockState, level, pos, newBlockState, isMoving);
        }

        @Override
        @Nullable
        public final INamedContainerProvider func_220052_b(BlockState blockState, World level, BlockPos pos) {
            Object blockEntity = this.getBlockEntity((IBlockReader)level, pos);
            if (blockEntity != null) {
                TranslationTextComponent containerName = new TranslationTextComponent(this.func_149739_a());
                if (blockEntity instanceof INameable) {
                    containerName = ((INameable)blockEntity).func_145748_c_();
                }
                return new SimpleNamedContainerProvider((windowId, playerInventory, player) -> {
                    PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
                    buffer.func_179255_a(pos);
                    return this.getContainerType().create(windowId, playerInventory, buffer);
                }, (ITextComponent)containerName);
            }
            return super.func_220052_b(blockState, level, pos);
        }
    }

    public static abstract class WithBlockEntity<BLOCK_ENTITY extends TileEntity>
    extends BaseBlock
    implements ITileEntityProvider {
        public WithBlockEntity(AbstractBlock.Properties properties) {
            super(properties);
        }

        protected abstract TileEntityType<BLOCK_ENTITY> getBlockEntityType();

        @Nullable
        protected final BLOCK_ENTITY getBlockEntity(IBlockReader level, BlockPos pos) {
            return (BLOCK_ENTITY)this.getBlockEntityType().func_226986_a_(level, pos);
        }

        public final boolean func_189539_a(BlockState blockState, World level, BlockPos pos, int event, int param) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity((IBlockReader)level, pos);
            return blockEntity != null && blockEntity.func_145842_c(event, param);
        }

        @Nullable
        public final TileEntity func_196283_a_(IBlockReader level) {
            return this.getBlockEntityType().func_200968_a();
        }

        @Nullable
        public final TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return this.getBlockEntityType().func_200968_a();
        }

        public final boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public INamedContainerProvider func_220052_b(BlockState blockState, World level, BlockPos pos) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity((IBlockReader)level, pos);
            if (blockEntity instanceof INamedContainerProvider) {
                return (INamedContainerProvider)blockEntity;
            }
            if (blockEntity instanceof IContainerProvider) {
                TranslationTextComponent containerName = new TranslationTextComponent(this.func_149739_a());
                if (blockEntity instanceof INameable) {
                    containerName = ((INameable)blockEntity).func_145748_c_();
                }
                return new SimpleNamedContainerProvider((IContainerProvider)blockEntity, (ITextComponent)containerName);
            }
            return null;
        }
    }
}

