/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util.reflection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import xyz.apex.forge.apexcore.core.ApexCore;
import xyz.apex.forge.apexcore.lib.util.reflection.Fields;

public class FieldHelper {
    private static final Marker MARKER = MarkerManager.getMarker((String)"FieldReflection");
    private static final Cache<String, Field> fieldsCache = CacheBuilder.newBuilder().weakValues().build();
    private static final Field MODIFIERS;

    @Nullable
    public static <E> E getPrivateValue(@Nullable Object instance, Fields field) {
        Validate.notNull((Object)((Object)field), (String)"Field to find cannot be null", (Object[])new Object[0]);
        return FieldHelper.getPrivateValue(field.getClassToAccess(), instance, field.getFieldName());
    }

    @Nullable
    public static <E> E getPrivateValue(Class<?> classToAccess, @Nullable Object instance, String fieldName) {
        Validate.notNull(classToAccess, (String)"Class to find field cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Name of field to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field to find cannot be blank.", (Object[])new Object[0]);
        try {
            Field field = FieldHelper.findField(classToAccess, fieldName);
            return (E)field.get(instance);
        }
        catch (UnableToFindFieldException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToFindFieldException(e);
        }
    }

    public static Field findField(Class<?> classToAccess, String fieldName) {
        Validate.notNull(classToAccess, (String)"Class to find field cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Name of field to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field to find cannot be blank.", (Object[])new Object[0]);
        try {
            return (Field)fieldsCache.get((Object)fieldName, () -> FieldHelper.cacheField(classToAccess, fieldName));
        }
        catch (ExecutionException e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static Field findField(Fields field) {
        Validate.notNull((Object)((Object)field), (String)"Field to find cannot be null", (Object[])new Object[0]);
        return FieldHelper.findField(field.getClassToAccess(), field.getFieldName());
    }

    private static Field cacheField(Class<?> classToAccess, String fieldName) {
        Validate.notNull(classToAccess, (String)"Class to find field cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Name of field to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field to find cannot be blank.", (Object[])new Object[0]);
        try {
            Field field = classToAccess.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static <E> E setPrivateValue(@Nullable Object instance, @Nullable E newValue, Fields field) {
        Validate.notNull((Object)((Object)field), (String)"Field to find cannot be null", (Object[])new Object[0]);
        return FieldHelper.setPrivateValue(field.getClassToAccess(), instance, newValue, field.getFieldName());
    }

    public static <E> E setPrivateValue(Class<?> classToAccess, @Nullable Object instance, @Nullable E newValue, String fieldName) {
        Validate.notNull(classToAccess, (String)"Class to find field cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Name of field to find cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field to find cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field to find cannot be blank.", (Object[])new Object[0]);
        try {
            Field field = FieldHelper.findField(classToAccess, fieldName);
            Object oldValue = field.get(instance);
            field.set(instance, newValue);
            return (E)oldValue;
        }
        catch (UnableToFindFieldException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
        catch (IllegalAccessException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw new UnableToFindFieldException(e);
        }
    }

    public static String getObfuscatedFieldName(Fields field) {
        Validate.notNull((Object)((Object)field), (String)"Field cannot be null", (Object[])new Object[0]);
        String fieldName = field.getFieldNameRaw();
        if (field.isObfuscated()) {
            return FieldHelper.getObfuscatedFieldName(fieldName);
        }
        return fieldName;
    }

    public static String getObfuscatedFieldName(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"Name of field cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field cannot be blank.", (Object[])new Object[0]);
        return ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)fieldName);
    }

    public static void removeFinalModifier(Class<?> classToAccess, String fieldName) {
        Validate.notNull(classToAccess, (String)"Class to find field cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Name of field to to remove final modifier from cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"Name of field to to remove final modifier from cannot be empty", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fieldName, (String)"Name of field to to remove final modifier from cannot be blank.", (Object[])new Object[0]);
        try {
            Field field = FieldHelper.findField(classToAccess, fieldName);
            FieldHelper.removeFinalModifier(field);
        }
        catch (UnableToFindFieldException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to locate field {} on type {}", (Object)fieldName, (Object)classToAccess.getName(), (Object)e);
            throw e;
        }
    }

    public static void removeFinalModifier(Field field) {
        Validate.notNull((Object)field, (String)"Field to remove final modifier cannot be null", (Object[])new Object[0]);
        try {
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers)) {
                MODIFIERS.setInt(field, modifiers & 0xFFFFFFEF);
            }
        }
        catch (IllegalAccessException e) {
            ApexCore.LOGGER.error(MARKER, "Unable to remove final modifier from Field '{}'", (Object)field.getName(), (Object)e);
            throw new UnableToFindFieldException(e);
        }
    }

    static {
        try {
            MODIFIERS = Field.class.getDeclaredField("modifiers");
            MODIFIERS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new UnableToFindFieldException(e);
        }
    }

    public static class UnableToFindFieldException
    extends RuntimeException {
        public UnableToFindFieldException(Exception e) {
            super(e);
        }
    }
}

